/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.endpoint;

import java.util.Vector;
import net.jxta.endpoint.EndpointAddress;
import net.jxta.endpoint.EndpointListener;
import net.jxta.endpoint.Message;
import org.apache.log4j.Category;
import org.apache.log4j.Priority;

public class EndpointDemuxListener
implements EndpointListener,
Runnable {
    private static final Category LOG = Category.getInstance((String)(class$net$jxta$impl$endpoint$EndpointDemuxListener == null ? (class$net$jxta$impl$endpoint$EndpointDemuxListener = EndpointDemuxListener.class$("net.jxta.impl.endpoint.EndpointDemuxListener")) : class$net$jxta$impl$endpoint$EndpointDemuxListener).getName());
    public static final int MaxQueueSize = 100;
    private Vector messageQueue = new Vector();
    private boolean keepGoing = true;
    private EndpointListener listener = null;
    private int nbOfQueuedMessages = 0;
    private int nbOfDeQueuedMessages = 0;
    private Thread thread1 = null;
    private Thread thread2 = null;
    private String name = null;
    static /* synthetic */ Class class$net$jxta$impl$endpoint$EndpointDemuxListener;

    private synchronized void enQueue(Message m) {
        if (this.messageQueue.size() > 100) {
            if (LOG.isEnabledFor(Priority.WARN)) {
                LOG.warn((Object)("Dropped one message; destination: " + m.getDestinationAddress().toString()));
            }
            this.notify();
            return;
        }
        this.messageQueue.addElement(m);
        ++this.nbOfQueuedMessages;
        this.setThreadName();
        this.notify();
    }

    private synchronized Message deQueue() {
        while (this.messageQueue.size() == 0) {
            if (!this.keepGoing) {
                return null;
            }
            try {
                this.wait();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        Object o = this.messageQueue.elementAt(0);
        this.messageQueue.removeElementAt(0);
        ++this.nbOfDeQueuedMessages;
        this.setThreadName();
        return (Message)o;
    }

    public EndpointListener getListener() {
        return this.listener;
    }

    public EndpointDemuxListener(EndpointListener listener) {
        this("Unknown", listener);
    }

    public EndpointDemuxListener(String name, EndpointListener listener) {
        this.listener = listener;
        this.name = name;
        this.thread1 = new Thread((Runnable)this, "EndpointDemuxListener [" + name + "]");
        this.thread2 = new Thread((Runnable)this, "EndpointDemuxListener [" + name + "]");
        this.thread1.start();
        this.thread2.start();
        Thread.yield();
    }

    private void setThreadName() {
        block3: {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                String newName = "EndpointDemuxListener [" + this.name + "," + this.messageQueue.size() + "," + this.nbOfQueuedMessages + "," + this.nbOfDeQueuedMessages + "]";
                try {
                    this.thread1.setName(newName);
                    this.thread2.setName(newName);
                }
                catch (Exception ez1) {
                    if (!LOG.isEnabledFor(Priority.ERROR)) break block3;
                    LOG.error((Object)"EndpointDemuxListener cannot set thread name ", (Throwable)ez1);
                }
            }
        }
    }

    public synchronized void unregistered() {
        this.keepGoing = false;
        this.notifyAll();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        try {
            while (true) {
                if (!this.keepGoing) {
                    return;
                }
                Message message = this.deQueue();
                if (!this.keepGoing) {
                    return;
                }
                try {
                    EndpointAddress srcAddr = message.getSourceAddress();
                    EndpointAddress dstAddr = message.getDestinationAddress();
                    this.listener.processIncomingMessage(message, srcAddr, dstAddr);
                }
                catch (Throwable ignored) {
                    if (!LOG.isEnabledFor(Priority.DEBUG)) continue;
                    LOG.debug((Object)"EndpointDemuxListener caught an exception", ignored);
                }
            }
        }
        catch (Throwable all) {
            if (!LOG.isEnabledFor(Priority.FATAL)) return;
            LOG.fatal((Object)("Uncaught Throwable in thread : " + Thread.currentThread().getName()), all);
        }
    }

    public void processIncomingMessage(Message message, EndpointAddress srcAddr, EndpointAddress dstAddr) {
        message.setSourceAddress(srcAddr);
        message.setDestinationAddress(dstAddr);
        this.enQueue(message);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        MaxQueueSize = 100;
    }
}

