/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.document;

import java.util.Enumeration;
import java.util.Vector;

public class MimeMediaType {
    private String type = null;
    private String subtype = null;
    private Vector parameters = new Vector();
    private static final String CTL = "\u0000\u0001\u0002\u0003\u0004\u0005\u0006\u0007\b\t\n\u000b\f\r\u000e\u000f\u0010\u0011\u0012\u0013\u0014\u0015\u0016\u0017\u0018\u0019\u001a\u001b\u001c\u001d\u001e\u001f\u007f";
    private static final String space = " ";
    private static final String tspecials = "()<>@,;:\\\"/[]?=";
    private static final String terminator = "\u0000\u0001\u0002\u0003\u0004\u0005\u0006\u0007\b\t\n\u000b\f\r\u000e\u000f\u0010\u0011\u0012\u0013\u0014\u0015\u0016\u0017\u0018\u0019\u001a\u001b\u001c\u001d\u001e\u001f\u007f ()<>@,;:\\\"/[]?=";

    public MimeMediaType(String someString) {
        if (null == someString) {
            throw new IllegalArgumentException("input cannot be null");
        }
        String cleaned = someString.trim().toLowerCase();
        if (0 == cleaned.length()) {
            throw new IllegalArgumentException("input cannot be null");
        }
        int typeSepAt = this.findNextSeperator(cleaned);
        if (-1 == typeSepAt || 0 == typeSepAt) {
            throw new IllegalArgumentException("expected seperator or seperator in unexpected location");
        }
        String itsType = cleaned.substring(0, typeSepAt);
        int subtypeSepAt = MimeMediaType.findNextSeperator(cleaned, typeSepAt + 1);
        String itsSubType = null;
        String itsParams = null;
        if (-1 == subtypeSepAt) {
            itsSubType = cleaned.substring(typeSepAt + 1);
        } else {
            itsSubType = cleaned.substring(typeSepAt + 1, subtypeSepAt);
            itsParams = cleaned.substring(subtypeSepAt);
        }
        Vector someParams = new Vector();
        this.setType(itsType);
        this.setSubtype(itsSubType);
        this.setParameters(new String[0]);
    }

    public MimeMediaType(String type, String subtype) {
        this(type, subtype, (String)null);
    }

    public MimeMediaType(String type, String subtype, String parameters) {
        Vector someParams = new Vector();
        if (null != parameters) {
            // empty if block
        }
        this.setType(type);
        this.setSubtype(subtype);
        this.setParameters(new String[0]);
    }

    public MimeMediaType(String type, String subtype, String[] parameters) {
        this.setType(type);
        this.setSubtype(subtype);
        this.setParameters(parameters);
    }

    public Object clone() {
        MimeMediaType retValue = new MimeMediaType(this.toString());
        return retValue;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof MimeMediaType)) {
            return false;
        }
        boolean retValue = this.hashCode() == obj.hashCode();
        return retValue;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String toString() {
        if (!this.isValid()) {
            return null;
        }
        String retValue = this.type + "/" + this.subtype;
        Enumeration eachParameter = this.parameters.elements();
        while (eachParameter.hasMoreElements()) {
            retValue = retValue + ";" + (String)eachParameter.nextElement();
        }
        return retValue;
    }

    public boolean isValid() {
        boolean result = null != this.type && null != this.subtype;
        return result;
    }

    public String getMimeMediaType() {
        if (!this.isValid()) {
            return null;
        }
        String retValue = this.type + "/" + this.subtype;
        return retValue;
    }

    public String getType() {
        return this.type;
    }

    public boolean isExperimentalType() {
        if (null == this.type || this.type.length() < 2) {
            return false;
        }
        if (this.type.startsWith("x-") || this.type.startsWith("x.")) {
            return true;
        }
        if (null == this.subtype || this.subtype.length() < 2) {
            return false;
        }
        return this.subtype.startsWith("x-") || this.subtype.startsWith("x.");
    }

    public void setType(String type) {
        if (null == type) {
            throw new IllegalArgumentException("type cannot be null");
        }
        String cleaned = type.trim().toLowerCase();
        if (0 == cleaned.length()) {
            throw new IllegalArgumentException("type cannot be null");
        }
        if (-1 != this.findNextSeperator(cleaned)) {
            throw new IllegalArgumentException("type cannot contain a seperator");
        }
        this.type = cleaned;
    }

    public String getSubtype() {
        return this.subtype;
    }

    public boolean isExperimentalSubtype() {
        if (null == this.subtype || this.subtype.length() < 2) {
            return false;
        }
        return 'x' == this.subtype.charAt(0) && '-' == this.subtype.charAt(1);
    }

    public void setSubtype(String subtype) {
        if (null == subtype) {
            throw new IllegalArgumentException("subtype cannot be null");
        }
        String cleaned = subtype.trim().toLowerCase();
        if (0 == cleaned.length()) {
            throw new IllegalArgumentException("subtype cannot be null");
        }
        if (-1 != this.findNextSeperator(cleaned)) {
            throw new IllegalArgumentException("subtype cannot contain a seperator");
        }
        this.subtype = cleaned;
    }

    public Enumeration getParameters() {
        return this.parameters.elements();
    }

    public void setParameters(String[] parameters) {
        this.parameters = new Vector();
        int eachParameter = 0;
        while (eachParameter < parameters.length) {
            this.addParameter(parameters[eachParameter]);
            ++eachParameter;
        }
    }

    public void addParameter(String newParam) {
        this.parameters.addElement(newParam);
    }

    private int findNextSeperator(String source) {
        return MimeMediaType.findNextSeperator(source, 0);
    }

    private static int findNextSeperator(String source, int from) {
        int seperator = -1;
        int eachChar = from;
        while (eachChar < source.length()) {
            if (-1 != terminator.indexOf(source.charAt(eachChar))) {
                seperator = eachChar;
                break;
            }
            ++eachChar;
        }
        return seperator;
    }
}

