/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.wsdl.toJava;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashSet;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.wsdl.Fault;
import javax.wsdl.Message;
import javax.wsdl.QName;
import javax.xml.rpc.holders.BooleanHolder;
import javax.xml.rpc.holders.IntHolder;
import org.apache.axis.Constants;
import org.apache.axis.utils.JavaUtils;
import org.apache.axis.wsdl.toJava.SchemaUtils;
import org.apache.axis.wsdl.toJava.SymbolTable;
import org.apache.axis.wsdl.toJava.Type;
import org.apache.axis.wsdl.toJava.TypeEntry;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class Utils {
    public static String capitalizeFirstChar(String string) {
        if (string == null || string.equals("")) {
            return string;
        }
        char c = string.charAt(0);
        if (Character.isLowerCase(c)) {
            c = Character.toUpperCase(c);
            return c + string.substring(1);
        }
        return string;
    }

    public static QName getNillableQName(QName qName) {
        QName qName2 = new QName(qName.getNamespaceURI(), qName.getLocalPart());
        if (Constants.isSchemaXSD(qName2.getNamespaceURI())) {
            String string = qName2.getLocalPart();
            if (string.equals("int") || string.equals("long") || string.equals("short") || string.equals("float") || string.equals("double") || string.equals("boolean") || string.equals("byte")) {
                qName2.setNamespaceURI("http://schemas.xmlsoap.org/soap/encoding/");
            } else if (string.equals("base64Binary") || string.equals("hexBinary")) {
                qName2.setNamespaceURI("http://schemas.xmlsoap.org/soap/encoding/");
                qName2.setLocalPart("base64");
            }
        }
        return qName2;
    }

    public static String getScopedAttribute(Node node, String string) {
        if (node == null) {
            return null;
        }
        if (node.getAttributes() == null) {
            return Utils.getScopedAttribute(node.getParentNode(), string);
        }
        Node node2 = node.getAttributes().getNamedItem(string);
        if (node2 != null) {
            return node2.getNodeValue();
        }
        return Utils.getScopedAttribute(node.getParentNode(), string);
    }

    public static String getAttribute(Node node, String string) {
        if (node == null || node.getAttributes() == null) {
            return null;
        }
        Node node2 = node.getAttributes().getNamedItem(string);
        if (node2 != null) {
            return node2.getNodeValue();
        }
        return null;
    }

    public static Vector getAttributesWithLocalName(Node node, String string) {
        Vector<Node> vector = new Vector<Node>();
        if (node == null) {
            return vector;
        }
        NamedNodeMap namedNodeMap = node.getAttributes();
        if (namedNodeMap != null) {
            int n = 0;
            while (n < namedNodeMap.getLength()) {
                Node node2 = namedNodeMap.item(n);
                if (node2 != null && node2.getLocalName().equals(string)) {
                    vector.add(node2);
                }
                ++n;
            }
        }
        return vector;
    }

    public static QName getNodeQName(Node node) {
        if (node == null) {
            return null;
        }
        String string = node.getLocalName();
        if (string == null) {
            return null;
        }
        String string2 = node.getNamespaceURI();
        return new QName(string2, string);
    }

    public static QName getNodeNameQName(Node node) {
        QName qName;
        if (node == null) {
            return null;
        }
        String string = null;
        String string2 = null;
        string = Utils.getAttribute(node, "name");
        if (string == null && (qName = Utils.getNodeTypeRefQName(node, "ref")) != null) {
            string = qName.getLocalPart();
            string2 = qName.getNamespaceURI();
        }
        if (string == null) {
            string = Utils.getScopedAttribute(node, "name");
        }
        if (string == null) {
            return null;
        }
        if (string2 == null) {
            string2 = Utils.getScopedAttribute(node, "targetNamespace");
        }
        return new QName(string2, string);
    }

    public static QName getNodeTypeRefQName(Node node, BooleanHolder booleanHolder) {
        if (node == null) {
            return null;
        }
        booleanHolder.value = false;
        QName qName = Utils.getNodeTypeRefQName(node, "type");
        if (qName != null) {
            String string = Utils.getAttribute(node, "maxOccurs");
            String string2 = Utils.getAttribute(node, "minOccurs");
            if (string == null) {
                string = "1";
            }
            if (string2 == null) {
                string2 = "1";
            }
            if (string2.equals("0") && string.equals("1")) {
                qName = Utils.getNillableQName(qName);
            } else if (!string.equals("1") || !string2.equals("1")) {
                String string3 = qName.getLocalPart();
                string3 = string3 + "[" + string + "]";
                qName.setLocalPart(string3);
            }
        }
        if (qName == null) {
            booleanHolder.value = true;
            qName = Utils.getNodeTypeRefQName(node, "ref");
        }
        if (qName == null) {
            booleanHolder.value = true;
            qName = Utils.getNodeTypeRefQName(node, "element");
        }
        if (qName == null) {
            booleanHolder.value = false;
            qName = Utils.getNodeTypeRefQName(node, "base");
        }
        return qName;
    }

    public static QName getNodeTypeRefQName(Node node, String string) {
        String string2;
        if (node == null) {
            return null;
        }
        String string3 = Utils.getAttribute(node, string);
        if (string3 == null) {
            return null;
        }
        QName qName = Utils.getQNameFromPrefixedName(node, string3);
        if (string.equals("type") && (string2 = Utils.getAttribute(node, "nillable")) != null && string2.equalsIgnoreCase("true")) {
            qName = Utils.getNillableQName(qName);
        }
        return qName;
    }

    public static QName getQNameFromPrefixedName(Node node, String string) {
        String string2 = string.substring(string.lastIndexOf(":") + 1);
        String string3 = null;
        string3 = string.length() == string2.length() ? Utils.getScopedAttribute(node, "xmlns") : Utils.getScopedAttribute(node, "xmlns:" + string.substring(0, string.lastIndexOf(":")));
        return new QName(string3, string2);
    }

    public static String xmlNameToJava(String string) {
        return JavaUtils.xmlNameToJava(string);
    }

    public static String xmlNameToJavaClass(String string) {
        return Utils.capitalizeFirstChar(Utils.xmlNameToJava(string));
    }

    public static String makePackageName(String string) {
        String string2 = null;
        try {
            string2 = new URL(string).getHost();
        }
        catch (MalformedURLException malformedURLException) {
            if (string.indexOf(":") > -1) {
                string2 = string.substring(string.indexOf(":") + 1);
                if (string2.indexOf("/") > -1) {
                    string2 = string2.substring(0, string2.indexOf("/"));
                }
            }
            string2 = string;
        }
        if (string2 == null) {
            return null;
        }
        string2 = string2.replace('-', '_');
        StringTokenizer stringTokenizer = new StringTokenizer(string2, ".");
        String[] stringArray = new String[stringTokenizer.countTokens()];
        int n = 0;
        while (n < stringArray.length) {
            stringArray[n] = stringTokenizer.nextToken();
            ++n;
        }
        StringBuffer stringBuffer = new StringBuffer(80);
        int n2 = stringArray.length - 1;
        while (n2 >= 0) {
            String string3 = stringArray[n2];
            if (JavaUtils.isJavaKeyword(string3)) {
                string3 = JavaUtils.makeNonJavaKeyword(string3);
            }
            if (n2 != stringArray.length - 1) {
                stringBuffer.append('.');
            }
            if (Character.isDigit(string3.charAt(0))) {
                stringBuffer.append('_');
            }
            stringBuffer.append(string3);
            --n2;
        }
        return stringBuffer.toString();
    }

    public static String holder(TypeEntry typeEntry, SymbolTable symbolTable) {
        String string = typeEntry.getName();
        if (string.equals("byte[]")) {
            return "javax.xml.rpc.holders.ByteArrayHolder";
        }
        if (string.equals("java.lang.Byte[]")) {
            return "javax.xml.rpc.holders.ByteWrapperArrayHolder";
        }
        if (string.endsWith("[]")) {
            String string2 = symbolTable.getJavaName(typeEntry.getQName());
            string2 = JavaUtils.replace(string2, "[]", "Array");
            return string2 + "Holder";
        }
        if (string.equals("String")) {
            return "javax.xml.rpc.holders.StringHolder";
        }
        if (string.equals("java.lang.String")) {
            return "javax.xml.rpc.holders.StringHolder";
        }
        if (string.equals("Object")) {
            return "javax.xml.rpc.holders.ObjectHolder";
        }
        if (string.equals("java.lang.Object")) {
            return "javax.xml.rpc.holders.ObjectHolder";
        }
        if (string.equals("int") || string.equals("long") || string.equals("short") || string.equals("float") || string.equals("double") || string.equals("boolean") || string.equals("byte")) {
            return "javax.xml.rpc.holders." + Utils.capitalizeFirstChar(string) + "Holder";
        }
        if (string.startsWith("java.lang.")) {
            return "javax.xml.rpc.holders" + string.substring(string.lastIndexOf(".")) + "WrapperHolder";
        }
        if (string.indexOf(".") < 0) {
            return "javax.xml.rpc.holders" + string + "WrapperHolder";
        }
        if (string.equals("java.math.BigDecimal")) {
            return "javax.xml.rpc.holders.BigDecimalHolder";
        }
        if (string.equals("java.math.BigInteger")) {
            return "javax.xml.rpc.holders.BigIntegerHolder";
        }
        if (string.equals("java.util.Date")) {
            return "javax.xml.rpc.holders.DateHolder";
        }
        if (string.equals("java.util.Calendar")) {
            return "javax.xml.rpc.holders.CalendarHolder";
        }
        if (string.equals("javax.xml.rpc.namespace.QName")) {
            return "javax.xml.rpc.holders.QNameHolder";
        }
        return string + "Holder";
    }

    public static String getExceptionName(Fault fault) {
        String string;
        Message message = fault.getMessage();
        if (message != null) {
            String string2 = message.getQName().getLocalPart();
            string = Utils.xmlNameToJavaClass(string2);
        } else {
            string = Utils.xmlNameToJavaClass(fault.getName());
        }
        return string;
    }

    public static String getFullExceptionName(Fault fault, SymbolTable symbolTable, String string) {
        String string2;
        Message message = fault.getMessage();
        if (message != null) {
            String string3 = message.getQName().getLocalPart();
            QName qName = new QName(string, string3);
            string2 = symbolTable.getJavaName(qName);
        } else {
            string2 = Utils.xmlNameToJavaClass(fault.getName());
        }
        return string2;
    }

    public static HashSet getNestedTypes(Node node, SymbolTable symbolTable) {
        HashSet hashSet = new HashSet();
        Utils.getNestedTypes(node, hashSet, symbolTable);
        return hashSet;
    }

    private static void getNestedTypes(Node node, HashSet hashSet, SymbolTable symbolTable) {
        QName qName;
        Type type;
        TypeEntry typeEntry;
        Vector vector = SchemaUtils.getComplexElementTypesAndNames(node, symbolTable);
        if (vector != null) {
            int n = 0;
            while (n < vector.size()) {
                if (!hashSet.contains(vector.get(n))) {
                    hashSet.add(vector.get(n));
                    Utils.getNestedTypes(((TypeEntry)vector.get(n)).getNode(), hashSet, symbolTable);
                }
                n += 2;
            }
        }
        if ((typeEntry = SchemaUtils.getComplexElementExtensionBase(node, symbolTable)) != null && !hashSet.contains(typeEntry)) {
            hashSet.add(typeEntry);
            Utils.getNestedTypes(typeEntry.getNode(), hashSet, symbolTable);
        }
        if ((type = symbolTable.getType(qName = SchemaUtils.getArrayElementQName(node, new IntHolder(0)))) != null && !hashSet.contains(type)) {
            hashSet.add(type);
            Utils.getNestedTypes(type.getNode(), hashSet, symbolTable);
        }
    }

    public static String getJavaLocalName(String string) {
        return string.substring(string.lastIndexOf(46) + 1);
    }

    public static String getJavaPackageName(String string) {
        if (string.lastIndexOf(46) > 0) {
            return string.substring(0, string.lastIndexOf(46));
        }
        return "";
    }
}

