/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.wsdl.toJava;

import java.io.IOException;
import javax.wsdl.QName;
import org.apache.axis.utils.JavaUtils;
import org.apache.axis.wsdl.toJava.SymTabEntry;
import org.apache.axis.wsdl.toJava.Undefined;
import org.w3c.dom.Node;

public abstract class TypeEntry
extends SymTabEntry {
    protected Node node;
    protected TypeEntry refType;
    protected String dims = "";
    protected boolean undefined;
    protected boolean isBaseType;
    protected boolean isSimpleType = false;
    protected boolean onlyLiteralReference = false;

    protected TypeEntry(QName qName, TypeEntry typeEntry, Node node, String string) {
        super(qName);
        this.node = node;
        this.undefined = typeEntry.undefined;
        this.refType = typeEntry;
        if (string == null) {
            string = "";
        }
        this.dims = string;
        if (typeEntry.undefined) {
            TypeEntry typeEntry2 = typeEntry;
            while (!(typeEntry2 instanceof Undefined)) {
                typeEntry2 = typeEntry2.refType;
            }
            ((Undefined)((Object)typeEntry2)).register(this);
        } else {
            this.isBaseType = typeEntry.isBaseType && typeEntry.dims.equals("") && string.equals("");
        }
    }

    protected TypeEntry(QName qName, Node node) {
        super(qName);
        this.node = node;
        this.refType = null;
        this.undefined = false;
        this.dims = "";
        this.isBaseType = false;
    }

    protected TypeEntry(QName qName) {
        super(qName);
        this.node = null;
        this.undefined = false;
        this.dims = "";
        this.isBaseType = true;
    }

    public Node getNode() {
        return this.node;
    }

    public String getBaseType() {
        if (this.isBaseType) {
            return this.name;
        }
        return null;
    }

    public boolean isSimpleType() {
        return this.isSimpleType;
    }

    public void setSimpleType(boolean bl) {
        this.isSimpleType = bl;
    }

    public boolean isOnlyLiteralReferenced() {
        return this.onlyLiteralReference;
    }

    public void setOnlyLiteralReference(boolean bl) {
        this.onlyLiteralReference = bl;
    }

    protected TypeEntry getUndefinedTypeRef() {
        if (this instanceof Undefined) {
            return this;
        }
        if (this.undefined && this.refType != null && this.refType.undefined) {
            TypeEntry typeEntry = this.refType;
            while (!(typeEntry instanceof Undefined)) {
                typeEntry = typeEntry.refType;
            }
            return typeEntry;
        }
        return null;
    }

    protected boolean updateUndefined(TypeEntry typeEntry, TypeEntry typeEntry2) throws IOException {
        boolean bl = false;
        if (this.refType == typeEntry) {
            this.refType = typeEntry2;
            bl = true;
            TypeEntry typeEntry3 = this.refType;
            while (typeEntry3 != null && typeEntry3 != this) {
                typeEntry3 = typeEntry3.refType;
            }
            if (typeEntry3 == this) {
                this.undefined = false;
                this.isBaseType = false;
                this.node = null;
                throw new IOException(JavaUtils.getMessage("undefinedloop00", this.getQName().toString()));
            }
        }
        if (this.refType != null && this.undefined && !this.refType.undefined) {
            this.undefined = false;
            bl = true;
            this.isBaseType = this.refType.isBaseType && this.refType.dims.equals("") && this.dims.equals("");
        }
        return bl;
    }

    public TypeEntry getRefType() {
        return this.refType;
    }

    public String getDimensions() {
        return this.dims;
    }

    public String toString() {
        return this.toString("");
    }

    protected String toString(String string) {
        String string2 = string + "RefType:       null \n";
        if (this.refType != null) {
            string2 = string + "RefType:\n" + this.refType.toString(string + "  ") + "\n";
        }
        return super.toString(string) + string + "Class:         " + this.getClass().getName() + "\n" + string + "Base?:         " + this.isBaseType + "\n" + string + "Undefined?:    " + this.undefined + "\n" + string + "Node:          " + this.getNode() + "\n" + string + "Dims:          " + this.dims + "\n" + string2;
    }
}

