/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.wsdl.toJava;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.wsdl.Binding;
import javax.wsdl.BindingFault;
import javax.wsdl.BindingOperation;
import javax.wsdl.Definition;
import javax.wsdl.Fault;
import javax.wsdl.Import;
import javax.wsdl.Input;
import javax.wsdl.Message;
import javax.wsdl.Operation;
import javax.wsdl.Output;
import javax.wsdl.Part;
import javax.wsdl.Port;
import javax.wsdl.PortType;
import javax.wsdl.QName;
import javax.wsdl.Service;
import javax.wsdl.extensions.http.HTTPBinding;
import javax.wsdl.extensions.soap.SOAPBinding;
import javax.wsdl.extensions.soap.SOAPBody;
import javax.xml.rpc.holders.BooleanHolder;
import javax.xml.rpc.holders.IntHolder;
import org.apache.axis.Constants;
import org.apache.axis.utils.JavaUtils;
import org.apache.axis.utils.XMLUtils;
import org.apache.axis.wsdl.toJava.BaseType;
import org.apache.axis.wsdl.toJava.BaseTypeMapping;
import org.apache.axis.wsdl.toJava.BindingEntry;
import org.apache.axis.wsdl.toJava.CollectionType;
import org.apache.axis.wsdl.toJava.DefinedElement;
import org.apache.axis.wsdl.toJava.DefinedType;
import org.apache.axis.wsdl.toJava.Element;
import org.apache.axis.wsdl.toJava.MessageEntry;
import org.apache.axis.wsdl.toJava.Namespaces;
import org.apache.axis.wsdl.toJava.Parameter;
import org.apache.axis.wsdl.toJava.Parameters;
import org.apache.axis.wsdl.toJava.PortTypeEntry;
import org.apache.axis.wsdl.toJava.SchemaUtils;
import org.apache.axis.wsdl.toJava.ServiceEntry;
import org.apache.axis.wsdl.toJava.SymTabEntry;
import org.apache.axis.wsdl.toJava.Type;
import org.apache.axis.wsdl.toJava.TypeEntry;
import org.apache.axis.wsdl.toJava.Undefined;
import org.apache.axis.wsdl.toJava.UndefinedElement;
import org.apache.axis.wsdl.toJava.UndefinedType;
import org.apache.axis.wsdl.toJava.Utils;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SymbolTable {
    private Namespaces namespaces;
    private boolean addImports;
    private HashMap symbolTable = new HashMap();
    private Vector types = new Vector();
    private boolean debug = false;
    private BaseTypeMapping btm = null;
    private boolean wrapped = false;
    private HashSet importedFiles = new HashSet();
    private static final int ABOVE_SCHEMA_LEVEL = -1;
    private static final int SCHEMA_LEVEL = 0;
    static /* synthetic */ Class class$org$apache$axis$wsdl$toJava$MessageEntry;
    static /* synthetic */ Class class$org$apache$axis$wsdl$toJava$PortTypeEntry;
    static /* synthetic */ Class class$org$apache$axis$wsdl$toJava$BindingEntry;
    static /* synthetic */ Class class$org$apache$axis$wsdl$toJava$ServiceEntry;
    static /* synthetic */ Class class$org$apache$axis$wsdl$toJava$UndefinedType;
    static /* synthetic */ Class class$org$apache$axis$wsdl$toJava$UndefinedElement;

    public SymbolTable(Namespaces namespaces, BaseTypeMapping baseTypeMapping, boolean bl, boolean bl2) {
        this.namespaces = namespaces;
        this.btm = baseTypeMapping;
        this.addImports = bl;
        this.debug = bl2;
    }

    public HashMap getHashMap() {
        return this.symbolTable;
    }

    public Vector getSymbols(QName qName) {
        return (Vector)this.symbolTable.get(qName);
    }

    private SymTabEntry get(QName qName, Class clazz) {
        Vector vector = (Vector)this.symbolTable.get(qName);
        if (vector == null) {
            return null;
        }
        int n = 0;
        while (n < vector.size()) {
            SymTabEntry symTabEntry = (SymTabEntry)vector.elementAt(n);
            if (clazz.isInstance(symTabEntry)) {
                return symTabEntry;
            }
            ++n;
        }
        return null;
    }

    public TypeEntry getTypeEntry(QName qName, boolean bl) {
        if (bl) {
            return this.getElement(qName);
        }
        return this.getType(qName);
    }

    public Type getType(QName qName) {
        int n = 0;
        while (n < this.types.size()) {
            TypeEntry typeEntry = (TypeEntry)this.types.get(n);
            if (typeEntry.getQName().equals((Object)qName) && typeEntry instanceof Type) {
                return (Type)typeEntry;
            }
            ++n;
        }
        return null;
    }

    public Element getElement(QName qName) {
        int n = 0;
        while (n < this.types.size()) {
            TypeEntry typeEntry = (TypeEntry)this.types.get(n);
            if (typeEntry.getQName().equals((Object)qName) && typeEntry instanceof Element) {
                return (Element)typeEntry;
            }
            ++n;
        }
        return null;
    }

    public MessageEntry getMessageEntry(QName qName) {
        return (MessageEntry)this.get(qName, class$org$apache$axis$wsdl$toJava$MessageEntry == null ? (class$org$apache$axis$wsdl$toJava$MessageEntry = SymbolTable.class$("org.apache.axis.wsdl.toJava.MessageEntry")) : class$org$apache$axis$wsdl$toJava$MessageEntry);
    }

    public PortTypeEntry getPortTypeEntry(QName qName) {
        return (PortTypeEntry)this.get(qName, class$org$apache$axis$wsdl$toJava$PortTypeEntry == null ? (class$org$apache$axis$wsdl$toJava$PortTypeEntry = SymbolTable.class$("org.apache.axis.wsdl.toJava.PortTypeEntry")) : class$org$apache$axis$wsdl$toJava$PortTypeEntry);
    }

    public BindingEntry getBindingEntry(QName qName) {
        return (BindingEntry)this.get(qName, class$org$apache$axis$wsdl$toJava$BindingEntry == null ? (class$org$apache$axis$wsdl$toJava$BindingEntry = SymbolTable.class$("org.apache.axis.wsdl.toJava.BindingEntry")) : class$org$apache$axis$wsdl$toJava$BindingEntry);
    }

    public ServiceEntry getServiceEntry(QName qName) {
        return (ServiceEntry)this.get(qName, class$org$apache$axis$wsdl$toJava$ServiceEntry == null ? (class$org$apache$axis$wsdl$toJava$ServiceEntry = SymbolTable.class$("org.apache.axis.wsdl.toJava.ServiceEntry")) : class$org$apache$axis$wsdl$toJava$ServiceEntry);
    }

    public Vector getTypes() {
        return this.types;
    }

    public void setNamespaceMap(HashMap hashMap) {
        this.namespaces.putAll((Map)hashMap);
    }

    public String getPackage(String string) {
        return this.namespaces.getCreate(string);
    }

    public String getPackage(QName qName) {
        return this.getPackage(qName.getNamespaceURI());
    }

    public boolean isWrapped() {
        return this.wrapped;
    }

    public void setWrapped(boolean bl) {
        this.wrapped = bl;
    }

    public void dump(PrintStream printStream) {
        printStream.println();
        printStream.println(JavaUtils.getMessage("symbolTable00"));
        printStream.println("-----------------------");
        Iterator iterator = this.symbolTable.values().iterator();
        while (iterator.hasNext()) {
            Vector vector = (Vector)iterator.next();
            int n = 0;
            while (n < vector.size()) {
                printStream.println(vector.elementAt(n).getClass().getName());
                printStream.println(vector.elementAt(n));
                ++n;
            }
        }
        printStream.println("-----------------------");
    }

    protected void add(String string, Definition definition, Document document) throws IOException {
        this.checkForUndefined(definition);
        URL uRL = string == null ? null : SymbolTable.getURL(null, string);
        this.populate(uRL, definition, document);
        this.checkForUndefined();
        this.populateParameters();
        this.setReferences(definition, document);
    }

    private void checkForUndefined(Definition definition) throws IOException {
        if (definition != null) {
            Object object;
            Iterator iterator = definition.getBindings().values().iterator();
            while (iterator.hasNext()) {
                object = (Binding)iterator.next();
                if (!object.isUndefined()) continue;
                throw new IOException(JavaUtils.getMessage("emitFailtUndefinedBinding01", object.getQName().getLocalPart()));
            }
            object = definition.getPortTypes().values().iterator();
            while (object.hasNext()) {
                PortType portType = (PortType)object.next();
                if (!portType.isUndefined()) continue;
                throw new IOException(JavaUtils.getMessage("emitFailtUndefinedPort01", portType.getQName().getLocalPart()));
            }
        }
    }

    private void checkForUndefined() throws IOException {
        Iterator iterator = this.symbolTable.values().iterator();
        while (iterator.hasNext()) {
            Vector vector = (Vector)iterator.next();
            int n = 0;
            while (n < vector.size()) {
                if (vector.get(n) instanceof Undefined) {
                    throw new IOException(JavaUtils.getMessage("undefined00", "" + ((TypeEntry)vector.get(n)).getQName()));
                }
                ++n;
            }
        }
    }

    private void populate(URL uRL, Definition definition, Document document) throws IOException {
        if (document != null) {
            this.populateTypes(document);
            if (definition == null && this.addImports) {
                this.lookForImports(uRL, document);
            }
        }
        if (definition != null) {
            if (this.addImports) {
                Map map = definition.getImports();
                Object[] objectArray = map.keySet().toArray();
                int n = 0;
                while (n < objectArray.length) {
                    Vector vector = (Vector)map.get(objectArray[n]);
                    int n2 = 0;
                    while (n2 < vector.size()) {
                        Import import_ = (Import)vector.get(n2);
                        if (!this.importedFiles.contains(import_.getLocationURI())) {
                            this.importedFiles.add(import_.getLocationURI());
                            URL uRL2 = SymbolTable.getURL(uRL, import_.getLocationURI());
                            this.populate(uRL2, import_.getDefinition(), XMLUtils.newDocument(uRL2.toString()));
                        }
                        ++n2;
                    }
                    ++n;
                }
            }
            this.populateMessages(definition);
            this.populatePortTypes(definition);
            this.populateBindings(definition);
            this.populateServices(definition);
        }
    }

    private static URL getURL(URL uRL, String string) throws IOException {
        URL uRL2 = null;
        try {
            uRL2 = new URL(uRL, string);
            try {
                uRL2.openStream();
            }
            catch (IOException iOException) {
                throw new MalformedURLException();
            }
        }
        catch (MalformedURLException malformedURLException) {
            uRL2 = new URL("file", "", string);
            try {
                uRL2.openStream();
            }
            catch (IOException iOException) {
                if (uRL != null) {
                    String string2 = uRL.getFile();
                    String string3 = new File(string2).getParent();
                }
                throw new FileNotFoundException(uRL2.toString());
            }
        }
        return uRL2;
    }

    private void lookForImports(URL uRL, Node node) throws IOException {
        NodeList nodeList = node.getChildNodes();
        int n = 0;
        while (n < nodeList.getLength()) {
            NamedNodeMap namedNodeMap;
            Node node2;
            Node node3 = nodeList.item(n);
            if ("import".equals(node3.getLocalName()) && (node2 = (namedNodeMap = node3.getAttributes()).getNamedItem("schemaLocation")) != null) {
                this.populate(uRL, null, XMLUtils.newDocument(SymbolTable.getURL(uRL, node2.getNodeValue()).toString()));
            }
            this.lookForImports(uRL, node3);
            ++n;
        }
    }

    private void populateTypes(Document document) throws IOException {
        this.addTypes(document, -1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void addTypes(Node node, int n) throws IOException {
        int n2;
        Object object;
        if (node == null) {
            return;
        }
        QName qName = Utils.getNodeQName(node);
        if (qName != null) {
            Object object2;
            Object object3;
            Node node2;
            object = qName.getLocalPart();
            n2 = Constants.isSchemaXSD(qName.getNamespaceURI());
            if (n2 != 0 && ((String)object).equals("complexType") || ((String)object).equals("simpleType")) {
                node2 = SchemaUtils.getRestrictionOrExtensionNode(node);
                if (node2 != null && Utils.getAttribute(node2, "base") != null) {
                    this.createTypeFromRef(node2);
                }
                this.createTypeFromDef(node, false, false);
            } else if (n2 != 0 && ((String)object).equals("element")) {
                if (Utils.getAttribute(node, "type") != null || Utils.getAttribute(node, "ref") != null) {
                    this.createTypeFromRef(node);
                }
                if ((node2 = SchemaUtils.getRestrictionOrExtensionNode(node)) != null && Utils.getAttribute(node2, "base") != null) {
                    this.createTypeFromRef(node2);
                }
                this.createTypeFromDef(node, true, n > 0);
            } else if (((String)object).equals("part") && Constants.isWSDL(qName.getNamespaceURI())) {
                this.createTypeFromRef(node);
            } else if (n2 != 0 && ((String)object).equals("simpleContent")) {
                node2 = node.getParentNode();
                object3 = Utils.getNodeNameQName(node2);
                object2 = this.getTypeEntry((QName)object3, false);
                ((TypeEntry)object2).setSimpleType(true);
            } else if (n2 != 0 && ((String)object).equals("attribute") && (node2 = Utils.getNodeTypeRefQName(node, "type")) != null) {
                object3 = this.getTypeEntry((QName)node2, false);
                if (object3 == null) {
                    object2 = this.btm.getBaseName((QName)node2);
                    if (object2 == null) throw new IOException(JavaUtils.getMessage("AttrNotSimpleType01", node2.toString()));
                    BaseType baseType = new BaseType((QName)node2);
                    this.symbolTablePut(baseType);
                } else {
                    ((SymTabEntry)object3).setIsReferenced(true);
                }
            }
        }
        if (n == -1) {
            if (qName != null && qName.getLocalPart().equals("schema")) {
                n = 0;
            }
        } else {
            ++n;
        }
        object = node.getChildNodes();
        n2 = 0;
        while (n2 < object.getLength()) {
            this.addTypes(object.item(n2), n);
            ++n2;
        }
    }

    private void createTypeFromDef(Node node, boolean bl, boolean bl2) throws IOException {
        QName qName = null;
        Object var5_5 = null;
        if (!bl && Utils.getAttribute(node, "name") == null && (qName = Utils.getNodeNameQName(node)) != null && this.getElement(qName) != null) {
            return;
        }
        qName = Utils.getNodeNameQName(node);
        if (qName != null) {
            if (!bl && this.btm.getBaseName(qName) != null) {
                return;
            }
            BooleanHolder booleanHolder = new BooleanHolder();
            QName qName2 = Utils.getNodeTypeRefQName(node, booleanHolder);
            if (qName2 != null) {
                TypeEntry typeEntry = this.getTypeEntry(qName2, booleanHolder.value);
                if (!bl2) {
                    this.symbolTablePut(new DefinedElement(qName, typeEntry, node, ""));
                }
            } else {
                IntHolder intHolder = new IntHolder();
                intHolder.value = 0;
                QName qName3 = SchemaUtils.getArrayElementQName(node, intHolder);
                QName qName4 = SchemaUtils.getSimpleTypeBase(node, this);
                if (qName3 != null || qName4 != null) {
                    String string;
                    qName2 = qName3 != null ? qName3 : qName4;
                    TypeEntry typeEntry = this.getTypeEntry(qName2, false);
                    if (typeEntry == null) {
                        string = this.btm.getBaseName(qName2);
                        typeEntry = string != null ? new BaseType(qName2) : new UndefinedType(qName2);
                        this.symbolTablePut(typeEntry);
                    }
                    string = "";
                    while (intHolder.value > 0) {
                        string = string + "[]";
                        --intHolder.value;
                    }
                    TypeEntry typeEntry2 = null;
                    if (bl) {
                        if (!bl2) {
                            typeEntry2 = new DefinedElement(qName, typeEntry, node, string);
                        }
                    } else {
                        typeEntry2 = new DefinedType(qName, typeEntry, node, string);
                    }
                    if (typeEntry2 != null) {
                        this.symbolTablePut(typeEntry2);
                    }
                } else {
                    String string = this.btm.getBaseName(qName);
                    if (string != null) {
                        this.symbolTablePut(new BaseType(qName));
                    } else if (!bl) {
                        this.symbolTablePut(new DefinedType(qName, node));
                    } else if (!bl2) {
                        this.symbolTablePut(new DefinedElement(qName, node));
                    }
                }
            }
        }
    }

    private void createTypeFromRef(Node node) throws IOException {
        TypeEntry typeEntry;
        BooleanHolder booleanHolder = new BooleanHolder();
        QName qName = Utils.getNodeTypeRefQName(node, booleanHolder);
        if (qName != null && (typeEntry = this.getTypeEntry(qName, booleanHolder.value)) == null) {
            if (qName.getLocalPart().indexOf("[") > 0) {
                QName qName2 = Utils.getNodeTypeRefQName(node, "type");
                TypeEntry typeEntry2 = this.getTypeEntry(qName2, false);
                if (typeEntry2 == null) {
                    String string = this.btm.getBaseName(qName2);
                    typeEntry2 = string != null ? new BaseType(qName2) : new UndefinedType(qName2);
                    this.symbolTablePut(typeEntry2);
                }
                this.symbolTablePut(new CollectionType(qName, typeEntry2, node, "[]"));
            } else {
                String string = this.btm.getBaseName(qName);
                if (string != null) {
                    this.symbolTablePut(new BaseType(qName));
                } else if (!booleanHolder.value) {
                    this.symbolTablePut(new UndefinedType(qName));
                } else {
                    this.symbolTablePut(new UndefinedElement(qName));
                }
            }
        }
    }

    public String getJavaName(QName qName) {
        if (qName.getLocalPart().indexOf("[") > 0) {
            String string = qName.getLocalPart().substring(0, qName.getLocalPart().indexOf("["));
            QName qName2 = new QName(qName.getNamespaceURI(), string);
            return this.getJavaName(qName2) + "[]";
        }
        if (qName.getNamespaceURI().equalsIgnoreCase("java")) {
            return qName.getLocalPart();
        }
        String string = this.btm.getBaseName(qName);
        if (string != null) {
            return string;
        }
        String string2 = this.getPackage(qName.getNamespaceURI());
        string = string2 != null ? string2 + "." + Utils.xmlNameToJavaClass(qName.getLocalPart()) : Utils.xmlNameToJavaClass(qName.getLocalPart());
        return string;
    }

    private void populateMessages(Definition definition) throws IOException {
        Iterator iterator = definition.getMessages().values().iterator();
        while (iterator.hasNext()) {
            Message message = (Message)iterator.next();
            MessageEntry messageEntry = new MessageEntry(message);
            this.symbolTablePut(messageEntry);
        }
    }

    private void populatePortTypes(Definition definition) throws IOException {
        Iterator iterator = definition.getPortTypes().values().iterator();
        while (iterator.hasNext()) {
            PortType portType = (PortType)iterator.next();
            if (portType.isUndefined()) continue;
            PortTypeEntry portTypeEntry = new PortTypeEntry(portType);
            this.symbolTablePut(portTypeEntry);
        }
    }

    private void populateParameters() throws IOException {
        Iterator iterator = this.symbolTable.values().iterator();
        while (iterator.hasNext()) {
            Vector vector = (Vector)iterator.next();
            int n = 0;
            while (n < vector.size()) {
                if (vector.get(n) instanceof BindingEntry) {
                    BindingEntry bindingEntry = (BindingEntry)vector.get(n);
                    Binding binding = bindingEntry.getBinding();
                    PortType portType = binding.getPortType();
                    HashMap<Operation, Parameters> hashMap = new HashMap<Operation, Parameters>();
                    Iterator iterator2 = portType.getOperations().iterator();
                    while (iterator2.hasNext()) {
                        Operation operation = (Operation)iterator2.next();
                        String string = portType.getQName().getNamespaceURI();
                        Parameters parameters = this.getOperationParameters(operation, string, bindingEntry);
                        hashMap.put(operation, parameters);
                    }
                    bindingEntry.setParameters(hashMap);
                }
                ++n;
            }
        }
    }

    private Parameters getOperationParameters(Operation operation, String string, BindingEntry bindingEntry) throws IOException {
        Object object;
        int n;
        Output output;
        Object object2;
        Object object3;
        Input input;
        Parameters parameters = new Parameters();
        Vector vector = new Vector();
        Vector vector2 = new Vector();
        List list = operation.getParameterOrdering();
        if (list != null && list.isEmpty()) {
            list = null;
        }
        if (list != null && (input = operation.getInput()) != null) {
            Message message = input.getMessage();
            object3 = message.getParts();
            object2 = message.getOrderedParts(list);
            if (object3.size() != object2.size()) {
                throw new IOException(JavaUtils.getMessage("emitFail00", operation.getName()));
            }
        }
        boolean bl = false;
        boolean bl2 = false;
        object3 = "unknown";
        if (bindingEntry != null) {
            bl = bindingEntry.getInputBodyType(operation) == 1;
            bl2 = bindingEntry.getOutputBodyType(operation) == 1;
            object3 = bindingEntry.getBinding().getQName().toString();
        }
        if ((object2 = operation.getInput()) != null) {
            this.partStrings(vector, object2.getMessage().getOrderedParts(null), bl, operation.getName(), (String)object3);
        }
        if ((output = operation.getOutput()) != null) {
            this.partStrings(vector2, output.getMessage().getOrderedParts(null), bl2, operation.getName(), (String)object3);
        }
        if (list != null) {
            n = 0;
            while (n < list.size()) {
                object = (String)list.get(n);
                int n2 = this.getPartIndex((String)object, vector);
                int n3 = this.getPartIndex((String)object, vector2);
                if (n2 > 0) {
                    this.addInishParm(vector, vector2, n2, n3, parameters, true);
                } else if (n3 > 0) {
                    this.addOutParm(vector2, n3, parameters, true);
                } else {
                    System.err.println(JavaUtils.getMessage("noPart00", (String)object));
                }
                ++n;
            }
        }
        n = 1;
        while (n < vector.size()) {
            int n4 = this.getPartIndex((String)vector.get(n), vector2);
            this.addInishParm(vector, vector2, n, n4, parameters, false);
            n += 2;
        }
        if (vector2.size() == 2) {
            parameters.returnType = (TypeEntry)vector2.get(0);
            parameters.returnName = (String)vector2.get(1);
            ++parameters.outputs;
        } else {
            int n5 = 1;
            while (n5 < vector2.size()) {
                this.addOutParm(vector2, n5, parameters, false);
                n5 += 2;
            }
        }
        object = operation.getFaults();
        Iterator iterator = object.values().iterator();
        while (iterator.hasNext()) {
            Fault fault = (Fault)iterator.next();
            String string2 = Utils.getFullExceptionName(fault, this, string);
            parameters.faultString = parameters.faultString == null ? string2 : parameters.faultString + ", " + string2;
        }
        return parameters;
    }

    private int getPartIndex(String string, Vector vector) {
        int n = 1;
        while (n < vector.size()) {
            if (string.equals(vector.get(n))) {
                return n;
            }
            n += 2;
        }
        return -1;
    }

    private void addInishParm(Vector vector, Vector vector2, int n, int n2, Parameters parameters, boolean bl) {
        Parameter parameter = new Parameter();
        parameter.type = (TypeEntry)vector.get(n - 1);
        if (parameter.type instanceof DefinedElement) {
            DefinedElement definedElement = (DefinedElement)parameter.type;
            parameter.setQName(definedElement.getQName());
        } else {
            parameter.setName((String)vector.get(n));
        }
        if (bl) {
            vector.remove(n);
            vector.remove(n - 1);
        }
        if (n2 > 0 && parameter.type.equals(vector2.get(n2 - 1))) {
            vector2.remove(n2);
            vector2.remove(n2 - 1);
            parameter.mode = (byte)3;
            ++parameters.inouts;
        } else {
            ++parameters.inputs;
        }
        parameters.list.add(parameter);
    }

    private void addOutParm(Vector vector, int n, Parameters parameters, boolean bl) {
        Parameter parameter = new Parameter();
        parameter.setName((String)vector.get(n));
        parameter.type = (TypeEntry)vector.get(n - 1);
        if (bl) {
            vector.remove(n);
            vector.remove(n - 1);
        }
        parameter.mode = (byte)2;
        ++parameters.outputs;
        parameters.list.add(parameter);
    }

    protected void partStrings(Vector vector, Collection collection, boolean bl, String string, String string2) throws IOException {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Vector vector2;
            Part part = (Part)iterator.next();
            QName qName = part.getElementName();
            QName qName2 = part.getTypeName();
            String string3 = part.getName();
            if (bl && !iterator.hasNext() && string3.equals("parameters")) {
                this.wrapped = true;
            }
            if (!bl || !this.wrapped) {
                if (qName2 != null) {
                    vector.add(this.getType(qName2));
                    vector.add(string3);
                    continue;
                }
                if (qName == null) continue;
                vector.add(this.getElement(qName));
                vector.add(string3);
                continue;
            }
            Node node = null;
            if (qName2 != null && qName == null) {
                throw new IOException(JavaUtils.getMessage("literalTypePart00", new String[]{string3, string, string2}));
            }
            if (qName != null && (vector2 = Utils.getNodeTypeRefQName(node = this.getTypeEntry(qName, true).getNode(), "type")) != null) {
                node = this.getTypeEntry((QName)vector2, false).getNode();
            }
            if (node == null) continue;
            vector2 = SchemaUtils.getComplexElementTypesAndNames(node, this);
            if (vector2 != null) {
                vector.addAll(vector2);
                continue;
            }
            if (qName2 != null) {
                vector.add(this.getType(qName2));
                vector.add(string3);
                continue;
            }
            if (qName == null) continue;
            vector.add(this.getElement(qName));
            vector.add(string3);
        }
    }

    private void populateBindings(Definition definition) throws IOException {
        Iterator iterator = definition.getBindings().values().iterator();
        while (iterator.hasNext()) {
            Object object;
            SOAPBinding sOAPBinding;
            int n = 1;
            int n2 = 3;
            Binding binding = (Binding)iterator.next();
            Iterator iterator2 = binding.getExtensibilityElements().iterator();
            while (iterator2.hasNext()) {
                Object e = iterator2.next();
                if (e instanceof SOAPBinding) {
                    n2 = 0;
                    sOAPBinding = (SOAPBinding)e;
                    object = sOAPBinding.getStyle();
                    if (!"rpc".equalsIgnoreCase((String)object)) continue;
                    n = 0;
                    continue;
                }
                if (!(e instanceof HTTPBinding)) continue;
                sOAPBinding = (HTTPBinding)e;
                n2 = sOAPBinding.getVerb().equalsIgnoreCase("post") ? 2 : 1;
            }
            boolean bl = false;
            sOAPBinding = new HashMap();
            object = binding.getBindingOperations();
            Iterator iterator3 = object.iterator();
            while (iterator3.hasNext()) {
                Object object2;
                Iterator<Object> iterator4;
                Iterator iterator5;
                int n3 = 0;
                int n4 = 0;
                BindingOperation bindingOperation = (BindingOperation)iterator3.next();
                if (bindingOperation.getBindingInput() != null && bindingOperation.getBindingInput().getExtensibilityElements() != null) {
                    iterator5 = bindingOperation.getBindingInput().getExtensibilityElements().iterator();
                    while (iterator5.hasNext()) {
                        iterator4 = iterator5.next();
                        if (!(iterator4 instanceof SOAPBody)) continue;
                        object2 = ((SOAPBody)iterator4).getUse();
                        if (!((String)object2).equalsIgnoreCase("literal")) break;
                        n3 = 1;
                        break;
                    }
                }
                if (bindingOperation.getBindingOutput() != null && bindingOperation.getBindingOutput().getExtensibilityElements() != null) {
                    iterator5 = bindingOperation.getBindingOutput().getExtensibilityElements().iterator();
                    while (iterator5.hasNext()) {
                        iterator4 = iterator5.next();
                        if (!(iterator4 instanceof SOAPBody)) continue;
                        object2 = ((SOAPBody)iterator4).getUse();
                        if (!((String)object2).equalsIgnoreCase("literal")) break;
                        n4 = 1;
                        break;
                    }
                }
                iterator5 = new HashMap();
                iterator4 = bindingOperation.getBindingFaults().values().iterator();
                while (iterator4.hasNext()) {
                    object2 = (BindingFault)iterator4.next();
                    String string = object2.getName();
                    int n5 = 0;
                    Iterator iterator6 = object2.getExtensibilityElements().iterator();
                    while (iterator6.hasNext()) {
                        Object e = iterator6.next();
                        if (!(e instanceof SOAPBody)) continue;
                        String string2 = ((SOAPBody)e).getUse();
                        if (!string2.equalsIgnoreCase("literal")) break;
                        n5 = 1;
                        break;
                    }
                    ((HashMap)((Object)iterator5)).put(string, new Integer(n5));
                }
                sOAPBinding.put(bindingOperation.getOperation(), new BindingEntry.OperationAttr(n3, n4, (HashMap)((Object)iterator5)));
                if (n3 != 1 && n4 != 1) continue;
                bl = true;
            }
            BindingEntry bindingEntry = new BindingEntry(binding, n2, n, bl, (HashMap)sOAPBinding);
            this.symbolTablePut(bindingEntry);
        }
    }

    private void populateServices(Definition definition) throws IOException {
        Iterator iterator = definition.getServices().values().iterator();
        while (iterator.hasNext()) {
            Service service = (Service)iterator.next();
            if (service.getQName() == null || service.getQName().getLocalPart() == null || service.getQName().getLocalPart().equals("")) {
                throw new IOException(JavaUtils.getMessage("BadServiceName00"));
            }
            ServiceEntry serviceEntry = new ServiceEntry(service);
            this.symbolTablePut(serviceEntry);
        }
    }

    private void setReferences(Definition definition, Document document) {
        Map map = definition.getServices();
        if (map.isEmpty()) {
            map = definition.getBindings();
            if (map.isEmpty()) {
                map = definition.getPortTypes();
                if (map.isEmpty()) {
                    map = definition.getMessages();
                    if (map.isEmpty()) {
                        int n = 0;
                        while (n < this.types.size()) {
                            TypeEntry typeEntry = (TypeEntry)this.types.get(n);
                            this.setTypeReferences(typeEntry, document, false);
                            ++n;
                        }
                    } else {
                        Iterator iterator = map.values().iterator();
                        while (iterator.hasNext()) {
                            Message message = (Message)iterator.next();
                            MessageEntry messageEntry = this.getMessageEntry(message.getQName());
                            this.setMessageReferences(messageEntry, definition, document, false);
                        }
                    }
                } else {
                    Iterator iterator = map.values().iterator();
                    while (iterator.hasNext()) {
                        PortType portType = (PortType)iterator.next();
                        PortTypeEntry portTypeEntry = this.getPortTypeEntry(portType.getQName());
                        this.setPortTypeReferences(portTypeEntry, null, definition, document);
                    }
                }
            } else {
                Iterator iterator = map.values().iterator();
                while (iterator.hasNext()) {
                    Binding binding = (Binding)iterator.next();
                    BindingEntry bindingEntry = this.getBindingEntry(binding.getQName());
                    this.setBindingReferences(bindingEntry, definition, document);
                }
            }
        } else {
            Iterator iterator = map.values().iterator();
            while (iterator.hasNext()) {
                Service service = (Service)iterator.next();
                ServiceEntry serviceEntry = this.getServiceEntry(service.getQName());
                this.setServiceReferences(serviceEntry, definition, document);
            }
        }
    }

    private void setTypeReferences(TypeEntry typeEntry, Document document, boolean bl) {
        TypeEntry typeEntry2;
        Serializable serializable;
        QName qName;
        if (this.wrapped) {
            if (!typeEntry.isReferenced() && bl) {
                typeEntry.setOnlyLiteralReference(true);
            } else if (typeEntry.isOnlyLiteralReferenced() && !bl) {
                typeEntry.setOnlyLiteralReference(false);
            }
        }
        Node node = typeEntry.getNode();
        if (this.addImports || node == null || node.getOwnerDocument() == document) {
            typeEntry.setIsReferenced(true);
            if (typeEntry instanceof DefinedElement && (qName = Utils.getNodeTypeRefQName(node, (BooleanHolder)(serializable = new BooleanHolder()))) != null && (typeEntry2 = this.getTypeEntry(qName, ((BooleanHolder)serializable).value)) != null) {
                this.setTypeReferences(typeEntry2, document, bl);
            }
        }
        serializable = Utils.getNestedTypes(node, this);
        qName = ((HashSet)serializable).iterator();
        while (qName.hasNext()) {
            typeEntry2 = (TypeEntry)qName.next();
            if (typeEntry2.isReferenced()) continue;
            this.setTypeReferences(typeEntry2, document, false);
        }
    }

    private void setMessageReferences(MessageEntry messageEntry, Definition definition, Document document, boolean bl) {
        Object object;
        Message message = messageEntry.getMessage();
        if (this.addImports) {
            messageEntry.setIsReferenced(true);
        } else {
            object = definition.getMessages();
            if (object.containsValue(message)) {
                messageEntry.setIsReferenced(true);
            }
        }
        object = message.getParts().values().iterator();
        while (object.hasNext()) {
            Part part = (Part)object.next();
            TypeEntry typeEntry = this.getType(part.getTypeName());
            if (typeEntry != null) {
                this.setTypeReferences(typeEntry, document, bl);
            }
            if ((typeEntry = this.getElement(part.getElementName())) == null) continue;
            this.setTypeReferences(typeEntry, document, bl);
            TypeEntry typeEntry2 = typeEntry.getRefType();
            if (typeEntry2 == null) continue;
            this.setTypeReferences(typeEntry2, document, bl);
        }
    }

    private void setPortTypeReferences(PortTypeEntry portTypeEntry, BindingEntry bindingEntry, Definition definition, Document document) {
        Object object;
        PortType portType = portTypeEntry.getPortType();
        if (this.addImports) {
            portTypeEntry.setIsReferenced(true);
        } else {
            object = definition.getPortTypes();
            if (object.containsValue(portType)) {
                portTypeEntry.setIsReferenced(true);
            }
        }
        object = portType.getOperations().iterator();
        while (object.hasNext()) {
            MessageEntry messageEntry;
            Object object2;
            Operation operation = (Operation)object.next();
            Input input = operation.getInput();
            Output output = operation.getOutput();
            boolean bl = false;
            boolean bl2 = false;
            if (bindingEntry != null) {
                bl = bindingEntry.getInputBodyType(operation) == 1;
                boolean bl3 = bl2 = bindingEntry.getOutputBodyType(operation) == 1;
            }
            if (input != null && (object2 = input.getMessage()) != null && (messageEntry = this.getMessageEntry(object2.getQName())) != null) {
                this.setMessageReferences(messageEntry, definition, document, bl);
            }
            if (output != null && (object2 = output.getMessage()) != null && (messageEntry = this.getMessageEntry(object2.getQName())) != null) {
                this.setMessageReferences(messageEntry, definition, document, bl2);
            }
            object2 = operation.getFaults().values().iterator();
            while (object2.hasNext()) {
                MessageEntry messageEntry2;
                messageEntry = ((Fault)object2.next()).getMessage();
                if (messageEntry == null || (messageEntry2 = this.getMessageEntry(messageEntry.getQName())) == null) continue;
                this.setMessageReferences(messageEntry2, definition, document, false);
            }
        }
    }

    private void setBindingReferences(BindingEntry bindingEntry, Definition definition, Document document) {
        if (bindingEntry.getBindingType() == 0) {
            Map map;
            Binding binding = bindingEntry.getBinding();
            if (this.addImports) {
                bindingEntry.setIsReferenced(true);
            } else {
                map = definition.getBindings();
                if (map.containsValue(binding)) {
                    bindingEntry.setIsReferenced(true);
                }
            }
            map = binding.getPortType();
            PortTypeEntry portTypeEntry = this.getPortTypeEntry(map.getQName());
            if (portTypeEntry != null) {
                this.setPortTypeReferences(portTypeEntry, bindingEntry, definition, document);
            }
        }
    }

    private void setServiceReferences(ServiceEntry serviceEntry, Definition definition, Document document) {
        Object object;
        Service service = serviceEntry.getService();
        if (this.addImports) {
            serviceEntry.setIsReferenced(true);
        } else {
            object = definition.getServices();
            if (object.containsValue(service)) {
                serviceEntry.setIsReferenced(true);
            }
        }
        object = service.getPorts().values().iterator();
        while (object.hasNext()) {
            Port port = (Port)object.next();
            Binding binding = port.getBinding();
            BindingEntry bindingEntry = this.getBindingEntry(binding.getQName());
            if (bindingEntry == null) continue;
            this.setBindingReferences(bindingEntry, definition, document);
        }
    }

    private void symbolTablePut(SymTabEntry symTabEntry) throws IOException {
        QName qName = symTabEntry.getQName();
        if (this.get(qName, symTabEntry.getClass()) == null) {
            if (this.debug) {
                System.out.println("Symbol Table add " + qName + " as " + symTabEntry.getClass().getName().substring(symTabEntry.getClass().getName().lastIndexOf(".") + 1));
            }
            if (symTabEntry instanceof Type && this.get(qName, class$org$apache$axis$wsdl$toJava$UndefinedType == null ? (class$org$apache$axis$wsdl$toJava$UndefinedType = SymbolTable.class$("org.apache.axis.wsdl.toJava.UndefinedType")) : class$org$apache$axis$wsdl$toJava$UndefinedType) != null) {
                Vector vector = (Vector)this.symbolTable.get(qName);
                int n = 0;
                while (n < vector.size()) {
                    Object e = vector.elementAt(n);
                    if (e instanceof UndefinedType) {
                        vector.setElementAt(symTabEntry, n);
                        int n2 = 0;
                        while (n2 < this.types.size()) {
                            if (this.types.elementAt(n2) == e) {
                                this.types.setElementAt(symTabEntry, n2);
                            }
                            ++n2;
                        }
                        ((UndefinedType)e).update((Type)symTabEntry);
                    }
                    ++n;
                }
            } else if (symTabEntry instanceof Element && this.get(qName, class$org$apache$axis$wsdl$toJava$UndefinedElement == null ? (class$org$apache$axis$wsdl$toJava$UndefinedElement = SymbolTable.class$("org.apache.axis.wsdl.toJava.UndefinedElement")) : class$org$apache$axis$wsdl$toJava$UndefinedElement) != null) {
                Vector vector = (Vector)this.symbolTable.get(qName);
                int n = 0;
                while (n < vector.size()) {
                    Object e = vector.elementAt(n);
                    if (e instanceof UndefinedElement) {
                        vector.setElementAt(symTabEntry, n);
                        int n3 = 0;
                        while (n3 < this.types.size()) {
                            if (this.types.elementAt(n3) == e) {
                                this.types.setElementAt(symTabEntry, n3);
                            }
                            ++n3;
                        }
                        ((Undefined)e).update((Element)symTabEntry);
                    }
                    ++n;
                }
            } else {
                Vector<SymTabEntry> vector = (Vector<SymTabEntry>)this.symbolTable.get(qName);
                if (vector == null) {
                    vector = new Vector<SymTabEntry>();
                    this.symbolTable.put(qName, vector);
                }
                vector.add(symTabEntry);
                if (symTabEntry instanceof TypeEntry) {
                    this.types.add(symTabEntry);
                }
            }
        } else {
            throw new IOException(JavaUtils.getMessage("alreadyExists00", "" + qName));
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

