/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.wsdl.toJava;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import javax.wsdl.QName;
import org.apache.axis.utils.JavaUtils;
import org.apache.axis.wsdl.toJava.Emitter;
import org.apache.axis.wsdl.toJava.Namespaces;
import org.apache.axis.wsdl.toJava.SymTabEntry;
import org.apache.axis.wsdl.toJava.TypeEntry;
import org.apache.axis.wsdl.toJava.Utils;
import org.apache.axis.wsdl.toJava.Writer;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class JavaWriter
implements Writer {
    protected Emitter emitter;
    protected QName qname;
    protected Namespaces namespaces;
    protected String className;
    protected String fileName;
    protected String packageName;
    protected PrintWriter pw;
    protected String message;
    protected String type;
    private static HashMap TYPES = new HashMap(7);

    protected JavaWriter(Emitter emitter, SymTabEntry symTabEntry, String string, String string2, String string3, String string4) {
        this.emitter = emitter;
        this.qname = symTabEntry.getQName();
        this.namespaces = emitter.getNamespaces();
        this.className = Utils.getJavaLocalName(symTabEntry.getName()) + (string == null ? "" : string);
        this.fileName = this.className + '.' + string2;
        this.packageName = Utils.getJavaPackageName(symTabEntry.getName());
        this.message = string3;
        this.type = string4;
    }

    protected JavaWriter(Emitter emitter, QName qName, String string, String string2, String string3, String string4) {
        this.emitter = emitter;
        this.qname = qName;
        this.namespaces = emitter.getNamespaces();
        this.className = qName.getLocalPart() + (string == null ? "" : string);
        this.fileName = this.className + '.' + string2;
        this.packageName = this.namespaces.getCreate(qName.getNamespaceURI());
        this.message = string3;
        this.type = string4;
    }

    public void write() throws IOException {
        String string = this.namespaces.toDir(this.packageName);
        String string2 = string + this.fileName;
        String string3 = this.packageName + "." + this.className;
        if (this.emitter.fileInfo.getClassNames().contains(string3)) {
            throw new IOException(JavaUtils.getMessage("duplicateClass00", string3));
        }
        if (this.emitter.fileInfo.getFileNames().contains(string2)) {
            throw new IOException(JavaUtils.getMessage("duplicateFile00", string2));
        }
        this.emitter.fileInfo.add(string2, string3, this.type);
        this.namespaces.mkdir(this.packageName);
        File file = new File(string, this.fileName);
        if (this.emitter.bVerbose) {
            System.out.println(this.message + ":  " + file.getPath());
        }
        this.pw = new PrintWriter(new FileWriter(file));
        this.writeFileHeader();
        this.writeFileBody();
    }

    protected void writeFileHeader() throws IOException {
        this.pw.println("/**");
        this.pw.println(" * " + this.fileName);
        this.pw.println(" *");
        this.pw.println(" * " + JavaUtils.getMessage("wsdlGenLine00"));
        this.pw.println(" * " + JavaUtils.getMessage("wsdlGenLine01"));
        this.pw.println(" */");
        this.pw.println();
        this.pw.println("package " + this.packageName + ";");
        this.pw.println();
    }

    protected void writeComment(PrintWriter printWriter, Element element) {
        if (element == null) {
            return;
        }
        Node node = element.getFirstChild();
        if (node == null) {
            return;
        }
        String string = node.getNodeValue();
        string = string.replace('\r', ' ');
        if ((string = string.replace('\n', ' ')) != null) {
            int n = 0;
            printWriter.println();
            while (n < string.length()) {
                int n2 = n + 65;
                if (n2 > string.length()) {
                    n2 = string.length();
                }
                while (n2 < string.length() && !Character.isWhitespace(string.charAt(n2))) {
                    ++n2;
                }
                printWriter.println("    // " + string.substring(n, n2).trim());
                n = n2 + 1;
            }
        }
    }

    protected String wrapPrimitiveType(TypeEntry typeEntry, String string) {
        String string2;
        String string3 = string2 = typeEntry == null ? null : (String)TYPES.get(typeEntry.getName());
        if (string2 != null) {
            return "new " + string2 + "(" + string + ")";
        }
        if (typeEntry != null && typeEntry.getName().equals("byte[]") && typeEntry.getQName().getLocalPart().equals("hexBinary")) {
            return "new org.apache.axis.encoding.Hex(" + string + ")";
        }
        return string;
    }

    protected String getResponseString(TypeEntry typeEntry, String string) {
        if (typeEntry == null) {
            return ";";
        }
        String string2 = (String)TYPES.get(typeEntry.getName());
        if (string2 != null) {
            return "((" + string2 + ") " + string + ")." + typeEntry.getName() + "Value();";
        }
        return "(" + typeEntry.getName() + ") " + string + ";";
    }

    protected boolean isPrimitiveType(TypeEntry typeEntry) {
        return TYPES.get(typeEntry.getName()) != null;
    }

    protected void initializeDeploymentDoc(String string) throws IOException {
        if ("deploy".equals(string)) {
            this.pw.println(JavaUtils.getMessage("deploy00"));
        } else {
            this.pw.println(JavaUtils.getMessage("deploy01"));
        }
        this.pw.println(JavaUtils.getMessage("deploy02"));
        if ("deploy".equals(string)) {
            this.pw.println(JavaUtils.getMessage("deploy03"));
        } else {
            this.pw.println(JavaUtils.getMessage("deploy04"));
        }
        this.pw.println(JavaUtils.getMessage("deploy05"));
        this.pw.println(JavaUtils.getMessage("deploy06"));
        if ("deploy".equals(string)) {
            this.pw.println(JavaUtils.getMessage("deploy07"));
        } else {
            this.pw.println(JavaUtils.getMessage("deploy08"));
        }
        this.pw.println(JavaUtils.getMessage("deploy09"));
        this.pw.println();
        if ("deploy".equals(string)) {
            this.pw.println("<deployment");
            this.pw.println("    xmlns=\"http://xml.apache.org/axis/wsdd/\"");
            this.pw.println("    xmlns:java=\"http://xml.apache.org/axis/wsdd/providers/java\">");
        } else {
            this.pw.println("<undeployment");
            this.pw.println("    xmlns=\"http://xml.apache.org/axis/wsdd/\">");
        }
    }

    protected boolean fileExists(String string, String string2) throws IOException {
        String string3 = this.emitter.getNamespaces().getAsDir(string2);
        String string4 = string3 + string;
        return new File(string4).exists();
    }

    protected abstract void writeFileBody() throws IOException;

    static {
        TYPES.put("int", "Integer");
        TYPES.put("float", "Float");
        TYPES.put("boolean", "Boolean");
        TYPES.put("double", "Double");
        TYPES.put("byte", "Byte");
        TYPES.put("short", "Short");
        TYPES.put("long", "Long");
    }
}

