/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.wsdl.toJava;

import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.wsdl.Binding;
import javax.wsdl.BindingInput;
import javax.wsdl.BindingOperation;
import javax.wsdl.BindingOutput;
import javax.wsdl.Fault;
import javax.wsdl.Operation;
import javax.wsdl.OperationType;
import javax.wsdl.Part;
import javax.wsdl.PortType;
import javax.wsdl.QName;
import javax.wsdl.extensions.soap.SOAPBody;
import javax.wsdl.extensions.soap.SOAPOperation;
import org.apache.axis.utils.JavaUtils;
import org.apache.axis.wsdl.toJava.BindingEntry;
import org.apache.axis.wsdl.toJava.CollectionType;
import org.apache.axis.wsdl.toJava.DefinedElement;
import org.apache.axis.wsdl.toJava.Element;
import org.apache.axis.wsdl.toJava.Emitter;
import org.apache.axis.wsdl.toJava.JavaWriter;
import org.apache.axis.wsdl.toJava.Parameter;
import org.apache.axis.wsdl.toJava.Parameters;
import org.apache.axis.wsdl.toJava.PortTypeEntry;
import org.apache.axis.wsdl.toJava.SchemaUtils;
import org.apache.axis.wsdl.toJava.SymbolTable;
import org.apache.axis.wsdl.toJava.TypeEntry;
import org.apache.axis.wsdl.toJava.Utils;
import org.w3c.dom.Node;

public class JavaStubWriter
extends JavaWriter {
    private BindingEntry bEntry;
    private Binding binding;
    private SymbolTable symbolTable;
    private boolean firstSer = true;

    protected JavaStubWriter(Emitter emitter, BindingEntry bindingEntry, SymbolTable symbolTable) {
        super(emitter, bindingEntry, "Stub", "java", JavaUtils.getMessage("genStub00"), "stub");
        this.bEntry = bindingEntry;
        this.binding = bindingEntry.getBinding();
        this.symbolTable = symbolTable;
    }

    protected void writeFileBody() throws IOException {
        PortType portType = this.binding.getPortType();
        PortTypeEntry portTypeEntry = this.symbolTable.getPortTypeEntry(portType.getQName());
        String string = Utils.xmlNameToJavaClass(this.qname.getLocalPart());
        String string2 = this.bEntry.hasLiteral() ? this.bEntry.getName() : portTypeEntry.getName();
        boolean bl = true;
        if (this.bEntry.getBindingStyle() == 1) {
            bl = false;
        }
        this.pw.println("public class " + this.className + " extends org.apache.axis.client.Stub implements " + string2 + " {");
        HashSet hashSet = this.getTypesInPortType(portType);
        if (hashSet.size() > 0) {
            this.pw.println("    private java.util.Vector cachedSerClasses = new java.util.Vector();");
            this.pw.println("    private java.util.Vector cachedSerQNames = new java.util.Vector();");
            this.pw.println("    private java.util.Vector cachedSerFactories = new java.util.Vector();");
            this.pw.println("    private java.util.Vector cachedDeserFactories = new java.util.Vector();");
        }
        this.pw.println();
        this.pw.println("    public " + this.className + "() throws org.apache.axis.AxisFault {");
        this.pw.println("         this(null);");
        this.pw.println("    }");
        this.pw.println();
        this.pw.println("    public " + this.className + "(java.net.URL endpointURL, javax.xml.rpc.Service service) throws org.apache.axis.AxisFault {");
        this.pw.println("         this(service);");
        this.pw.println("         super.cachedEndpoint = endpointURL;");
        this.pw.println("    }");
        this.pw.println();
        this.pw.println("    public " + this.className + "(javax.xml.rpc.Service service) throws org.apache.axis.AxisFault {");
        this.pw.println("        try {");
        this.pw.println("            if (service == null) {");
        this.pw.println("                super.service = new org.apache.axis.client.Service();");
        this.pw.println("            } else {");
        this.pw.println("                super.service = service;");
        this.pw.println("            }");
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            this.writeSerializationInit((TypeEntry)iterator.next());
        }
        this.pw.println("        }");
        this.pw.println("        catch(Exception t) {");
        this.pw.println("            throw org.apache.axis.AxisFault.makeFault(t);");
        this.pw.println("        }");
        this.pw.println("    }");
        this.pw.println();
        this.pw.println("    private org.apache.axis.client.Call getCall() throws java.rmi.RemoteException {");
        this.pw.println("        try {");
        this.pw.println("            org.apache.axis.client.Call call =");
        this.pw.println("                    (org.apache.axis.client.Call) super.service.createCall();");
        this.pw.println("            if (super.maintainSessionSet) {");
        this.pw.println("                call.setMaintainSession(super.maintainSession);");
        this.pw.println("            }");
        this.pw.println("            if (super.cachedUsername != null) {");
        this.pw.println("                call.setUsername(super.cachedUsername);");
        this.pw.println("            }");
        this.pw.println("            if (super.cachedPassword != null) {");
        this.pw.println("                call.setPassword(super.cachedPassword);");
        this.pw.println("            }");
        this.pw.println("            if (super.cachedEndpoint != null) {");
        this.pw.println("                call.setTargetEndpointAddress(super.cachedEndpoint);");
        this.pw.println("            }");
        this.pw.println("            if (super.cachedTimeout != null) {");
        this.pw.println("                call.setTimeout(super.cachedTimeout);");
        this.pw.println("            }");
        this.pw.println("            java.util.Enumeration keys = super.cachedProperties.keys();");
        this.pw.println("            while (keys.hasMoreElements()) {");
        this.pw.println("                String key = (String) keys.nextElement();");
        this.pw.println("                call.setProperty(key, super.cachedProperties.get(key));");
        this.pw.println("            }");
        if (hashSet.size() > 0) {
            this.pw.println("            // All the type mapping information is registered");
            this.pw.println("            // when the first call is made.");
            this.pw.println("            // The type mapping information is actually registered in");
            this.pw.println("            // the TypeMappingRegistry of the service, which");
            this.pw.println("            // is the reason why registration is only needed for the first call.");
            this.pw.println("            if (firstCall()) {");
            this.pw.println("                // must set encoding style before registering serializers");
            if (this.bEntry.hasLiteral()) {
                this.pw.println("                call.setEncodingStyle(null);");
            } else {
                this.pw.println("                call.setEncodingStyle(org.apache.axis.Constants.URI_SOAP_ENC);");
            }
            this.pw.println("                for (int i = 0; i < cachedSerFactories.size(); ++i) {");
            this.pw.println("                    Class cls = (Class) cachedSerClasses.get(i);");
            this.pw.println("                    javax.xml.rpc.namespace.QName qName =");
            this.pw.println("                            (javax.xml.rpc.namespace.QName) cachedSerQNames.get(i);");
            this.pw.println("                    Class sf = (Class)");
            this.pw.println("                             cachedSerFactories.get(i);");
            this.pw.println("                    Class df = (Class)");
            this.pw.println("                             cachedDeserFactories.get(i);");
            this.pw.println("                    call.registerTypeMapping(cls, qName, sf, df, false);");
            this.pw.println("                }");
            this.pw.println("            }");
        }
        this.pw.println("            return call;");
        this.pw.println("        }");
        this.pw.println("        catch (Throwable t) {");
        this.pw.println("            throw new org.apache.axis.AxisFault(\"" + JavaUtils.getMessage("badCall01") + "\", t);");
        this.pw.println("        }");
        this.pw.println("    }");
        this.pw.println();
        List list = this.binding.getBindingOperations();
        int n = 0;
        while (n < list.size()) {
            OperationType operationType;
            Object object;
            String string3;
            BindingOperation bindingOperation = (BindingOperation)list.get(n);
            Parameters parameters = this.bEntry.getParameters(bindingOperation.getOperation());
            String string4 = "";
            Iterator iterator2 = bindingOperation.getExtensibilityElements().iterator();
            while (iterator2.hasNext()) {
                string3 = iterator2.next();
                if (!(string3 instanceof SOAPOperation)) continue;
                string4 = ((SOAPOperation)string3).getSoapActionURI();
                break;
            }
            string3 = "";
            Iterator iterator3 = null;
            BindingInput bindingInput = bindingOperation.getBindingInput();
            if (bindingInput != null) {
                iterator3 = bindingInput.getExtensibilityElements().iterator();
            } else {
                BindingOutput bindingOutput = bindingOperation.getBindingOutput();
                if (bindingOutput != null) {
                    iterator3 = bindingOutput.getExtensibilityElements().iterator();
                }
            }
            if (iterator3 != null) {
                while (iterator3.hasNext()) {
                    object = iterator3.next();
                    if (!(object instanceof SOAPBody)) continue;
                    string3 = ((SOAPBody)object).getNamespaceURI();
                    if (string3 == null) {
                        string3 = this.emitter.def.getTargetNamespace();
                    }
                    if (string3 != null) break;
                    string3 = "";
                    break;
                }
            }
            if ((operationType = (object = bindingOperation.getOperation()).getStyle()) == OperationType.NOTIFICATION || operationType == OperationType.SOLICIT_RESPONSE) {
                this.pw.println(parameters.signature);
                this.pw.println();
            } else {
                this.writeOperation(bindingOperation, parameters, string4, string3, bl);
            }
            ++n;
        }
        this.pw.println("}");
        this.pw.close();
    }

    private HashSet getTypesInPortType(PortType portType) {
        Operation operation;
        HashSet<TypeEntry> hashSet = new HashSet<TypeEntry>();
        HashSet hashSet2 = new HashSet();
        List list = portType.getOperations();
        int n = 0;
        while (n < list.size()) {
            operation = (Operation)list.get(n);
            hashSet2.addAll(this.getTypesInOperation(operation));
            ++n;
        }
        operation = hashSet2.iterator();
        while (operation.hasNext()) {
            TypeEntry typeEntry = (TypeEntry)operation.next();
            if (hashSet.contains(typeEntry)) continue;
            hashSet.add(typeEntry);
            if (typeEntry.getNode() == null || typeEntry.getBaseType() != null) continue;
            hashSet.addAll(Utils.getNestedTypes(typeEntry.getNode(), this.symbolTable));
        }
        return hashSet;
    }

    private HashSet getTypesInOperation(Operation operation) {
        Object object;
        HashSet hashSet = new HashSet();
        Vector<TypeEntry> vector = new Vector<TypeEntry>();
        Parameters parameters = this.bEntry.getParameters(operation);
        int n = 0;
        while (n < parameters.list.size()) {
            object = (Parameter)parameters.list.get(n);
            vector.add(((Parameter)object).type);
            ++n;
        }
        if (parameters.returnType != null) {
            vector.add(parameters.returnType);
        }
        if ((object = operation.getFaults()) != null) {
            Iterator iterator = object.values().iterator();
            while (iterator.hasNext()) {
                Fault fault = (Fault)iterator.next();
                this.partTypes(vector, fault.getMessage().getOrderedParts(null), this.bEntry.getFaultBodyType(operation, fault.getName()) == 1);
            }
        }
        int n2 = 0;
        while (n2 < vector.size()) {
            hashSet.add(vector.get(n2));
            ++n2;
        }
        return hashSet;
    }

    private void partTypes(Vector vector, Collection collection, boolean bl) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Part part = (Part)iterator.next();
            QName qName = part.getTypeName();
            if (qName != null) {
                vector.add(this.symbolTable.getType(qName));
                continue;
            }
            qName = part.getElementName();
            if (qName == null) continue;
            vector.add(this.symbolTable.getElement(qName));
        }
    }

    private void writeSerializationInit(TypeEntry typeEntry) throws IOException {
        if (typeEntry.getBaseType() != null || typeEntry instanceof CollectionType) {
            return;
        }
        if (typeEntry instanceof Element) {
            return;
        }
        if (this.firstSer) {
            this.pw.println("            Class cls;");
            this.pw.println("            javax.xml.rpc.namespace.QName qName;");
            this.pw.println("            Class beansf = org.apache.axis.encoding.ser.BeanSerializerFactory.class;");
            this.pw.println("            Class beandf = org.apache.axis.encoding.ser.BeanDeserializerFactory.class;");
            this.pw.println("            Class enumsf = org.apache.axis.encoding.ser.EnumSerializerFactory.class;");
            this.pw.println("            Class enumdf = org.apache.axis.encoding.ser.EnumDeserializerFactory.class;");
            this.pw.println("            Class arraysf = org.apache.axis.encoding.ser.ArraySerializerFactory.class;");
            this.pw.println("            Class arraydf = org.apache.axis.encoding.ser.ArrayDeserializerFactory.class;");
            this.pw.println("            Class simplesf = org.apache.axis.encoding.ser.SimpleNonPrimitiveSerializerFactory.class;");
            this.pw.println("            Class simpledf = org.apache.axis.encoding.ser.SimpleDeserializerFactory.class;");
        }
        this.firstSer = false;
        QName qName = typeEntry.getQName();
        this.pw.println("            qName = new javax.xml.rpc.namespace.QName(\"" + qName.getNamespaceURI() + "\", \"" + qName.getLocalPart() + "\");");
        this.pw.println("            cachedSerQNames.add(qName);");
        this.pw.println("            cls = " + typeEntry.getName() + ".class;");
        this.pw.println("            cachedSerClasses.add(cls);");
        if (typeEntry.getName().endsWith("[]")) {
            this.pw.println("            cachedSerFactories.add(arraysf);");
            this.pw.println("            cachedDeserFactories.add(arraydf);");
        } else if (typeEntry.getNode() != null && SchemaUtils.getEnumerationBaseAndValues(typeEntry.getNode(), this.emitter.getSymbolTable()) != null) {
            this.pw.println("            cachedSerFactories.add(enumsf);");
            this.pw.println("            cachedDeserFactories.add(enumdf);");
        } else if (typeEntry.isSimpleType()) {
            this.pw.println("            cachedSerFactories.add(simplesf);");
            this.pw.println("            cachedDeserFactories.add(simpledf);");
        } else {
            this.pw.println("            cachedSerFactories.add(beansf);");
            this.pw.println("            cachedDeserFactories.add(beandf);");
        }
        this.pw.println();
    }

    private void writeOperation(BindingOperation bindingOperation, Parameters parameters, String string, String string2, boolean bl) throws IOException {
        int n;
        int n2;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        this.writeComment(this.pw, bindingOperation.getDocumentationElement());
        this.pw.println(parameters.signature + "{");
        this.pw.println("        if (super.cachedEndpoint == null) {");
        this.pw.println("            throw new org.apache.axis.NoEndPointException();");
        this.pw.println("        }");
        this.pw.println("        org.apache.axis.client.Call call = getCall();");
        int n3 = 0;
        while (n3 < parameters.list.size()) {
            QName qName;
            object4 = (Parameter)parameters.list.get(n3);
            object3 = ((Parameter)object4).type.getQName();
            if (((Parameter)object4).type instanceof DefinedElement && (qName = Utils.getNodeTypeRefQName((Node)(object2 = this.symbolTable.getTypeEntry(((Parameter)object4).type.getQName(), true).getNode()), "type")) != null) {
                object3 = qName;
            }
            object2 = "new javax.xml.rpc.namespace.QName(\"" + object3.getNamespaceURI() + "\", \"" + object3.getLocalPart() + "\")";
            qName = ((Parameter)object4).getQName();
            object = "p" + n3 + "QName";
            this.pw.println("        javax.xml.rpc.namespace.QName " + (String)object + " = new javax.xml.rpc.namespace.QName(\"" + qName.getNamespaceURI() + "\", \"" + qName.getLocalPart() + "\");");
            if (((Parameter)object4).mode == 1) {
                this.pw.println("        call.addParameter(" + (String)object + ", " + (String)object2 + ", javax.xml.rpc.ParameterMode.PARAM_MODE_IN);");
            } else if (((Parameter)object4).mode == 3) {
                this.pw.println("        call.addParameter(" + (String)object + ", " + (String)object2 + ", javax.xml.rpc.ParameterMode.PARAM_MODE_INOUT);");
            } else {
                this.pw.println("        call.addParameter(" + (String)object + ", " + (String)object2 + ", javax.xml.rpc.ParameterMode.PARAM_MODE_OUT);");
            }
            ++n3;
        }
        if (parameters.returnType != null) {
            object4 = parameters.returnType.getQName();
            if (parameters.returnType instanceof DefinedElement && (object2 = Utils.getNodeTypeRefQName((Node)(object3 = this.symbolTable.getTypeEntry(parameters.returnType.getQName(), true).getNode()), "type")) != null) {
                object4 = object2;
            }
            object3 = "new javax.xml.rpc.namespace.QName(\"" + object4.getNamespaceURI() + "\", \"" + object4.getLocalPart() + "\")";
            this.pw.println("        call.setReturnType(" + (String)object3 + ");");
        } else {
            this.pw.println("        call.setReturnType(null);");
        }
        if (string != null) {
            this.pw.println("        call.setUseSOAPAction(true);");
            this.pw.println("        call.setSOAPActionURI(\"" + string + "\");");
        }
        if ((n2 = this.bEntry.getInputBodyType(bindingOperation.getOperation())) == 1) {
            if (this.symbolTable.isWrapped()) {
                this.pw.println("        call.setProperty(\"wrapped\", Boolean.TRUE);");
            }
            this.pw.println("        call.setEncodingStyle(null);");
            this.pw.println("        call.setProperty(org.apache.axis.AxisEngine.PROP_DOMULTIREFS, Boolean.FALSE);");
            this.pw.println("        call.setProperty(org.apache.axis.client.Call.SEND_TYPE_ATTR, Boolean.FALSE);");
        }
        if ((n = this.bEntry.getBindingStyle()) == 1) {
            this.pw.println("        call.setOperationStyle(\"document\");");
        } else {
            this.pw.println("        call.setOperationStyle(\"rpc\");");
        }
        this.pw.println("        call.setOperationName(new javax.xml.rpc.namespace.QName(\"" + string2 + "\", \"" + bindingOperation.getName() + "\"));");
        this.pw.println();
        this.pw.print("        Object resp = call.invoke(");
        this.pw.print("new Object[] {");
        boolean bl2 = false;
        int n4 = 0;
        while (n4 < parameters.list.size()) {
            object = (Parameter)parameters.list.get(n4);
            String string3 = Utils.xmlNameToJava(((Parameter)object).getName());
            if (((Parameter)object).mode != 2) {
                if (bl2) {
                    this.pw.print(", ");
                } else {
                    bl2 = true;
                }
                if (((Parameter)object).mode == 1) {
                    this.pw.print(this.wrapPrimitiveType(((Parameter)object).type, string3));
                } else {
                    this.pw.print(this.wrapPrimitiveType(((Parameter)object).type, string3 + ".value"));
                }
            }
            ++n4;
        }
        this.pw.println("});");
        this.pw.println();
        this.pw.println("        if (resp instanceof java.rmi.RemoteException) {");
        this.pw.println("            throw (java.rmi.RemoteException)resp;");
        this.pw.println("        }");
        int n5 = parameters.outputs + parameters.inouts;
        if (n5 > 0) {
            this.pw.println("        else {");
            if (n5 == 1) {
                if (parameters.inouts == 1) {
                    int n6 = 0;
                    Parameter parameter = (Parameter)parameters.list.get(n6);
                    while (parameter.mode != 3) {
                        parameter = (Parameter)parameters.list.get(++n6);
                    }
                    String string4 = Utils.xmlNameToJava(parameter.getName());
                    this.pw.println("            java.util.Map output;");
                    this.pw.println("            output = call.getOutputParams();");
                    if (parameter.type.getName().endsWith("[]")) {
                        this.pw.println("            // REVISIT THIS!");
                        this.pw.println("            " + string4 + ".value = (" + parameter.type.getName() + ") org.apache.axis.utils.JavaUtils.convert(output.get(\"" + parameter.getName() + "\"), " + parameter.type.getName() + ".class);");
                    } else {
                        this.pw.println("            " + string4 + ".value = " + this.getResponseString(parameter.type, "output.get(\"" + parameter.getName() + "\")"));
                    }
                } else if (parameters.returnType != null && parameters.returnType.getName() != null && parameters.returnType.getName().indexOf("[]") > 0) {
                    this.pw.println("             // REVISIT THIS!");
                    this.pw.println("             return (" + parameters.returnType.getName() + ")" + "org.apache.axis.utils.JavaUtils.convert(resp," + parameters.returnType.getName() + ".class);");
                } else {
                    this.pw.println("             return " + this.getResponseString(parameters.returnType, "resp"));
                }
            } else {
                this.pw.println("            java.util.Map output;");
                this.pw.println("            output = call.getOutputParams();");
                boolean bl3 = parameters.outputs == 0;
                int n7 = 0;
                while (n7 < parameters.list.size()) {
                    Parameter parameter = (Parameter)parameters.list.get(n7);
                    String string5 = Utils.xmlNameToJava(parameter.getName());
                    if (parameter.mode != 1) {
                        if (bl3) {
                            bl3 = false;
                            if (parameter.type.getName().endsWith("[]")) {
                                this.pw.println("             // REVISIT THIS!");
                                this.pw.println("            " + string5 + ".value = (" + parameter.type.getName() + ") org.apache.axis.utils.JavaUtils.convert(output.get(\"" + parameter.getName() + "\"), " + parameter.type.getName() + ".class);");
                            } else {
                                this.pw.println("            " + string5 + ".value = " + this.getResponseString(parameter.type, "output.get(\"" + parameter.getName() + "\")"));
                            }
                        } else if (parameter.type.getName().endsWith("[]")) {
                            this.pw.println("             // REVISIT THIS!");
                            this.pw.println("            " + string5 + ".value = (" + parameter.type.getName() + ") org.apache.axis.utils.JavaUtils.convert(" + "output.get(\"" + parameter.getName() + "\"), " + parameter.type.getName() + ".class);");
                        } else {
                            this.pw.println("            " + string5 + ".value = " + this.getResponseString(parameter.type, "output.get(\"" + parameter.getName() + "\")"));
                        }
                    }
                    ++n7;
                }
                if (parameters.outputs > 0) {
                    if (parameters.returnType != null && parameters.returnType.getName() != null && parameters.returnType.getName().indexOf("[]") > 0) {
                        this.pw.println("             // REVISIT THIS!");
                        this.pw.println("             return (" + parameters.returnType.getName() + ")" + "org.apache.axis.utils.JavaUtils.convert(output.get(" + parameters.returnName + ")," + parameters.returnType.getName() + ".class);");
                    } else if (parameters.returnType != null) {
                        this.pw.println("             return " + this.getResponseString(parameters.returnType, "resp"));
                    }
                }
            }
            this.pw.println("        }");
        }
        this.pw.println("    }");
        this.pw.println();
    }
}

