/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.wsdl.toJava;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import javax.wsdl.Binding;
import javax.wsdl.BindingOperation;
import javax.wsdl.Definition;
import javax.wsdl.Operation;
import javax.wsdl.OperationType;
import javax.wsdl.Part;
import javax.wsdl.Port;
import javax.wsdl.QName;
import javax.wsdl.Service;
import org.apache.axis.utils.JavaUtils;
import org.apache.axis.wsdl.toJava.BindingEntry;
import org.apache.axis.wsdl.toJava.CollectionType;
import org.apache.axis.wsdl.toJava.DefinedElement;
import org.apache.axis.wsdl.toJava.Emitter;
import org.apache.axis.wsdl.toJava.JavaWriter;
import org.apache.axis.wsdl.toJava.SchemaUtils;
import org.apache.axis.wsdl.toJava.SymbolTable;
import org.apache.axis.wsdl.toJava.TypeEntry;

public class JavaDeployWriter
extends JavaWriter {
    protected Definition definition;
    protected SymbolTable symbolTable;

    protected JavaDeployWriter(Emitter emitter, Definition definition, SymbolTable symbolTable) {
        super(emitter, new QName(definition.getTargetNamespace(), "deploy"), "", "wsdd", JavaUtils.getMessage("genDeploy00"), "deploy");
        this.definition = definition;
        this.symbolTable = symbolTable;
    }

    protected void writeFileHeader() throws IOException {
        this.initializeDeploymentDoc("deploy");
    }

    protected void writeFileBody() throws IOException {
        this.writeDeployServices();
        this.pw.println("</deployment>");
        this.pw.close();
    }

    protected void writeDeployServices() throws IOException {
        Map map = this.definition.getServices();
        Iterator iterator = map.values().iterator();
        while (iterator.hasNext()) {
            Service service = (Service)iterator.next();
            this.pw.println();
            this.pw.println("  <!-- " + JavaUtils.getMessage("wsdlService00", service.getQName().getLocalPart()) + " -->");
            this.pw.println();
            Iterator iterator2 = service.getPorts().values().iterator();
            while (iterator2.hasNext()) {
                Port port = (Port)iterator2.next();
                BindingEntry bindingEntry = this.symbolTable.getBindingEntry(port.getBinding().getQName());
                if (bindingEntry.getBindingType() != 0) continue;
                this.writeDeployPort(port);
            }
        }
    }

    protected void writeDeployTypes(boolean bl) throws IOException {
        Vector vector = this.symbolTable.getTypes();
        this.pw.println();
        int n = 0;
        while (n < vector.size()) {
            TypeEntry typeEntry = (TypeEntry)vector.elementAt(n);
            if (typeEntry.getBaseType() == null && typeEntry.isReferenced() && !typeEntry.isOnlyLiteralReferenced() && !(typeEntry instanceof CollectionType) && !(typeEntry instanceof DefinedElement)) {
                this.pw.println("      <typeMapping");
                this.pw.println("        xmlns:ns=\"" + typeEntry.getQName().getNamespaceURI() + "\"");
                this.pw.println("        qname=\"ns:" + typeEntry.getQName().getLocalPart() + '\"');
                this.pw.println("        type=\"java:" + typeEntry.getName() + '\"');
                if (typeEntry.getName().endsWith("[]")) {
                    this.pw.println("        serializer=\"org.apache.axis.encoding.ser.ArraySerializerFactory\"");
                    this.pw.println("        deserializer=\"org.apache.axis.encoding.ser.ArrayDeserializerFactory\"");
                } else if (typeEntry.getNode() != null && SchemaUtils.getEnumerationBaseAndValues(typeEntry.getNode(), this.emitter.getSymbolTable()) != null) {
                    this.pw.println("        serializer=\"org.apache.axis.encoding.ser.EnumSerializerFactory\"");
                    this.pw.println("        deserializer=\"org.apache.axis.encoding.ser.EnumDeserializerFactory\"");
                } else if (typeEntry.isSimpleType()) {
                    this.pw.println("        serializer=\"org.apache.axis.encoding.ser.SimpleNonPrimitiveSerializerFactory\"");
                    this.pw.println("        deserializer=\"org.apache.axis.encoding.ser.SimpleDeserializerFactory\"");
                } else {
                    this.pw.println("        serializer=\"org.apache.axis.encoding.ser.BeanSerializerFactory\"");
                    this.pw.println("        deserializer=\"org.apache.axis.encoding.ser.BeanDeserializerFactory\"");
                }
                if (bl) {
                    this.pw.println("        encodingStyle=\"\"");
                } else {
                    this.pw.println("        encodingStyle=\"http://schemas.xmlsoap.org/soap/encoding/\"");
                }
                this.pw.println("      />");
            }
            ++n;
        }
    }

    protected void writeDeployPort(Port port) throws IOException {
        Binding binding = port.getBinding();
        BindingEntry bindingEntry = this.symbolTable.getBindingEntry(binding.getQName());
        String string = port.getName();
        boolean bl = true;
        boolean bl2 = bindingEntry.hasLiteral();
        String string2 = "java";
        this.pw.println("  <service name=\"" + string + "\" provider=\"" + (bl ? string2 + ":RPC" : string2 + ":MSG") + "\"" + (bl2 ? " style=\"document\"" : "") + ">");
        this.writeDeployBinding(binding);
        this.writeDeployTypes(bl2);
        this.pw.println("  </service>");
    }

    protected void writeDeployBinding(Binding binding) throws IOException {
        Object object;
        Operation operation;
        Object object2;
        BindingEntry bindingEntry = this.symbolTable.getBindingEntry(binding.getQName());
        String string = bindingEntry.getName();
        string = this.emitter.getDeploySkeleton() ? string + "Skeleton" : string + "Impl";
        this.pw.println("      <parameter name=\"className\" value=\"" + string + "\"/>");
        String string2 = "";
        HashMap<QName, String> hashMap = new HashMap<QName, String>();
        Iterator iterator = binding.getBindingOperations().iterator();
        while (iterator.hasNext()) {
            Iterator iterator2;
            Part part;
            QName qName;
            Map map;
            object2 = (BindingOperation)iterator.next();
            operation = object2.getOperation();
            object = operation.getStyle();
            if (object != OperationType.NOTIFICATION && object != OperationType.SOLICIT_RESPONSE) {
                string2 = string2 + " " + object2.getName();
            }
            if (bindingEntry.getInputBodyType(operation) != 1 || (map = operation.getInput().getMessage().getParts()).isEmpty() || (qName = (part = (Part)(iterator2 = map.values().iterator()).next()).getElementName()) == null) continue;
            hashMap.put(qName, object2.getName());
        }
        this.pw.println("      <parameter name=\"allowedMethods\" value=\"" + string2.substring(1) + "\"/>");
        if (!hashMap.isEmpty()) {
            object2 = hashMap.keySet().iterator();
            while (object2.hasNext()) {
                operation = (QName)object2.next();
                object = operation.getNamespaceURI();
                this.pw.println("      <elementMapping xmlns:ns=\"" + (String)object + "\" element=\"ns:" + operation.getLocalPart() + "\" " + "method=\"" + hashMap.get(operation) + "\"/>");
            }
        }
        if (this.emitter.getScope() == 1) {
            this.pw.println("      <parameter name=\"scope\" value=\"Application\"/>");
        } else if (this.emitter.getScope() == 16) {
            this.pw.println("      <parameter name=\"scope\" value=\"Request\"/>");
        } else if (this.emitter.getScope() == 17) {
            this.pw.println("      <parameter name=\"scope\" value=\"Session\"/>");
        }
    }
}

