/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.wsdl.toJava;

import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.wsdl.Definition;
import javax.wsdl.Fault;
import javax.wsdl.Import;
import javax.wsdl.Operation;
import javax.wsdl.PortType;
import javax.wsdl.QName;
import org.apache.axis.wsdl.toJava.Emitter;
import org.apache.axis.wsdl.toJava.JavaDeployWriter;
import org.apache.axis.wsdl.toJava.JavaFaultWriter;
import org.apache.axis.wsdl.toJava.JavaUndeployWriter;
import org.apache.axis.wsdl.toJava.SymbolTable;
import org.apache.axis.wsdl.toJava.Utils;
import org.apache.axis.wsdl.toJava.Writer;

public class JavaDefinitionWriter
implements Writer {
    Writer deployWriter = null;
    Writer undeployWriter = null;
    Emitter emitter;
    Definition definition;
    SymbolTable symbolTable;
    private HashSet importedFiles = new HashSet();

    public JavaDefinitionWriter(Emitter emitter, Definition definition, SymbolTable symbolTable) {
        this.deployWriter = new JavaDeployWriter(emitter, definition, symbolTable);
        this.undeployWriter = new JavaUndeployWriter(emitter, definition, symbolTable);
        this.emitter = emitter;
        this.definition = definition;
        this.symbolTable = symbolTable;
    }

    public void write() throws IOException {
        if (this.emitter.getGenerateSkeleton()) {
            this.deployWriter.write();
            this.undeployWriter.write();
        }
        this.writeFaults();
    }

    private void writeFaults() throws IOException {
        HashMap hashMap = new HashMap();
        this.collectFaults(this.definition, hashMap);
        Iterator iterator = hashMap.keySet().iterator();
        while (iterator.hasNext()) {
            Fault fault = (Fault)iterator.next();
            QName qName = (QName)hashMap.get(fault);
            new JavaFaultWriter(this.emitter, qName, fault, this.symbolTable).write();
        }
    }

    private void collectFaults(Definition definition, Map map) throws IOException {
        List list;
        PortType portType;
        Object object;
        Vector<String> vector = new Vector<String>();
        Map map2 = definition.getImports();
        Object[] objectArray = map2.keySet().toArray();
        int n = 0;
        while (n < objectArray.length) {
            object = (Vector)map2.get(objectArray[n]);
            int n2 = 0;
            while (n2 < ((Vector)object).size()) {
                portType = (Import)((Vector)object).get(n2);
                if (!this.importedFiles.contains(portType.getLocationURI())) {
                    this.importedFiles.add(portType.getLocationURI());
                    list = portType.getDefinition();
                    if (list != null) {
                        this.collectFaults((Definition)list, map);
                    }
                }
                ++n2;
            }
            ++n;
        }
        object = definition.getPortTypes();
        Iterator iterator = object.values().iterator();
        while (iterator.hasNext()) {
            portType = (PortType)iterator.next();
            if (!this.symbolTable.getPortTypeEntry(portType.getQName()).isReferenced()) continue;
            list = portType.getOperations();
            int n3 = 0;
            while (n3 < list.size()) {
                Operation operation = (Operation)list.get(n3);
                Map map3 = operation.getFaults();
                Iterator iterator2 = map3.values().iterator();
                while (iterator2.hasNext()) {
                    Fault fault = (Fault)iterator2.next();
                    String string = Utils.getFullExceptionName(fault, this.symbolTable, portType.getQName().getNamespaceURI());
                    if (vector.contains(string)) continue;
                    vector.add(string);
                    QName qName = new QName(portType.getQName().getNamespaceURI(), Utils.getExceptionName(fault));
                    map.put(fault, qName);
                }
                ++n3;
            }
        }
    }
}

