/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.wsdl.toJava;

import java.io.IOException;
import javax.wsdl.Binding;
import org.apache.axis.utils.JavaUtils;
import org.apache.axis.wsdl.toJava.BindingEntry;
import org.apache.axis.wsdl.toJava.Emitter;
import org.apache.axis.wsdl.toJava.JavaImplWriter;
import org.apache.axis.wsdl.toJava.JavaInterfaceWriter;
import org.apache.axis.wsdl.toJava.JavaSkelWriter;
import org.apache.axis.wsdl.toJava.JavaStubWriter;
import org.apache.axis.wsdl.toJava.JavaWriter;
import org.apache.axis.wsdl.toJava.PortTypeEntry;
import org.apache.axis.wsdl.toJava.SymbolTable;
import org.apache.axis.wsdl.toJava.Utils;
import org.apache.axis.wsdl.toJava.Writer;

public class JavaBindingWriter
implements Writer {
    Writer stubWriter = null;
    Writer skelWriter = null;
    Writer implWriter = null;
    Writer interfaceWriter = null;

    public JavaBindingWriter(Emitter emitter, Binding binding, SymbolTable symbolTable) {
        BindingEntry bindingEntry = symbolTable.getBindingEntry(binding.getQName());
        PortTypeEntry portTypeEntry = symbolTable.getPortTypeEntry(binding.getPortType().getQName());
        if (portTypeEntry.isReferenced()) {
            this.interfaceWriter = new JavaInterfaceWriter(emitter, portTypeEntry, bindingEntry, symbolTable);
        }
        if (bindingEntry.isReferenced()) {
            this.stubWriter = new JavaStubWriter(emitter, bindingEntry, symbolTable);
            if (emitter.bEmitSkeleton) {
                this.skelWriter = new JavaSkelWriter(emitter, bindingEntry, symbolTable);
                String string = Utils.getJavaLocalName(bindingEntry.getName()) + "Impl.java";
                try {
                    if (!((JavaWriter)this.stubWriter).fileExists(string, binding.getQName().getNamespaceURI())) {
                        this.implWriter = new JavaImplWriter(emitter, bindingEntry, symbolTable);
                    }
                }
                catch (IOException iOException) {
                    System.err.println(JavaUtils.getMessage("fileExistError00", string));
                }
            }
        }
    }

    public void write() throws IOException {
        if (this.interfaceWriter != null) {
            this.interfaceWriter.write();
        }
        if (this.stubWriter != null) {
            this.stubWriter.write();
        }
        if (this.skelWriter != null) {
            this.skelWriter.write();
        }
        if (this.implWriter != null) {
            this.implWriter.write();
        }
    }
}

