/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.wsdl.fromJava;

import com.ibm.wsdl.extensions.soap.SOAPAddressImpl;
import com.ibm.wsdl.extensions.soap.SOAPBindingImpl;
import com.ibm.wsdl.extensions.soap.SOAPBodyImpl;
import com.ibm.wsdl.extensions.soap.SOAPOperationImpl;
import java.io.File;
import java.io.FileOutputStream;
import java.io.StringWriter;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.wsdl.Binding;
import javax.wsdl.BindingInput;
import javax.wsdl.BindingOperation;
import javax.wsdl.BindingOutput;
import javax.wsdl.Definition;
import javax.wsdl.Fault;
import javax.wsdl.Import;
import javax.wsdl.Input;
import javax.wsdl.Message;
import javax.wsdl.Operation;
import javax.wsdl.Output;
import javax.wsdl.Part;
import javax.wsdl.Port;
import javax.wsdl.PortType;
import javax.wsdl.QName;
import javax.wsdl.Service;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.factory.WSDLFactory;
import org.apache.axis.encoding.DefaultSOAP12TypeMappingImpl;
import org.apache.axis.encoding.DefaultTypeMappingImpl;
import org.apache.axis.encoding.TypeMapping;
import org.apache.axis.utils.XMLUtils;
import org.apache.axis.wsdl.fromJava.BuilderPortTypeClassRep;
import org.apache.axis.wsdl.fromJava.ClassRep;
import org.apache.axis.wsdl.fromJava.DefaultFactory;
import org.apache.axis.wsdl.fromJava.ExceptionRep;
import org.apache.axis.wsdl.fromJava.Java2WSDLFactory;
import org.apache.axis.wsdl.fromJava.MethodRep;
import org.apache.axis.wsdl.fromJava.Namespaces;
import org.apache.axis.wsdl.fromJava.ParamRep;
import org.apache.axis.wsdl.fromJava.Types;
import org.w3c.dom.Document;

public class Emitter {
    public static final int MODE_ALL = 0;
    public static final int MODE_INTERFACE = 1;
    public static final int MODE_IMPLEMENTATION = 2;
    public static final int MODE_RPC = 0;
    public static final int MODE_DOCUMENT = 1;
    private Class cls;
    private Class implCls;
    private Vector allowedMethods = null;
    private Vector disallowedMethods = null;
    private Vector stopClasses = null;
    private boolean useInheritedMethods = false;
    private String intfNS;
    private String implNS;
    private String locationUrl;
    private String importUrl;
    private String servicePortName;
    private String serviceElementName;
    private String targetService = null;
    private String description;
    private int mode = 0;
    private TypeMapping tm = null;
    private TypeMapping defaultTM = null;
    private Namespaces namespaces = new Namespaces();
    private Map exceptionMsg = null;
    private ArrayList encodingList;
    private Types types;
    private String clsName;
    private String portTypeName;
    private Java2WSDLFactory factory = new DefaultFactory();
    static /* synthetic */ Class class$org$apache$axis$MessageContext;

    public Emitter() {
        this.exceptionMsg = new HashMap();
    }

    public void emit(String string, String string2) throws Exception {
        Definition definition = this.getIntfWSDL();
        Definition definition2 = this.getImplWSDL();
        if (string == null) {
            string = this.getServicePortName() + "_interface.wsdl";
        }
        if (string2 == null) {
            string2 = this.getServicePortName() + "_implementation.wsdl";
        }
        Document document = WSDLFactory.newInstance().newWSDLWriter().getDocument(definition);
        this.types.insertTypesFragment(document);
        this.prettyDocumentToFile(document, string);
        document = WSDLFactory.newInstance().newWSDLWriter().getDocument(definition2);
        this.prettyDocumentToFile(document, string2);
    }

    public void emit(String string) throws Exception {
        this.emit(string, 0);
    }

    public Document emit(int n) throws Exception {
        Document document = null;
        Definition definition = null;
        switch (n) {
            case 0: {
                definition = this.getWSDL();
                document = WSDLFactory.newInstance().newWSDLWriter().getDocument(definition);
                this.types.insertTypesFragment(document);
                break;
            }
            case 1: {
                definition = this.getIntfWSDL();
                document = WSDLFactory.newInstance().newWSDLWriter().getDocument(definition);
                this.types.insertTypesFragment(document);
                break;
            }
            case 2: {
                definition = this.getImplWSDL();
                document = WSDLFactory.newInstance().newWSDLWriter().getDocument(definition);
                break;
            }
            default: {
                throw new Exception("unrecognized output WSDL mode");
            }
        }
        return document;
    }

    public String emitToString(int n) throws Exception {
        Document document = this.emit(n);
        StringWriter stringWriter = new StringWriter();
        XMLUtils.PrettyDocumentToWriter(document, stringWriter);
        return stringWriter.toString();
    }

    public void emit(String string, int n) throws Exception {
        Document document = this.emit(n);
        if (string == null) {
            string = this.getServicePortName();
            switch (n) {
                case 0: {
                    string = string + ".wsdl";
                    break;
                }
                case 1: {
                    string = string + "_interface.wsdl";
                    break;
                }
                case 2: {
                    string = string + "_implementation.wsdl";
                }
            }
        }
        this.prettyDocumentToFile(document, string);
    }

    public Definition getWSDL() throws Exception {
        this.init();
        Definition definition = WSDLFactory.newInstance().newDefinition();
        this.writeDefinitions(definition, this.intfNS);
        this.types = new Types(definition, this.tm, this.defaultTM, this.namespaces, this.intfNS, this.factory, this.stopClasses);
        Binding binding = this.writeBinding(definition, true);
        this.writePortType(definition, binding);
        this.writeService(definition, binding);
        return definition;
    }

    public Definition getIntfWSDL() throws Exception {
        this.init();
        Definition definition = WSDLFactory.newInstance().newDefinition();
        this.writeDefinitions(definition, this.intfNS);
        this.types = new Types(definition, this.tm, this.defaultTM, this.namespaces, this.intfNS, this.factory, this.stopClasses);
        Binding binding = this.writeBinding(definition, true);
        this.writePortType(definition, binding);
        return definition;
    }

    public Definition getImplWSDL() throws Exception {
        this.init();
        Definition definition = WSDLFactory.newInstance().newDefinition();
        this.writeDefinitions(definition, this.implNS);
        this.writeImport(definition, this.intfNS, this.importUrl);
        Binding binding = this.writeBinding(definition, false);
        this.writeService(definition, binding);
        return definition;
    }

    private void init() throws Exception {
        if (this.encodingList == null) {
            this.clsName = this.cls.getName();
            this.clsName = this.clsName.substring(this.clsName.lastIndexOf(46) + 1);
            if (this.getPortTypeName() == null) {
                this.setPortTypeName(this.clsName);
            }
            if (this.getServiceElementName() == null) {
                this.setServiceElementName(this.getPortTypeName() + "Service");
            }
            if (this.getServicePortName() == null) {
                String string = this.getLocationUrl();
                if (string != null && (string = string.lastIndexOf(47) > 0 ? string.substring(string.lastIndexOf(47) + 1) : (string.lastIndexOf(92) > 0 ? string.substring(string.lastIndexOf(92) + 1) : null)) != null && string.endsWith(".jws")) {
                    string = string.substring(0, string.length() - ".jws".length());
                }
                if (string == null || string.equals("")) {
                    string = this.clsName;
                }
                this.setServicePortName(string);
            }
            this.encodingList = new ArrayList();
            this.encodingList.add("http://schemas.xmlsoap.org/soap/encoding/");
            if (this.defaultTM == null || this.defaultTM instanceof DefaultTypeMappingImpl) {
                this.defaultTM = DefaultSOAP12TypeMappingImpl.create();
            }
            if (this.intfNS == null) {
                this.intfNS = Namespaces.makeNamespace(this.cls.getName());
            }
            if (this.implNS == null) {
                this.implNS = this.intfNS + "-impl";
            }
            this.namespaces.put(this.cls.getName(), this.intfNS, "intf");
            this.namespaces.putPrefix(this.implNS, "impl");
        }
    }

    private void writeDefinitions(Definition definition, String string) throws Exception {
        definition.setTargetNamespace(string);
        definition.addNamespace("intf", this.intfNS);
        definition.addNamespace("impl", this.implNS);
        definition.addNamespace("wsdlsoap", "http://schemas.xmlsoap.org/wsdl/soap/");
        this.namespaces.putPrefix("http://schemas.xmlsoap.org/wsdl/soap/", "wsdlsoap");
        definition.addNamespace("wsdl", "http://schemas.xmlsoap.org/wsdl/");
        this.namespaces.putPrefix("http://schemas.xmlsoap.org/wsdl/", "wsdl");
        definition.addNamespace("SOAP-ENC", "http://schemas.xmlsoap.org/soap/encoding/");
        this.namespaces.putPrefix("http://schemas.xmlsoap.org/soap/encoding/", "SOAP-ENC");
        definition.addNamespace("xsd", "http://www.w3.org/2001/XMLSchema");
        this.namespaces.putPrefix("http://www.w3.org/2001/XMLSchema", "xsd");
    }

    private void writeImport(Definition definition, String string, String string2) throws Exception {
        Import import_ = definition.createImport();
        import_.setNamespaceURI(string);
        if (string2 != null && !string2.equals("")) {
            import_.setLocationURI(string2);
        }
        definition.addImport(import_);
    }

    private Binding writeBinding(Definition definition, boolean bl) throws Exception {
        Binding binding = definition.createBinding();
        binding.setUndefined(false);
        binding.setQName(new QName(this.intfNS, this.getServicePortName() + "SoapBinding"));
        SOAPBindingImpl sOAPBindingImpl = new SOAPBindingImpl();
        String string = this.mode == 0 ? "rpc" : "document";
        sOAPBindingImpl.setStyle(string);
        sOAPBindingImpl.setTransportURI("http://schemas.xmlsoap.org/soap/http");
        binding.addExtensibilityElement((ExtensibilityElement)sOAPBindingImpl);
        if (bl) {
            definition.addBinding(binding);
        }
        return binding;
    }

    private void writeService(Definition definition, Binding binding) {
        Service service = definition.createService();
        service.setQName(new QName(this.implNS, this.getServiceElementName()));
        definition.addService(service);
        Port port = definition.createPort();
        port.setBinding(binding);
        port.setName(this.getServicePortName());
        SOAPAddressImpl sOAPAddressImpl = new SOAPAddressImpl();
        sOAPAddressImpl.setLocationURI(this.locationUrl);
        port.addExtensibilityElement((ExtensibilityElement)sOAPAddressImpl);
        service.addPort(port);
    }

    private void writePortType(Definition definition, Binding binding) throws Exception {
        PortType portType = definition.createPortType();
        portType.setUndefined(false);
        portType.setQName(new QName(this.intfNS, this.getPortTypeName()));
        BuilderPortTypeClassRep builderPortTypeClassRep = this.factory.getBuilderPortTypeClassRep();
        ClassRep classRep = builderPortTypeClassRep.build(this.cls, this.useInheritedMethods, this.stopClasses, this.implCls);
        Vector vector = builderPortTypeClassRep.getResolvedMethods(classRep, this.allowedMethods, this.disallowedMethods);
        int n = 0;
        while (n < vector.size()) {
            MethodRep methodRep = (MethodRep)vector.elementAt(n);
            Operation operation = this.writeOperation(definition, binding, methodRep);
            this.writeMessages(definition, operation, methodRep);
            portType.addOperation(operation);
            ++n;
        }
        definition.addPortType(portType);
        binding.setPortType(portType);
    }

    private void writeMessages(Definition definition, Operation operation, MethodRep methodRep) throws Exception {
        Fault fault;
        Input input = definition.createInput();
        Message message = this.writeRequestMessage(definition, methodRep);
        input.setMessage(message);
        operation.setInput(input);
        definition.addMessage(message);
        message = this.writeResponseMessage(definition, methodRep);
        Output output = definition.createOutput();
        output.setMessage(message);
        operation.setOutput(output);
        definition.addMessage(message);
        Vector vector = methodRep.getExceptions();
        int n = 0;
        while (n < vector.size()) {
            message = this.writeFaultMessage(definition, (ExceptionRep)vector.elementAt(n));
            fault = definition.createFault();
            fault.setMessage(message);
            fault.setName(((ExceptionRep)vector.elementAt(n)).getName());
            operation.addFault(fault);
            if (definition.getMessage(message.getQName()) == null) {
                definition.addMessage(message);
            }
            ++n;
        }
        fault = new Vector();
        int n2 = 0;
        while (n2 < methodRep.getParameters().size()) {
            ParamRep paramRep = (ParamRep)methodRep.getParameters().elementAt(n2);
            if (n2 != 0 || !(class$org$apache$axis$MessageContext == null ? Emitter.class$("org.apache.axis.MessageContext") : class$org$apache$axis$MessageContext).equals(paramRep.getType())) {
                fault.add(paramRep.getName());
            }
            ++n2;
        }
        if (fault.size() > 0) {
            operation.setParameterOrdering((List)fault);
        }
    }

    private Operation writeOperation(Definition definition, Binding binding, MethodRep methodRep) {
        Operation operation = definition.createOperation();
        operation.setName(methodRep.getName());
        operation.setUndefined(false);
        this.writeBindingOperation(definition, binding, operation, methodRep);
        return operation;
    }

    private void writeBindingOperation(Definition definition, Binding binding, Operation operation, MethodRep methodRep) {
        BindingOperation bindingOperation = definition.createBindingOperation();
        BindingInput bindingInput = definition.createBindingInput();
        BindingOutput bindingOutput = definition.createBindingOutput();
        bindingOperation.setName(operation.getName());
        SOAPOperationImpl sOAPOperationImpl = new SOAPOperationImpl();
        String string = methodRep.getMetaData("soapAction");
        if (string == null) {
            string = "";
        }
        sOAPOperationImpl.setSoapActionURI(string);
        bindingOperation.addExtensibilityElement((ExtensibilityElement)sOAPOperationImpl);
        SOAPBodyImpl sOAPBodyImpl = new SOAPBodyImpl();
        if (this.mode == 0) {
            sOAPBodyImpl.setUse("encoded");
            sOAPBodyImpl.setEncodingStyles((List)this.encodingList);
        } else {
            sOAPBodyImpl.setUse("literal");
        }
        if (this.targetService == null) {
            sOAPBodyImpl.setNamespaceURI(this.intfNS);
        } else {
            sOAPBodyImpl.setNamespaceURI(this.targetService);
        }
        String string2 = methodRep.getMetaData("inputNamespace");
        if (string2 != null) {
            sOAPBodyImpl.setNamespaceURI(string2);
        }
        sOAPBodyImpl.setEncodingStyles((List)this.encodingList);
        bindingInput.addExtensibilityElement((ExtensibilityElement)sOAPBodyImpl);
        SOAPBodyImpl sOAPBodyImpl2 = new SOAPBodyImpl();
        if (this.mode == 0) {
            sOAPBodyImpl2.setUse("encoded");
            sOAPBodyImpl2.setEncodingStyles((List)this.encodingList);
        } else {
            sOAPBodyImpl2.setUse("literal");
        }
        if (this.targetService == null) {
            sOAPBodyImpl2.setNamespaceURI(this.intfNS);
        } else {
            sOAPBodyImpl2.setNamespaceURI(this.targetService);
        }
        string2 = methodRep.getMetaData("outputNamespace");
        if (string2 != null) {
            sOAPBodyImpl2.setNamespaceURI(string2);
        }
        bindingOutput.addExtensibilityElement((ExtensibilityElement)sOAPBodyImpl2);
        bindingOperation.setBindingInput(bindingInput);
        bindingOperation.setBindingOutput(bindingOutput);
        binding.addBindingOperation(bindingOperation);
    }

    private Message writeRequestMessage(Definition definition, MethodRep methodRep) throws Exception {
        Message message = definition.createMessage();
        QName qName = this.createMessageName(definition, methodRep.getName(), "Request");
        message.setQName(qName);
        message.setUndefined(false);
        Vector vector = methodRep.getParameters();
        int n = 0;
        while (n < vector.size()) {
            ParamRep paramRep = (ParamRep)vector.elementAt(n);
            if (n != 0 || !(class$org$apache$axis$MessageContext == null ? Emitter.class$("org.apache.axis.MessageContext") : class$org$apache$axis$MessageContext).equals(paramRep.getType())) {
                this.writePartToMessage(definition, message, true, paramRep);
            }
            ++n;
        }
        return message;
    }

    private Message writeResponseMessage(Definition definition, MethodRep methodRep) throws Exception {
        Message message = definition.createMessage();
        QName qName = this.createMessageName(definition, methodRep.getName(), "Response");
        message.setQName(qName);
        message.setUndefined(false);
        ParamRep paramRep = methodRep.getReturns();
        this.writePartToMessage(definition, message, false, paramRep);
        Vector vector = methodRep.getParameters();
        int n = 0;
        while (n < vector.size()) {
            ParamRep paramRep2 = (ParamRep)vector.elementAt(n);
            if (n != 0 || !(class$org$apache$axis$MessageContext == null ? Emitter.class$("org.apache.axis.MessageContext") : class$org$apache$axis$MessageContext).equals(paramRep2.getType())) {
                this.writePartToMessage(definition, message, false, paramRep2);
            }
            ++n;
        }
        return message;
    }

    private Message writeFaultMessage(Definition definition, ExceptionRep exceptionRep) throws Exception {
        String string = exceptionRep.getName();
        String string2 = string.substring(string.lastIndexOf(46) + 1, string.length());
        exceptionRep.setName(string2);
        Message message = (Message)this.exceptionMsg.get(string);
        if (message == null) {
            message = definition.createMessage();
            QName qName = this.createMessageName(definition, string2, "");
            message.setQName(qName);
            message.setUndefined(false);
            Vector vector = exceptionRep.getParameters();
            int n = 0;
            while (n < vector.size()) {
                ParamRep paramRep = (ParamRep)vector.elementAt(n);
                if (n != 0 || !(class$org$apache$axis$MessageContext == null ? Emitter.class$("org.apache.axis.MessageContext") : class$org$apache$axis$MessageContext).equals(paramRep.getType())) {
                    this.writePartToMessage(definition, message, true, paramRep);
                }
                ++n;
            }
            this.exceptionMsg.put(string, message);
        }
        return message;
    }

    public String writePartToMessage(Definition definition, Message message, boolean bl, ParamRep paramRep) throws Exception {
        if (paramRep == null || paramRep.getType() == Void.TYPE) {
            return null;
        }
        if (bl && paramRep.getMode() == ParamRep.OUT) {
            return null;
        }
        if (!bl && paramRep.getMode() == ParamRep.IN) {
            return null;
        }
        Part part = definition.createPart();
        QName qName = this.types.writePartType(paramRep.getType());
        if (qName != null) {
            part.setTypeName(qName);
            part.setName(paramRep.getName());
        }
        message.addPart(part);
        return paramRep.getName();
    }

    private QName createMessageName(Definition definition, String string, String string2) {
        QName qName = new QName(this.intfNS, string.concat(string2));
        int n = 1;
        while (definition.getMessage(qName) != null) {
            StringBuffer stringBuffer = new StringBuffer(string.concat(string2));
            stringBuffer.append(n);
            qName = new QName(this.intfNS, stringBuffer.toString());
            ++n;
        }
        return qName;
    }

    private void prettyDocumentToFile(Document document, String string) throws Exception {
        FileOutputStream fileOutputStream = new FileOutputStream(new File(string));
        XMLUtils.PrettyDocumentToStream(document, fileOutputStream);
        fileOutputStream.close();
    }

    public Class getCls() {
        return this.cls;
    }

    public void setCls(Class clazz) {
        this.cls = clazz;
    }

    public void setClsSmart(Class clazz, String string) {
        if (clazz == null || string == null) {
            return;
        }
        if (string.lastIndexOf(47) > 0) {
            string = string.substring(string.lastIndexOf(47) + 1);
        } else if (string.lastIndexOf(92) > 0) {
            string = string.substring(string.lastIndexOf(92) + 1);
        }
        Constructor<?>[] constructorArray = clazz.getDeclaredConstructors();
        Class<?> clazz2 = null;
        int n = 0;
        while (n < constructorArray.length && clazz2 == null) {
            Class<?>[] classArray = constructorArray[n].getParameterTypes();
            if (classArray.length == 1 && classArray[0].isInterface() && classArray[0].getName() != null && Types.getLocalNameFromFullName(classArray[0].getName()).equals(string)) {
                clazz2 = classArray[0];
            }
            ++n;
        }
        if (clazz2 != null) {
            this.setCls(clazz2);
            if (this.implCls == null) {
                this.setImplCls(clazz);
            }
        } else {
            this.setCls(clazz);
        }
    }

    public void setCls(String string) {
        try {
            this.cls = Class.forName(string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public Class getImplCls() {
        return this.implCls;
    }

    public void setImplCls(Class clazz) {
        this.implCls = clazz;
    }

    public void setImplCls(String string) {
        try {
            this.implCls = Class.forName(string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void setFactory(String string) {
        try {
            this.factory = (Java2WSDLFactory)Class.forName(string).newInstance();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void setFactory(Java2WSDLFactory java2WSDLFactory) {
        this.factory = java2WSDLFactory;
    }

    public Java2WSDLFactory getFactory() {
        return this.factory;
    }

    public String getIntfNamespace() {
        return this.intfNS;
    }

    public void setIntfNamespace(String string) {
        this.intfNS = string;
    }

    public String getImplNamespace() {
        return this.implNS;
    }

    public void setImplNamespace(String string) {
        this.implNS = string;
    }

    public Vector getAllowedMethods() {
        return this.allowedMethods;
    }

    public void setAllowedMethods(String string) {
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, " ,+");
            this.allowedMethods = new Vector();
            while (stringTokenizer.hasMoreTokens()) {
                this.allowedMethods.add(stringTokenizer.nextToken());
            }
        }
    }

    public void setAllowedMethods(Vector vector) {
        this.allowedMethods = vector;
    }

    public boolean getUseInheritedMethods() {
        return this.useInheritedMethods;
    }

    public void setUseInheritedMethods(boolean bl) {
        this.useInheritedMethods = bl;
    }

    public void setDisallowedMethods(Vector vector) {
        this.disallowedMethods = vector;
    }

    public void setDisallowedMethods(String string) {
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, " ,+");
            this.disallowedMethods = new Vector();
            while (stringTokenizer.hasMoreTokens()) {
                this.disallowedMethods.add(stringTokenizer.nextToken());
            }
        }
    }

    public Vector getDisallowedMethods() {
        return this.disallowedMethods;
    }

    public void setStopClasses(Vector vector) {
        this.stopClasses = vector;
    }

    public void setStopClasses(String string) {
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, " ,+");
            this.stopClasses = new Vector();
            while (stringTokenizer.hasMoreTokens()) {
                this.stopClasses.add(stringTokenizer.nextToken());
            }
        }
    }

    public Vector getStopClasses() {
        return this.stopClasses;
    }

    public Map getNamespaceMap() {
        return this.namespaces;
    }

    public void setNamespaceMap(Map map) {
        if (map != null) {
            this.namespaces.putAll(map);
        }
    }

    public String getLocationUrl() {
        return this.locationUrl;
    }

    public void setLocationUrl(String string) {
        this.locationUrl = string;
    }

    public String getImportUrl() {
        return this.importUrl;
    }

    public void setImportUrl(String string) {
        this.importUrl = string;
    }

    public String getServicePortName() {
        return this.servicePortName;
    }

    public void setServicePortName(String string) {
        this.servicePortName = string;
    }

    public String getServiceElementName() {
        return this.serviceElementName;
    }

    public void setServiceElementName(String string) {
        this.serviceElementName = string;
    }

    public String getPortTypeName() {
        return this.portTypeName;
    }

    public void setPortTypeName(String string) {
        this.portTypeName = string;
    }

    public String getTargetService() {
        return this.targetService;
    }

    public void setTargetService(String string) {
        this.targetService = string;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public TypeMapping getTypeMapping() {
        return this.tm;
    }

    public void setTypeMapping(TypeMapping typeMapping) {
        this.tm = typeMapping;
    }

    public TypeMapping getDefaultTypeMapping() {
        return this.defaultTM;
    }

    public void setDefaultTypeMapping(TypeMapping typeMapping) {
        this.defaultTM = typeMapping;
    }

    public int getMode() {
        return this.mode;
    }

    public void setMode(int n) {
        this.mode = n;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

