/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.utils;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Hashtable;
import java.util.Stack;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.rpc.namespace.QName;
import org.apache.axis.Constants;
import org.apache.axis.utils.DOM2Writer;
import org.apache.axis.utils.JavaUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XMLUtils {
    protected static Log log = LogFactory.getLog((String)(class$org$apache$axis$utils$XMLUtils == null ? (class$org$apache$axis$utils$XMLUtils = XMLUtils.class$("org.apache.axis.utils.XMLUtils")) : class$org$apache$axis$utils$XMLUtils).getName());
    private static DocumentBuilderFactory dbf = XMLUtils.initDOMFactory();
    private static SAXParserFactory saxFactory;
    private static Stack saxParsers;
    static /* synthetic */ Class class$org$apache$axis$utils$XMLUtils;
    static /* synthetic */ Class class$org$apache$axis$utils$XMLUtils$ParserErrorHandler;

    public static String xmlEncodeString(String string) {
        if (string == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        char[] cArray = string.toCharArray();
        int n = 0;
        while (n < cArray.length) {
            switch (cArray[n]) {
                case '&': {
                    stringBuffer.append("&amp;");
                    break;
                }
                case '\"': {
                    stringBuffer.append("&quot;");
                    break;
                }
                case '\'': {
                    stringBuffer.append("&apos;");
                    break;
                }
                case '<': {
                    stringBuffer.append("&lt;");
                    break;
                }
                case '\r': {
                    stringBuffer.append("&#xd;");
                    break;
                }
                case '>': {
                    stringBuffer.append("&gt;");
                    break;
                }
                default: {
                    if (cArray[n] > '\u007f') {
                        stringBuffer.append("&#");
                        stringBuffer.append((int)cArray[n]);
                        stringBuffer.append(";");
                        break;
                    }
                    stringBuffer.append(cArray[n]);
                }
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public static void initSAXFactory(String string, boolean bl, boolean bl2) {
        if (string != null) {
            System.setProperty("javax.xml.parsers.SAXParserFactory", string);
        }
        saxFactory = SAXParserFactory.newInstance();
        saxFactory.setNamespaceAware(bl);
        saxFactory.setValidating(bl2);
    }

    public static DocumentBuilderFactory initDOMFactory() {
        try {
            dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
        }
        catch (Exception exception) {
            log.error((Object)JavaUtils.getMessage("exception00"), (Throwable)exception);
        }
        return dbf;
    }

    public static synchronized SAXParser getSAXParser() {
        try {
            if (saxParsers.empty()) {
                return saxFactory.newSAXParser();
            }
            return (SAXParser)saxParsers.pop();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            log.error((Object)JavaUtils.getMessage("parserConfigurationException00"), (Throwable)parserConfigurationException);
            return null;
        }
        catch (SAXException sAXException) {
            log.error((Object)JavaUtils.getMessage("SAXException00"), (Throwable)sAXException);
            return null;
        }
    }

    public static synchronized SAXParser releaseSAXParser(SAXParser sAXParser) {
        return saxParsers.push(sAXParser);
    }

    public static Document newDocument() {
        try {
            return dbf.newDocumentBuilder().newDocument();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static Document newDocument(InputSource inputSource) {
        try {
            DocumentBuilder documentBuilder = dbf.newDocumentBuilder();
            documentBuilder.setErrorHandler(new ParserErrorHandler());
            return documentBuilder.parse(inputSource);
        }
        catch (Exception exception) {
            log.error((Object)JavaUtils.getMessage("exception00"), (Throwable)exception);
            return null;
        }
    }

    public static Document newDocument(InputStream inputStream) {
        return XMLUtils.newDocument(new InputSource(inputStream));
    }

    public static Document newDocument(String string) {
        return XMLUtils.newDocument(new InputSource(string));
    }

    private static String privateElementToString(Element element, boolean bl) {
        return DOM2Writer.nodeToString(element, bl);
    }

    public static String ElementToString(Element element) {
        return XMLUtils.privateElementToString(element, true);
    }

    public static String DocumentToString(Document document) {
        return XMLUtils.privateElementToString(document.getDocumentElement(), false);
    }

    public static void privateElementToWriter(Element element, Writer writer, boolean bl, boolean bl2) {
        DOM2Writer.serializeAsXML(element, writer, bl, bl2);
    }

    public static void ElementToStream(Element element, OutputStream outputStream) {
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream);
        XMLUtils.privateElementToWriter(element, outputStreamWriter, true, false);
    }

    public static void PrettyElementToStream(Element element, OutputStream outputStream) {
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream);
        XMLUtils.privateElementToWriter(element, outputStreamWriter, true, true);
    }

    public static void ElementToWriter(Element element, Writer writer) {
        XMLUtils.privateElementToWriter(element, writer, true, false);
    }

    public static void PrettyElementToWriter(Element element, Writer writer) {
        XMLUtils.privateElementToWriter(element, writer, true, true);
    }

    public static void DocumentToStream(Document document, OutputStream outputStream) {
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream);
        XMLUtils.privateElementToWriter(document.getDocumentElement(), outputStreamWriter, false, false);
    }

    public static void PrettyDocumentToStream(Document document, OutputStream outputStream) {
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream);
        XMLUtils.privateElementToWriter(document.getDocumentElement(), outputStreamWriter, false, true);
    }

    public static void DocumentToWriter(Document document, Writer writer) {
        XMLUtils.privateElementToWriter(document.getDocumentElement(), writer, false, false);
    }

    public static void PrettyDocumentToWriter(Document document, Writer writer) {
        XMLUtils.privateElementToWriter(document.getDocumentElement(), writer, false, true);
    }

    public static Element StringToElement(String string, String string2, String string3) {
        Document document = XMLUtils.newDocument();
        Element element = document.createElementNS(string, string2);
        Text text = document.createTextNode(string3);
        element.appendChild(text);
        return element;
    }

    public static String getInnerXMLString(Element element) {
        String string = XMLUtils.ElementToString(element);
        int n = string.indexOf(">") + 1;
        int n2 = string.lastIndexOf("</");
        if (n2 > 0) {
            return string.substring(n, n2);
        }
        return null;
    }

    public static String getPrefix(String string, Node node) {
        while (node != null && node.getNodeType() == 1) {
            NamedNodeMap namedNodeMap = node.getAttributes();
            int n = 0;
            while (n < namedNodeMap.getLength()) {
                Attr attr = (Attr)namedNodeMap.item(n);
                String string2 = attr.getName();
                if (string2.startsWith("xmlns:") && attr.getNodeValue().equals(string)) {
                    return string2.substring(6);
                }
                ++n;
            }
            node = node.getParentNode();
        }
        return null;
    }

    public static String getNamespace(String string, Node node) {
        while (node != null && node.getNodeType() == 1) {
            Attr attr = ((Element)node).getAttributeNodeNS(Constants.NS_URI_XMLNS, string);
            if (attr != null) {
                return attr.getValue();
            }
            node = node.getParentNode();
        }
        return null;
    }

    public static QName getQNameFromString(String string, Node node) {
        if (string == null || node == null) {
            return null;
        }
        int n = string.indexOf(58);
        if (n > -1) {
            String string2 = string.substring(0, n);
            String string3 = XMLUtils.getNamespace(string2, node);
            if (string3 == null) {
                return null;
            }
            return new QName(string3, string.substring(n + 1));
        }
        return new QName("", string);
    }

    public String getStringForQName(QName qName, Element element) {
        String string = qName.getNamespaceURI();
        String string2 = XMLUtils.getPrefix(string, element);
        if (string2 == null) {
            int n = 1;
            string2 = "ns" + n;
            while (XMLUtils.getNamespace(string2, element) != null) {
                string2 = "ns" + ++n;
            }
            element.setAttributeNS(Constants.NS_URI_XMLNS, "xmlns:" + string2, string);
        }
        return string2 + ":" + qName.getLocalPart();
    }

    private static Hashtable getPrefixes(Document document) {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        NodeList nodeList = document.getElementsByTagName("*");
        int n = 0;
        while (n < nodeList.getLength()) {
            Element element = (Element)nodeList.item(n);
            NamedNodeMap namedNodeMap = element.getAttributes();
            int n2 = 0;
            while (n2 < namedNodeMap.getLength()) {
                Attr attr = (Attr)namedNodeMap.item(n2);
                String string = attr.getName();
                if (string.startsWith("xmlns:")) {
                    hashtable.put(string.substring(6), "");
                }
                ++n2;
            }
            ++n;
        }
        return hashtable;
    }

    public static String getNewPrefix(Document document, String string) {
        Hashtable hashtable = XMLUtils.getPrefixes(document);
        String string2 = null;
        int n = 0;
        while (string2 == null) {
            String string3 = "ns" + n;
            if (!hashtable.containsKey(string3)) {
                string2 = string3;
            }
            ++n;
        }
        document.getDocumentElement().setAttributeNS(Constants.NS_URI_XMLNS, "xmlns:" + string2, string);
        return string2;
    }

    public static String getChildCharacterData(Element element) {
        if (element == null) {
            return null;
        }
        Node node = element.getFirstChild();
        StringBuffer stringBuffer = new StringBuffer();
        while (node != null) {
            switch (node.getNodeType()) {
                case 3: 
                case 4: {
                    CharacterData characterData = (CharacterData)node;
                    stringBuffer.append(characterData.getData());
                }
            }
            node = node.getNextSibling();
        }
        return stringBuffer.toString();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        saxParsers = new Stack();
        XMLUtils.initSAXFactory(null, true, false);
    }

    public static class ParserErrorHandler
    implements ErrorHandler {
        protected static Log log = LogFactory.getLog((String)(class$org$apache$axis$utils$XMLUtils$ParserErrorHandler == null ? (class$org$apache$axis$utils$XMLUtils$ParserErrorHandler = XMLUtils.class$("org.apache.axis.utils.XMLUtils$ParserErrorHandler")) : class$org$apache$axis$utils$XMLUtils$ParserErrorHandler).getName());

        private String getParseExceptionInfo(SAXParseException sAXParseException) {
            String string = sAXParseException.getSystemId();
            if (string == null) {
                string = "null";
            }
            String string2 = "URI=" + string + " Line=" + sAXParseException.getLineNumber() + ": " + sAXParseException.getMessage();
            return string2;
        }

        public void warning(SAXParseException sAXParseException) throws SAXException {
            if (log.isDebugEnabled()) {
                log.debug((Object)JavaUtils.getMessage("warning00", this.getParseExceptionInfo(sAXParseException)));
            }
        }

        public void error(SAXParseException sAXParseException) throws SAXException {
            String string = "Error: " + this.getParseExceptionInfo(sAXParseException);
            throw new SAXException(string);
        }

        public void fatalError(SAXParseException sAXParseException) throws SAXException {
            String string = "Fatal Error: " + this.getParseExceptionInfo(sAXParseException);
            throw new SAXException(string);
        }
    }
}

