/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.utils;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.text.Collator;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.xml.rpc.holders.Holder;
import org.apache.axis.encoding.Hex;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JavaUtils {
    protected static Log log = LogFactory.getLog((String)(class$org$apache$axis$utils$JavaUtils == null ? (class$org$apache$axis$utils$JavaUtils = JavaUtils.class$("org.apache.axis.utils.JavaUtils")) : class$org$apache$axis$utils$JavaUtils).getName());
    static final String[] keywords = new String[]{"abstract", "boolean", "break", "byte", "case", "catch", "char", "class", "const", "continue", "default", "do", "double", "else", "extends", "false", "final", "finally", "float", "for", "goto", "if", "implements", "import", "instanceof", "int", "interface", "long", "native", "new", "package", "private", "protected", "public", "return", "short", "static", "strictfp", "super", "switch", "synchronized", "this", "throw", "throws", "transient", "true", "try", "void", "volatile", "while"};
    static final Collator englishCollator = Collator.getInstance(Locale.ENGLISH);
    static final char keywordPrefix = '_';
    private static ResourceBundle messages = null;
    static /* synthetic */ Class class$org$apache$axis$utils$JavaUtils;
    static /* synthetic */ Class array$B;
    static /* synthetic */ Class class$org$apache$axis$encoding$Hex;
    static /* synthetic */ Class class$java$util$List;
    static /* synthetic */ Class class$javax$xml$rpc$holders$Holder;
    static /* synthetic */ Class class$java$lang$String;

    public static Object convert(Object object, Class clazz) {
        Class clazz2;
        Object object2;
        if (clazz == null) {
            return object;
        }
        if (log.isDebugEnabled()) {
            object2 = "null";
            if (object != null) {
                object2 = object.getClass().getName();
            }
            log.debug((Object)JavaUtils.getMessage("convert00", (String)object2, clazz.getName()));
        }
        object2 = null;
        if (object instanceof ConvertCache && (object2 = ((ConvertCache)object).getConvertedValue(clazz)) != null) {
            return object2;
        }
        Class clazz3 = JavaUtils.getHolderValueType(clazz);
        Class clazz4 = null;
        if (object != null) {
            clazz4 = JavaUtils.getHolderValueType(object.getClass());
        }
        if (object instanceof Hex && clazz == (array$B == null ? (array$B = JavaUtils.class$("[B")) : array$B)) {
            return ((Hex)object).getBytes();
        }
        if (object instanceof byte[] && clazz == (class$org$apache$axis$encoding$Hex == null ? (class$org$apache$axis$encoding$Hex = JavaUtils.class$("org.apache.axis.encoding.Hex")) : class$org$apache$axis$encoding$Hex)) {
            return new Hex((byte[])object);
        }
        if (!(object instanceof List) && (object == null || !object.getClass().isArray()) && (clazz3 == null && clazz4 == null || clazz3 != null && clazz4 != null)) {
            return object;
        }
        if (clazz3 != null) {
            Object object3 = JavaUtils.convert(object, clazz3);
            Object var6_10 = null;
            try {
                var6_10 = clazz.newInstance();
                JavaUtils.setHolderValue(var6_10, object3);
                return var6_10;
            }
            catch (Exception exception) {
                return object;
            }
        }
        if (clazz4 != null) {
            try {
                Object object4 = JavaUtils.getHolderValue(object);
                return JavaUtils.convert(object4, clazz);
            }
            catch (HolderException holderException) {
                return object;
            }
        }
        if (object instanceof ConvertCache && ((ConvertCache)object).getDestClass() != clazz && (clazz2 = ((ConvertCache)object).getDestClass()) != null && clazz2.isArray() && clazz.isArray() && clazz.isAssignableFrom(clazz2) && (object2 = ((ConvertCache)object).getConvertedValue(clazz = clazz2)) != null) {
            return object2;
        }
        if (object == null) {
            return object;
        }
        int n = 0;
        n = object.getClass().isArray() ? Array.getLength(object) : ((List)object).size();
        if (clazz.isArray()) {
            if (clazz.getComponentType().isPrimitive()) {
                Object object5 = Array.newInstance(clazz.getComponentType(), n);
                if (object.getClass().isArray()) {
                    int n2 = 0;
                    while (n2 < n) {
                        Array.set(object5, n2, Array.get(object, n2));
                        ++n2;
                    }
                } else {
                    int n3 = 0;
                    while (n3 < n) {
                        Array.set(object5, n3, ((List)object).get(n3));
                        ++n3;
                    }
                }
                object2 = object5;
            } else {
                Object[] objectArray;
                try {
                    objectArray = (Object[])Array.newInstance(clazz.getComponentType(), n);
                }
                catch (Exception exception) {
                    return object;
                }
                if (object.getClass().isArray()) {
                    int n4 = 0;
                    while (n4 < n) {
                        objectArray[n4] = JavaUtils.convert(Array.get(object, n4), clazz.getComponentType());
                        ++n4;
                    }
                } else {
                    int n5 = 0;
                    while (n5 < n) {
                        objectArray[n5] = JavaUtils.convert(((List)object).get(n5), clazz.getComponentType());
                        ++n5;
                    }
                }
                object2 = objectArray;
            }
        } else if ((class$java$util$List == null ? (class$java$util$List = JavaUtils.class$("java.util.List")) : class$java$util$List).isAssignableFrom(clazz)) {
            List list = null;
            try {
                list = (List)clazz.newInstance();
            }
            catch (Exception exception) {
                return object;
            }
            if (object.getClass().isArray()) {
                int n6 = 0;
                while (n6 < n) {
                    list.add(Array.get(object, n6));
                    ++n6;
                }
            } else {
                int n7 = 0;
                while (n7 < n) {
                    list.add(((List)object).get(n7));
                    ++n7;
                }
            }
            object2 = list;
        } else {
            object2 = object;
        }
        if (object instanceof ConvertCache) {
            ((ConvertCache)object).setConvertedValue(clazz, object2);
        }
        return object2;
    }

    public static boolean isJavaId(String string) {
        if (string == null || string.equals("") || JavaUtils.isJavaKeyword(string)) {
            return false;
        }
        if (!Character.isJavaIdentifierStart(string.charAt(0))) {
            return false;
        }
        int n = 1;
        while (n < string.length()) {
            if (!Character.isJavaIdentifierPart(string.charAt(n))) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public static boolean isJavaKeyword(String string) {
        return Arrays.binarySearch(keywords, string, englishCollator) >= 0;
    }

    public static String makeNonJavaKeyword(String string) {
        return '_' + string;
    }

    public static String getLoadableClassName(String string) {
        if (string == null || string.indexOf("[") < 0 || string.charAt(0) == '[') {
            return string;
        }
        String string2 = string.substring(0, string.indexOf("["));
        string2 = string2.equals("byte") ? "B" : (string2.equals("char") ? "C" : (string2.equals("double") ? "D" : (string2.equals("float") ? "F" : (string2.equals("int") ? "I" : (string2.equals("long") ? "J" : (string2.equals("short") ? "S" : (string2.equals("boolean") ? "Z" : "L" + string2 + ";")))))));
        int n = string.indexOf("]");
        while (n > 0) {
            string2 = "[" + string2;
            n = string.indexOf("]", n + 1);
        }
        return string2;
    }

    public static String getTextClassName(String string) {
        if (string == null || string.indexOf("[") != 0) {
            return string;
        }
        String string2 = "";
        int n = 0;
        while (n < string.length() && string.charAt(n) == '[') {
            ++n;
            string2 = string2 + "[]";
        }
        if (n < string.length()) {
            string2 = string.charAt(n) == 'B' ? "byte" + string2 : (string.charAt(n) == 'C' ? "char" + string2 : (string.charAt(n) == 'D' ? "double" + string2 : (string.charAt(n) == 'F' ? "float" + string2 : (string.charAt(n) == 'I' ? "int" + string2 : (string.charAt(n) == 'J' ? "long" + string2 : (string.charAt(n) == 'S' ? "short" + string2 : (string.charAt(n) == 'Z' ? "boolean" + string2 : string.substring(n + 1, string.indexOf(";")) + string2)))))));
        }
        return string2;
    }

    public static String xmlNameToJava(String string) {
        if (string == null || string.equals("")) {
            return string;
        }
        char[] cArray = string.toCharArray();
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer(n);
        boolean bl = false;
        int n2 = 0;
        while (n2 < n && (JavaUtils.isPunctuation(cArray[n2]) || !Character.isJavaIdentifierStart(cArray[n2]))) {
            ++n2;
        }
        if (n2 < n) {
            if (Character.isUpperCase(cArray[n2])) {
                stringBuffer.append(Character.toLowerCase(cArray[n2]));
            } else {
                stringBuffer.append(cArray[n2]);
            }
            bl = !Character.isLetter(cArray[n2]);
        } else if (Character.isJavaIdentifierPart(cArray[0])) {
            stringBuffer.append("_" + cArray[0]);
        } else {
            stringBuffer.append("_" + cArray.length);
        }
        ++n2;
        while (n2 < n) {
            char c = cArray[n2];
            if (JavaUtils.isPunctuation(c) || !Character.isJavaIdentifierPart(c)) {
                bl = true;
            } else {
                if (bl && Character.isLowerCase(c)) {
                    stringBuffer.append(Character.toUpperCase(c));
                } else {
                    stringBuffer.append(c);
                }
                bl = !Character.isLetter(c);
            }
            ++n2;
        }
        String string2 = stringBuffer.toString();
        if (JavaUtils.isJavaKeyword(string2)) {
            string2 = JavaUtils.makeNonJavaKeyword(string2);
        }
        return string2;
    }

    private static boolean isPunctuation(char c) {
        return '-' == c || '.' == c || ':' == c || '_' == c || '\u00b7' == c || '\u0387' == c || '\u06dd' == c || '\u06de' == c;
    }

    public static ResourceBundle getMessageResourceBundle() {
        if (messages == null) {
            JavaUtils.initializeMessages();
        }
        return messages;
    }

    public static String getMessage(String string) throws MissingResourceException {
        if (messages == null) {
            JavaUtils.initializeMessages();
        }
        return messages.getString(string);
    }

    public static String getMessage(String string, String string2) throws MissingResourceException {
        Object[] objectArray = new String[]{string2};
        return MessageFormat.format(JavaUtils.getMessage(string), objectArray);
    }

    public static String getMessage(String string, String string2, String string3) throws MissingResourceException {
        Object[] objectArray = new String[]{string2, string3};
        return MessageFormat.format(JavaUtils.getMessage(string), objectArray);
    }

    public static String getMessage(String string, String[] stringArray) throws MissingResourceException {
        return MessageFormat.format(JavaUtils.getMessage(string), stringArray);
    }

    private static void initializeMessages() {
        messages = ResourceBundle.getBundle("org.apache.axis.utils.resources");
    }

    public static final String replace(String string, String string2, String string3) {
        if (string == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer(string.length() * 2);
        int n = string2.length();
        try {
            int n2 = 0;
            int n3 = string.indexOf(string2, n2);
            while (n3 >= 0) {
                stringBuffer.append(string.substring(n2, n3));
                stringBuffer.append(string3);
                n2 = n3 + n;
                n3 = string.indexOf(string2, n2);
            }
            if (n2 < string.length()) {
                stringBuffer.append(string.substring(n2));
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return new String(stringBuffer);
    }

    public static Class getHolderValueType(Class clazz) {
        if (clazz != null) {
            Field field;
            Class<?>[] classArray = clazz.getInterfaces();
            boolean bl = false;
            int n = 0;
            while (n < classArray.length) {
                if (classArray[n] == (class$javax$xml$rpc$holders$Holder == null ? JavaUtils.class$("javax.xml.rpc.holders.Holder") : class$javax$xml$rpc$holders$Holder)) {
                    bl = true;
                }
                ++n;
            }
            if (!bl) {
                return null;
            }
            try {
                field = clazz.getField("value");
            }
            catch (Exception exception) {
                field = null;
            }
            if (field != null) {
                return field.getType();
            }
        }
        return null;
    }

    public static Object getHolderValue(Object object) throws HolderException {
        if (!(object instanceof Holder)) {
            throw new HolderException();
        }
        try {
            Field field = object.getClass().getField("value");
            return field.get(object);
        }
        catch (Exception exception) {
            throw new HolderException();
        }
    }

    public static void setHolderValue(Object object, Object object2) throws HolderException {
        if (!(object instanceof Holder)) {
            throw new HolderException();
        }
        try {
            Field field = object.getClass().getField("value");
            if (field.getType().isPrimitive()) {
                if (object2 != null) {
                    field.set(object, object2);
                }
            } else {
                field.set(object, object2);
            }
        }
        catch (Exception exception) {
            throw new HolderException();
        }
    }

    public static boolean isEnumClass(Class clazz) {
        try {
            Method method = clazz.getMethod("getValue", null);
            Method method2 = clazz.getMethod("toString", null);
            Method method3 = clazz.getMethod("fromString", class$java$lang$String == null ? (class$java$lang$String = JavaUtils.class$("java.lang.String")) : class$java$lang$String);
            if (method != null && method2 != null && method3 != null && clazz.getMethod("fromValue", method.getReturnType()) != null) {
                try {
                    return clazz.getMethod("setValue", method.getReturnType()) == null;
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    return true;
                }
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        return false;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static class HolderException
    extends Exception {
    }

    public static interface ConvertCache {
        public void setConvertedValue(Class var1, Object var2);

        public Object getConvertedValue(Class var1);

        public Class getDestClass();
    }
}

