/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.utils;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import org.apache.axis.utils.NSStack;
import org.apache.axis.utils.XMLUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class DOM2Writer {
    private static String NS_URI_XMLNS = "http://www.w3.org/2000/xmlns/";
    private static final String lineSeparator = System.getProperty("line.separator", "\n");

    public static String nodeToString(Node node, boolean bl) {
        StringWriter stringWriter = new StringWriter();
        DOM2Writer.serializeAsXML(node, stringWriter, bl);
        return stringWriter.toString();
    }

    public static void serializeAsXML(Node node, Writer writer, boolean bl) {
        PrintWriter printWriter = new PrintWriter(writer);
        if (!bl) {
            printWriter.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        }
        DOM2Writer.print(node, null, printWriter, false, 0);
        printWriter.flush();
    }

    public static void serializeAsXML(Node node, Writer writer, boolean bl, boolean bl2) {
        PrintWriter printWriter = new PrintWriter(writer);
        if (!bl) {
            printWriter.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        }
        DOM2Writer.print(node, null, printWriter, bl2, 0);
        printWriter.flush();
    }

    private static void print(Node node, NSStack nSStack, PrintWriter printWriter, boolean bl, int n) {
        if (node == null) {
            return;
        }
        boolean bl2 = false;
        short s = node.getNodeType();
        switch (s) {
            case 9: {
                Object object2 = node.getChildNodes();
                if (object2 == null) break;
                int n2 = object2.getLength();
                int n3 = 0;
                while (n3 < n2) {
                    DOM2Writer.print(object2.item(n3), nSStack, printWriter, bl, n);
                    ++n3;
                }
                break;
            }
            case 1: {
                Object object;
                NamedNodeMap namedNodeMap;
                nSStack = new NSStack(nSStack);
                if (bl) {
                    int n4 = 0;
                    while (n4 < n) {
                        printWriter.print(' ');
                        ++n4;
                    }
                }
                printWriter.print('<' + node.getNodeName());
                Object object2 = node.getPrefix();
                String string = node.getNamespaceURI();
                if (object2 != null && string != null) {
                    boolean bl3 = false;
                    try {
                        String string2 = nSStack.getNamespaceURI((String)object2);
                        if (string.equals(string2)) {
                            bl3 = true;
                        }
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                    if (!bl3) {
                        DOM2Writer.printNamespaceDecl(node, nSStack, printWriter);
                    }
                }
                int n5 = (namedNodeMap = node.getAttributes()) != null ? namedNodeMap.getLength() : 0;
                int n6 = 0;
                while (n6 < n5) {
                    object = (Attr)namedNodeMap.item(n6);
                    printWriter.print(' ' + object.getNodeName() + "=\"" + DOM2Writer.normalize(object.getValue()) + '\"');
                    String string3 = object.getPrefix();
                    String string4 = object.getNamespaceURI();
                    if (string3 != null && string4 != null) {
                        boolean bl4 = false;
                        try {
                            String string5 = nSStack.getNamespaceURI(string3);
                            if (string4.equals(string5)) {
                                bl4 = true;
                            }
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            // empty catch block
                        }
                        if (!bl4) {
                            DOM2Writer.printNamespaceDecl((Node)object, nSStack, printWriter);
                        }
                    }
                    ++n6;
                }
                object = node.getChildNodes();
                if (object != null) {
                    int n7 = object.getLength();
                    boolean bl5 = bl2 = n7 > 0;
                    if (bl2) {
                        printWriter.print('>');
                        if (bl) {
                            printWriter.print(lineSeparator);
                        }
                    }
                    int n8 = 0;
                    while (n8 < n7) {
                        DOM2Writer.print(object.item(n8), nSStack, printWriter, bl, n + 1);
                        ++n8;
                    }
                } else {
                    bl2 = false;
                }
                if (bl2) break;
                printWriter.print("/>");
                if (!bl) break;
                printWriter.print(lineSeparator);
                break;
            }
            case 5: {
                printWriter.print('&');
                printWriter.print(node.getNodeName());
                printWriter.print(';');
                break;
            }
            case 4: {
                printWriter.print("<![CDATA[");
                printWriter.print(node.getNodeValue());
                printWriter.print("]]>");
                break;
            }
            case 3: {
                printWriter.print(DOM2Writer.normalize(node.getNodeValue()));
                break;
            }
            case 8: {
                printWriter.print("<!--");
                printWriter.print(node.getNodeValue());
                printWriter.print("-->");
                if (!bl) break;
                printWriter.print(lineSeparator);
                break;
            }
            case 7: {
                printWriter.print("<?");
                printWriter.print(node.getNodeName());
                Object object2 = node.getNodeValue();
                if (object2 != null && ((String)object2).length() > 0) {
                    printWriter.print(' ');
                    printWriter.print((String)object2);
                }
                printWriter.println("?>");
                if (!bl) break;
                printWriter.print(lineSeparator);
            }
        }
        if (s == 1 && bl2) {
            if (bl) {
                int n9 = 0;
                while (n9 < n) {
                    printWriter.print(' ');
                    ++n9;
                }
            }
            printWriter.print("</");
            printWriter.print(node.getNodeName());
            printWriter.print('>');
            if (bl) {
                printWriter.print(lineSeparator);
            }
            bl2 = false;
        }
    }

    private static void printNamespaceDecl(Node node, NSStack nSStack, PrintWriter printWriter) {
        switch (node.getNodeType()) {
            case 2: {
                DOM2Writer.printNamespaceDecl(((Attr)node).getOwnerElement(), node, nSStack, printWriter);
                break;
            }
            case 1: {
                DOM2Writer.printNamespaceDecl((Element)node, node, nSStack, printWriter);
            }
        }
    }

    private static void printNamespaceDecl(Element element, Node node, NSStack nSStack, PrintWriter printWriter) {
        String string = node.getNamespaceURI();
        String string2 = node.getPrefix();
        if (!string.equals(NS_URI_XMLNS) || !string2.equals("xmlns")) {
            if (XMLUtils.getNamespace(string2, element) == null) {
                printWriter.print(" xmlns:" + string2 + "=\"" + string + '\"');
            }
        } else {
            string2 = node.getLocalName();
            string = node.getNodeValue();
        }
        nSStack.add(string, string2);
    }

    public static String normalize(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = string != null ? string.length() : 0;
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            switch (c) {
                case '<': {
                    stringBuffer.append("&lt;");
                    break;
                }
                case '>': {
                    stringBuffer.append("&gt;");
                    break;
                }
                case '&': {
                    stringBuffer.append("&amp;");
                    break;
                }
                case '\"': {
                    stringBuffer.append("&quot;");
                    break;
                }
                case '\n': {
                    if (n2 > 0) {
                        char c2 = stringBuffer.charAt(stringBuffer.length() - 1);
                        if (c2 != '\r') {
                            stringBuffer.append(lineSeparator);
                            break;
                        }
                        stringBuffer.append('\n');
                        break;
                    }
                    stringBuffer.append(lineSeparator);
                    break;
                }
                default: {
                    stringBuffer.append(c);
                }
            }
            ++n2;
        }
        return stringBuffer.toString();
    }
}

