/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.utils;

import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Hashtable;
import org.apache.axis.utils.cache.JavaClass;

public class AxisClassLoader
extends ClassLoader {
    static Hashtable classLoaders = new Hashtable();
    Hashtable classCache = new Hashtable();

    public AxisClassLoader() {
        super(Thread.currentThread().getContextClassLoader());
    }

    public static synchronized AxisClassLoader getClassLoader() {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        AxisClassLoader axisClassLoader = null;
        axisClassLoader = (AxisClassLoader)classLoaders.get(classLoader);
        if (axisClassLoader == null) {
            axisClassLoader = new AxisClassLoader();
            classLoaders.put(classLoader, axisClassLoader);
        }
        return axisClassLoader;
    }

    public static void removeClassLoader(String string) {
        if (string != null) {
            classLoaders.remove(string);
        }
    }

    public void registerClass(String string, String string2) throws FileNotFoundException, IOException {
        FileInputStream fileInputStream = new FileInputStream(string2);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray = new byte[1024];
        int n = 0;
        while ((n = fileInputStream.read(byArray)) != -1) {
            byteArrayOutputStream.write(byArray, 0, n);
        }
        fileInputStream.close();
        byteArrayOutputStream.close();
        byte[] byArray2 = byteArrayOutputStream.toByteArray();
        Class<?> clazz = this.defineClass(string, byArray2, 0, byArray2.length);
        this.registerClass(string, clazz);
    }

    public synchronized void registerClass(String string, Class clazz) {
        JavaClass javaClass = (JavaClass)this.classCache.get(string);
        if (javaClass != null && javaClass.getJavaClass() == clazz) {
            return;
        }
        this.classCache.put(string, new JavaClass(clazz));
    }

    public synchronized void deregisterClass(String string) {
        this.classCache.remove(string);
    }

    public boolean isClassRegistered(String string) {
        return this.classCache != null && this.classCache.get(string) != null;
    }

    public Class loadClass(String string) throws ClassNotFoundException {
        Object v;
        if (this.classCache != null && (v = this.classCache.get(string)) != null) {
            return ((JavaClass)v).getJavaClass();
        }
        Class<?> clazz = super.loadClass(string);
        this.registerClass(string, clazz);
        return clazz;
    }

    public JavaClass lookup(String string) throws ClassNotFoundException {
        JavaClass javaClass = (JavaClass)this.classCache.get(string);
        if (javaClass == null) {
            this.loadClass(string);
            javaClass = (JavaClass)this.classCache.get(string);
        }
        return javaClass;
    }
}

