/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.server;

import java.util.Map;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.servlet.ServletContext;
import org.apache.axis.AxisFault;
import org.apache.axis.EngineConfiguration;
import org.apache.axis.server.AxisServer;
import org.apache.axis.server.AxisServerFactory;

public class JNDIAxisServerFactory
implements AxisServerFactory {
    public AxisServer getServer(Map map) throws AxisFault {
        AxisServer axisServer = null;
        InitialContext initialContext = null;
        try {
            initialContext = new InitialContext();
        }
        catch (NamingException namingException) {
            // empty catch block
        }
        EngineConfiguration engineConfiguration = null;
        try {
            engineConfiguration = (EngineConfiguration)map.get("engineConfig");
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        if (initialContext != null) {
            ServletContext servletContext = (ServletContext)map.get("servletContext");
            if (servletContext != null) {
                String string = servletContext.getRealPath("/WEB-INF/Server");
                try {
                    axisServer = (AxisServer)initialContext.lookup(string);
                }
                catch (NamingException namingException) {
                    axisServer = JNDIAxisServerFactory.createNewServer(engineConfiguration);
                    try {
                        initialContext.bind(string, (Object)axisServer);
                    }
                    catch (NamingException namingException2) {}
                }
            } else {
                axisServer = JNDIAxisServerFactory.createNewServer(engineConfiguration);
            }
        }
        return axisServer;
    }

    private static AxisServer createNewServer(EngineConfiguration engineConfiguration) {
        if (engineConfiguration != null) {
            return new AxisServer(engineConfiguration);
        }
        String string = System.getProperty("axis.engineConfigClass");
        if (string != null) {
            try {
                Class<?> clazz = Class.forName(string);
                engineConfiguration = (EngineConfiguration)clazz.newInstance();
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (InstantiationException instantiationException) {
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        if (engineConfiguration == null) {
            return new AxisServer();
        }
        return new AxisServer(engineConfiguration);
    }
}

