/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.server;

import java.util.Map;
import org.apache.axis.AxisEngine;
import org.apache.axis.AxisFault;
import org.apache.axis.EngineConfiguration;
import org.apache.axis.Handler;
import org.apache.axis.Message;
import org.apache.axis.MessageContext;
import org.apache.axis.SimpleTargetedChain;
import org.apache.axis.client.AxisClient;
import org.apache.axis.configuration.DefaultEngineConfigurationFactory;
import org.apache.axis.server.AxisServerFactory;
import org.apache.axis.server.DefaultAxisServerFactory;
import org.apache.axis.utils.JavaUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AxisServer
extends AxisEngine {
    protected static Log log = LogFactory.getLog((String)(class$org$apache$axis$server$AxisServer == null ? (class$org$apache$axis$server$AxisServer = AxisServer.class$("org.apache.axis.server.AxisServer")) : class$org$apache$axis$server$AxisServer).getName());
    private static AxisServerFactory factory = null;
    private AxisEngine clientEngine;
    private boolean running = true;
    static /* synthetic */ Class class$org$apache$axis$server$AxisServer;
    static /* synthetic */ Class class$org$apache$axis$server$AxisServerFactory;

    public static AxisServer getServer(Map map) throws AxisFault {
        if (factory == null) {
            String string = System.getProperty("axis.ServerFactory");
            if (string != null) {
                try {
                    Class<?> clazz = Class.forName(string);
                    if ((class$org$apache$axis$server$AxisServerFactory == null ? (class$org$apache$axis$server$AxisServerFactory = AxisServer.class$("org.apache.axis.server.AxisServerFactory")) : class$org$apache$axis$server$AxisServerFactory).isAssignableFrom(clazz)) {
                        factory = (AxisServerFactory)clazz.newInstance();
                    }
                }
                catch (Exception exception) {
                    log.error((Object)JavaUtils.getMessage("exception00"), (Throwable)exception);
                }
            }
            if (factory == null) {
                factory = new DefaultAxisServerFactory();
            }
        }
        return factory.getServer(map);
    }

    public AxisServer() {
        this(new DefaultEngineConfigurationFactory().getServerEngineConfig());
    }

    public AxisServer(EngineConfiguration engineConfiguration) {
        super(engineConfiguration);
        this.shouldSaveConfig = true;
    }

    public boolean isRunning() {
        return this.running;
    }

    public void start() {
        this.init();
        this.running = true;
    }

    public void stop() {
        this.running = false;
    }

    public synchronized AxisEngine getClientEngine() {
        if (this.clientEngine == null) {
            this.clientEngine = new AxisClient();
        }
        return this.clientEngine;
    }

    public void invoke(MessageContext messageContext) throws AxisFault {
        if (log.isDebugEnabled()) {
            log.debug((Object)JavaUtils.getMessage("enter00", "AxisServer::invoke"));
        }
        if (!this.isRunning()) {
            throw new AxisFault("Server.disabled", JavaUtils.getMessage("serverDisabled00"), null, null);
        }
        String string = null;
        Handler handler = null;
        MessageContext messageContext2 = AxisEngine.getCurrentMessageContext();
        try {
            block20: {
                try {
                    AxisEngine.setCurrentMessageContext(messageContext);
                    string = messageContext.getStrProp(MessageContext.ENGINE_HANDLER);
                    if (string != null) {
                        handler = this.getHandler(string);
                        if (handler == null) {
                            ClassLoader classLoader = messageContext.getClassLoader();
                            try {
                                log.debug((Object)JavaUtils.getMessage("tryingLoad00", string));
                                Class<?> clazz = classLoader.loadClass(string);
                                handler = (Handler)clazz.newInstance();
                            }
                            catch (Exception exception) {
                                handler = null;
                            }
                        }
                        if (handler != null) {
                            handler.invoke(messageContext);
                            break block20;
                        }
                        throw new AxisFault("Server.error", JavaUtils.getMessage("noHandler00", string), null, null);
                    }
                    if (log.isDebugEnabled()) {
                        log.debug((Object)JavaUtils.getMessage("defaultLogic00"));
                    }
                    string = messageContext.getTransportName();
                    SimpleTargetedChain simpleTargetedChain = null;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)JavaUtils.getMessage("transport01", "AxisServer.invoke", string));
                    }
                    if (string != null && (handler = this.getTransport(string)) != null && handler instanceof SimpleTargetedChain && (handler = (simpleTargetedChain = (SimpleTargetedChain)handler).getRequestHandler()) != null) {
                        handler.invoke(messageContext);
                    }
                    if ((handler = this.getGlobalRequest()) != null) {
                        handler.invoke(messageContext);
                    }
                    if ((handler = messageContext.getService()) == null) {
                        Message message = messageContext.getRequestMessage();
                        message.getSOAPEnvelope().getFirstBody();
                        handler = messageContext.getService();
                        if (handler == null) {
                            throw new AxisFault("Server.NoService", JavaUtils.getMessage("noService05", "" + messageContext.getTargetService()), null, null);
                        }
                    }
                    handler.invoke(messageContext);
                    handler = this.getGlobalResponse();
                    if (handler != null) {
                        handler.invoke(messageContext);
                    }
                    if (simpleTargetedChain == null || (handler = simpleTargetedChain.getResponseHandler()) == null) break block20;
                    handler.invoke(messageContext);
                }
                catch (AxisFault axisFault) {
                    throw axisFault;
                }
                catch (Exception exception) {
                    throw AxisFault.makeFault(exception);
                }
            }
            Object var8_12 = null;
        }
        catch (Throwable throwable) {
            Object var8_13 = null;
            AxisEngine.setCurrentMessageContext(messageContext2);
            throw throwable;
        }
        AxisEngine.setCurrentMessageContext(messageContext2);
        if (log.isDebugEnabled()) {
            log.debug((Object)JavaUtils.getMessage("exit00", "AxisServer::invoke"));
        }
    }

    public void generateWSDL(MessageContext messageContext) throws AxisFault {
        block18: {
            if (log.isDebugEnabled()) {
                log.debug((Object)JavaUtils.getMessage("enter00", "AxisServer::generateWSDL"));
            }
            if (!this.isRunning()) {
                throw new AxisFault("Server.disabled", JavaUtils.getMessage("serverDisabled00"), null, null);
            }
            String string = null;
            Handler handler = null;
            try {
                string = messageContext.getStrProp(MessageContext.ENGINE_HANDLER);
                if (string != null) {
                    handler = this.getHandler(string);
                    if (handler == null) {
                        ClassLoader classLoader = messageContext.getClassLoader();
                        try {
                            log.debug((Object)JavaUtils.getMessage("tryingLoad00", string));
                            Class<?> clazz = classLoader.loadClass(string);
                            handler = (Handler)clazz.newInstance();
                        }
                        catch (Exception exception) {
                            throw new AxisFault("Server.error", JavaUtils.getMessage("noHandler00", string), null, null);
                        }
                    }
                    handler.generateWSDL(messageContext);
                    break block18;
                }
                log.debug((Object)JavaUtils.getMessage("defaultLogic00"));
                string = messageContext.getTransportName();
                SimpleTargetedChain simpleTargetedChain = null;
                if (log.isDebugEnabled()) {
                    log.debug((Object)JavaUtils.getMessage("transport01", "AxisServer.invoke", string));
                }
                if (string != null && (handler = this.getTransport(string)) != null && handler instanceof SimpleTargetedChain && (handler = (simpleTargetedChain = (SimpleTargetedChain)handler).getRequestHandler()) != null) {
                    handler.generateWSDL(messageContext);
                }
                if ((handler = this.getGlobalRequest()) != null) {
                    handler.generateWSDL(messageContext);
                }
                if ((handler = messageContext.getService()) == null) {
                    Message message = messageContext.getRequestMessage();
                    if (message != null) {
                        message.getSOAPEnvelope().getFirstBody();
                        handler = messageContext.getService();
                    }
                    if (handler == null) {
                        throw new AxisFault("Server.NoService", JavaUtils.getMessage("noService05", "" + messageContext.getTargetService()), null, null);
                    }
                }
                handler.generateWSDL(messageContext);
                handler = this.getGlobalResponse();
                if (handler != null) {
                    handler.generateWSDL(messageContext);
                }
                if (simpleTargetedChain != null && (handler = simpleTargetedChain.getResponseHandler()) != null) {
                    handler.generateWSDL(messageContext);
                }
            }
            catch (AxisFault axisFault) {
                throw axisFault;
            }
            catch (Exception exception) {
                throw AxisFault.makeFault(exception);
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)JavaUtils.getMessage("exit00", "AxisServer::generateWSDL"));
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

