/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.message;

import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Vector;
import javax.xml.rpc.namespace.QName;
import org.apache.axis.Constants;
import org.apache.axis.MessageContext;
import org.apache.axis.encoding.DeserializationContext;
import org.apache.axis.encoding.Deserializer;
import org.apache.axis.encoding.SerializationContext;
import org.apache.axis.encoding.SerializationContextImpl;
import org.apache.axis.message.EnvelopeHandler;
import org.apache.axis.message.SAX2EventRecorder;
import org.apache.axis.message.SAXOutputter;
import org.apache.axis.message.SOAPEnvelope;
import org.apache.axis.message.SOAPHandler;
import org.apache.axis.utils.JavaUtils;
import org.apache.axis.utils.Mapping;
import org.apache.axis.utils.XMLUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class MessageElement {
    protected static Log log = LogFactory.getLog((String)(class$org$apache$axis$message$MessageElement == null ? (class$org$apache$axis$message$MessageElement = MessageElement.class$("org.apache.axis.message.MessageElement")) : class$org$apache$axis$message$MessageElement).getName());
    private static final Mapping encMapping = new Mapping("http://schemas.xmlsoap.org/soap/encoding/", "SOAP-ENC");
    protected String name;
    protected String prefix;
    protected String namespaceURI;
    protected AttributesImpl attributes;
    protected String id;
    protected String href;
    protected boolean _isRoot = true;
    protected SOAPEnvelope message = null;
    protected boolean _isDirty = false;
    protected DeserializationContext context;
    protected QName typeQName = null;
    protected Vector qNameAttrs = null;
    protected SAX2EventRecorder recorder = null;
    protected int startEventIndex = 0;
    protected int startContentsIndex = 0;
    protected int endEventIndex = -1;
    protected Element elementRep = null;
    protected MessageElement parent = null;
    public ArrayList namespaces = null;
    protected String encodingStyle = null;
    Deserializer fixupDeserializer;
    private ArrayList children = null;
    static /* synthetic */ Class class$org$apache$axis$message$MessageElement;

    public MessageElement() {
    }

    MessageElement(String string, String string2) {
        this.namespaceURI = string;
        this.name = string2;
    }

    MessageElement(Element element) {
        this.elementRep = element;
        this.namespaceURI = element.getNamespaceURI();
        this.name = element.getLocalName();
    }

    public MessageElement(String string, String string2, String string3, Attributes attributes, DeserializationContext deserializationContext) {
        int n;
        if (log.isDebugEnabled()) {
            log.debug((Object)JavaUtils.getMessage("newElem00", super.toString(), "" + string3));
            n = 0;
            while (attributes != null && n < attributes.getLength()) {
                log.debug((Object)("  " + attributes.getQName(n) + " = '" + attributes.getValue(n) + "'"));
                ++n;
            }
        }
        this.namespaceURI = string;
        this.name = string2;
        n = string3.indexOf(":");
        if (n > 0) {
            this.prefix = string3.substring(0, n);
        }
        this.context = deserializationContext;
        this.startEventIndex = deserializationContext.getStartOfMappingsPos();
        this.setNSMappings(deserializationContext.getCurrentNSMappings());
        this.recorder = deserializationContext.getRecorder();
        if (attributes == null) {
            this.attributes = new AttributesImpl();
        } else {
            this.attributes = new AttributesImpl(attributes);
            String string4 = attributes.getValue("http://schemas.xmlsoap.org/soap/encoding/", "root");
            if (string4 != null) {
                this._isRoot = string4.equals("1");
            }
            this.id = attributes.getValue("id");
            if (this.id != null) {
                deserializationContext.registerElementByID(this.id, this);
            }
            this.href = attributes.getValue("href");
            if (attributes.getValue("http://schemas.xmlsoap.org/soap/encoding/", "arrayType") != null) {
                this.typeQName = Constants.SOAP_ARRAY;
            }
            this.encodingStyle = attributes.getValue("http://schemas.xmlsoap.org/soap/encoding/", "encodingStyle");
        }
    }

    public void setFixupDeserializer(Deserializer deserializer) {
        this.fixupDeserializer = deserializer;
    }

    public Deserializer getFixupDeserializer() {
        return this.fixupDeserializer;
    }

    public void setEndIndex(int n) {
        this.endEventIndex = n;
    }

    public boolean isDirty() {
        return this._isDirty;
    }

    public void setDirty(boolean bl) {
        this._isDirty = bl;
    }

    public boolean isRoot() {
        return this._isRoot;
    }

    public String getID() {
        return this.id;
    }

    public String getHref() {
        return this.href;
    }

    public Attributes getAttributes() {
        return this.attributes;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String string) {
        this.prefix = string;
    }

    public String getNamespaceURI() {
        return this.namespaceURI;
    }

    public void setNamespaceURI(String string) {
        this.namespaceURI = string;
    }

    public QName getType() {
        return this.typeQName;
    }

    public void setType(QName qName) {
        this.typeQName = qName;
    }

    public SAX2EventRecorder getRecorder() {
        return this.recorder;
    }

    public void setRecorder(SAX2EventRecorder sAX2EventRecorder) {
        this.recorder = sAX2EventRecorder;
    }

    public String getEncodingStyle() {
        if (this.encodingStyle == null) {
            if (this.parent == null) {
                return "";
            }
            return this.parent.getEncodingStyle();
        }
        return this.encodingStyle;
    }

    public void setEncodingStyle(String string) {
        if (string == null) {
            string = "";
        }
        this.encodingStyle = string;
        if (string.equals("http://schemas.xmlsoap.org/soap/encoding/")) {
            this.addMapping(encMapping);
        }
    }

    public MessageElement getParent() {
        return this.parent;
    }

    public void setParent(MessageElement messageElement) {
        this.parent = messageElement;
        if (messageElement != null) {
            messageElement.addChild(this);
        }
    }

    public void addChild(MessageElement messageElement) {
        if (this.children == null) {
            this.children = new ArrayList();
        }
        this.children.add(messageElement);
    }

    public ArrayList getChildren() {
        return this.children;
    }

    public void setContentsIndex(int n) {
        this.startContentsIndex = n;
    }

    public void setNSMappings(ArrayList arrayList) {
        this.namespaces = arrayList;
    }

    public String getPrefix(String string) {
        if (string == null || string.equals("")) {
            return null;
        }
        if (this.href != null) {
            return this.getRealElement().getPrefix(string);
        }
        if (this.namespaces != null) {
            int n = 0;
            while (n < this.namespaces.size()) {
                Mapping mapping = (Mapping)this.namespaces.get(n);
                if (mapping.getNamespaceURI().equals(string)) {
                    return mapping.getPrefix();
                }
                ++n;
            }
        }
        if (this.parent != null) {
            return this.parent.getPrefix(string);
        }
        return null;
    }

    public String getNamespaceURI(String string) {
        if (string == null) {
            string = "";
        }
        if (this.href != null) {
            return this.getRealElement().getNamespaceURI(string);
        }
        if (this.namespaces != null) {
            int n = 0;
            while (n < this.namespaces.size()) {
                Mapping mapping = (Mapping)this.namespaces.get(n);
                if (mapping.getPrefix().equals(string)) {
                    return mapping.getNamespaceURI();
                }
                ++n;
            }
        }
        if (this.parent != null) {
            return this.parent.getNamespaceURI(string);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)JavaUtils.getMessage("noPrefix00", "" + this, string));
        }
        return null;
    }

    public Object getValueAsType(QName qName) throws Exception {
        if (this.context == null) {
            throw new Exception(JavaUtils.getMessage("noContext00"));
        }
        Deserializer deserializer = this.context.getDeserializerForType(qName);
        if (deserializer == null) {
            throw new Exception(JavaUtils.getMessage("noDeser00", "" + qName));
        }
        this.context.pushElementHandler(new EnvelopeHandler((SOAPHandler)((Object)deserializer)));
        this.publishToHandler((ContentHandler)((Object)this.context));
        return deserializer.getValue();
    }

    public void addAttribute(String string, String string2, QName qName) {
        if (this.qNameAttrs == null) {
            this.qNameAttrs = new Vector();
        }
        QNameAttr qNameAttr = new QNameAttr();
        qNameAttr.name = new QName(string, string2);
        qNameAttr.value = qName;
        this.qNameAttrs.addElement(qNameAttr);
    }

    public void addAttribute(String string, String string2, String string3) {
        if (this.attributes == null) {
            this.attributes = new AttributesImpl();
        }
        this.attributes.addAttribute(string, string2, "", "CDATA", string3);
    }

    public void setAttribute(String string, String string2, String string3) {
        if (this.attributes != null) {
            int n = this.attributes.getIndex(string, string2);
            if (n > -1) {
                if (string3 != null) {
                    this.attributes.setValue(n, string3);
                } else {
                    this.attributes.removeAttribute(n);
                }
                return;
            }
        } else if (string3 != null) {
            this.attributes = new AttributesImpl();
        }
        this.addAttribute(string, string2, string3);
    }

    public String getAttributeValue(String string) {
        if (this.attributes == null) {
            return null;
        }
        return this.attributes.getValue(string);
    }

    public void setEnvelope(SOAPEnvelope sOAPEnvelope) {
        this.message = sOAPEnvelope;
    }

    public SOAPEnvelope getEnvelope() {
        return this.message;
    }

    public MessageElement getRealElement() {
        if (this.href == null) {
            return this;
        }
        Object object = this.context.getObjectByRef(this.href);
        if (object == null) {
            return null;
        }
        if (!(object instanceof MessageElement)) {
            return null;
        }
        return (MessageElement)object;
    }

    public Document getAsDocument() throws Exception {
        String string = this.getAsString();
        StringReader stringReader = new StringReader(string);
        Document document = XMLUtils.newDocument(new InputSource(stringReader));
        if (document == null) {
            throw new Exception(JavaUtils.getMessage("noDoc00", string));
        }
        return document;
    }

    private String getAsString() throws Exception {
        SerializationContextImpl serializationContextImpl = null;
        StringWriter stringWriter = new StringWriter();
        MessageContext messageContext = this.context != null ? this.context.getMessageContext() : MessageContext.getCurrentContext();
        serializationContextImpl = new SerializationContextImpl(stringWriter, messageContext);
        serializationContextImpl.setSendDecl(false);
        this.output(serializationContextImpl);
        stringWriter.close();
        return stringWriter.getBuffer().toString();
    }

    public Element getAsDOM() throws Exception {
        return this.getAsDocument().getDocumentElement();
    }

    public void publishToHandler(ContentHandler contentHandler) throws SAXException {
        if (this.recorder == null) {
            throw new SAXException(JavaUtils.getMessage("noRecorder00"));
        }
        this.recorder.replay(this.startEventIndex, this.endEventIndex, contentHandler);
    }

    public void publishContents(ContentHandler contentHandler) throws SAXException {
        if (this.recorder == null) {
            throw new SAXException(JavaUtils.getMessage("noRecorder00"));
        }
        this.recorder.replay(this.startContentsIndex, this.endEventIndex - 1, contentHandler);
    }

    public final void output(SerializationContext serializationContext) throws Exception {
        if (this.recorder != null && !this._isDirty) {
            this.recorder.replay(this.startEventIndex, this.endEventIndex, new SAXOutputter(serializationContext));
            return;
        }
        if (this.qNameAttrs != null) {
            int n = 0;
            while (n < this.qNameAttrs.size()) {
                QNameAttr qNameAttr = (QNameAttr)this.qNameAttrs.get(n);
                QName qName = qNameAttr.name;
                this.addAttribute(qName.getNamespaceURI(), qName.getLocalPart(), serializationContext.qName2String(qNameAttr.value));
                ++n;
            }
            this.qNameAttrs = null;
        }
        if (this.encodingStyle != null) {
            if (this.parent == null) {
                if (!this.encodingStyle.equals("")) {
                    this.setAttribute("http://schemas.xmlsoap.org/soap/envelope/", "encodingStyle", this.encodingStyle);
                }
            } else if (!this.encodingStyle.equals(this.parent.getEncodingStyle())) {
                this.setAttribute("http://schemas.xmlsoap.org/soap/envelope/", "encodingStyle", this.encodingStyle);
            }
        }
        this.outputImpl(serializationContext);
    }

    protected void outputImpl(SerializationContext serializationContext) throws Exception {
        if (this.elementRep != null) {
            boolean bl = serializationContext.getPretty();
            serializationContext.setPretty(false);
            serializationContext.writeDOMElement(this.elementRep);
            serializationContext.setPretty(bl);
            return;
        }
        if (this.prefix != null) {
            serializationContext.registerPrefixForURI(this.prefix, this.namespaceURI);
        }
        serializationContext.startElement(new QName(this.namespaceURI, this.name), this.attributes);
        serializationContext.endElement();
    }

    public String toString() {
        try {
            return this.getAsString();
        }
        catch (Exception exception) {
            log.error((Object)JavaUtils.getMessage("exception00"), (Throwable)exception);
            return null;
        }
    }

    public void addMapping(Mapping mapping) {
        if (this.namespaces == null) {
            this.namespaces = new ArrayList();
        }
        this.namespaces.add(mapping);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected static class QNameAttr {
        QName name;
        QName value;

        protected QNameAttr() {
        }
    }
}

