/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.encoding.ser;

import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Vector;
import javax.xml.rpc.namespace.QName;
import org.apache.axis.AxisFault;
import org.apache.axis.encoding.SerializationContext;
import org.apache.axis.encoding.Serializer;
import org.apache.axis.encoding.SimpleType;
import org.apache.axis.encoding.ser.BeanPropertyDescriptor;
import org.apache.axis.encoding.ser.BeanSerializer;
import org.apache.axis.utils.JavaUtils;
import org.apache.axis.utils.XMLUtils;
import org.apache.axis.wsdl.fromJava.ClassRep;
import org.apache.axis.wsdl.fromJava.FieldRep;
import org.apache.axis.wsdl.fromJava.Types;
import org.apache.axis.wsdl.toJava.Utils;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.AttributesImpl;

public class SimpleSerializer
implements Serializer {
    public QName xmlType;
    public Class javaType;
    private BeanPropertyDescriptor[] propertyDescriptor = null;
    private Vector beanAttributeNames = null;
    static /* synthetic */ Class class$org$apache$axis$encoding$SimpleType;
    static /* synthetic */ Class class$java$lang$Object;

    public SimpleSerializer(Class clazz, QName qName) {
        this.xmlType = qName;
        this.javaType = clazz;
        if ((class$org$apache$axis$encoding$SimpleType == null ? (class$org$apache$axis$encoding$SimpleType = SimpleSerializer.class$("org.apache.axis.encoding.SimpleType")) : class$org$apache$axis$encoding$SimpleType).isAssignableFrom(clazz)) {
            this.propertyDescriptor = BeanSerializer.getPd(clazz);
            this.beanAttributeNames = BeanSerializer.getBeanAttributes(clazz);
        }
    }

    public void serialize(QName qName, Attributes attributes, Object object, SerializationContext serializationContext) throws IOException {
        if (object != null && object.getClass() == (class$java$lang$Object == null ? (class$java$lang$Object = SimpleSerializer.class$("java.lang.Object")) : class$java$lang$Object)) {
            throw new IOException(JavaUtils.getMessage("cantSerialize02"));
        }
        if (object instanceof SimpleType) {
            attributes = this.getObjectAttributes(object, attributes);
        }
        serializationContext.startElement(qName, attributes);
        if (object != null) {
            if (object instanceof Float || object instanceof Double) {
                double d = 0.0;
                d = object instanceof Float ? ((Float)object).doubleValue() : ((Double)object).doubleValue();
                if (d == Double.NaN) {
                    serializationContext.writeString("NaN");
                } else if (d == Double.POSITIVE_INFINITY) {
                    serializationContext.writeString("INF");
                } else if (d == Double.NEGATIVE_INFINITY) {
                    serializationContext.writeString("-INF");
                } else {
                    serializationContext.writeString(object.toString());
                }
            } else if (object instanceof String) {
                serializationContext.writeString(XMLUtils.xmlEncodeString(object.toString()));
            } else if (object instanceof SimpleType) {
                serializationContext.writeString(object.toString());
            } else {
                serializationContext.writeString(object.toString());
            }
        }
        serializationContext.endElement();
    }

    private Attributes getObjectAttributes(Object object, Attributes attributes) {
        if (this.beanAttributeNames.isEmpty()) {
            return attributes;
        }
        AttributesImpl attributesImpl = attributes != null ? new AttributesImpl(attributes) : new AttributesImpl();
        try {
            int n = 0;
            while (n < this.propertyDescriptor.length) {
                Method method;
                String string = this.propertyDescriptor[n].getName();
                if (!string.equals("class") && this.beanAttributeNames.contains(Utils.xmlNameToJava(string)) && (method = this.propertyDescriptor[n].getReadMethod()) != null && method.getParameterTypes().length == 0) {
                    Object object2 = this.propertyDescriptor[n].getReadMethod().invoke(object, new Object[0]);
                    String string2 = object2 != null ? object2.toString() : "";
                    attributesImpl.addAttribute("", string, string, "CDATA", string2);
                }
                ++n;
            }
        }
        catch (Exception exception) {
            return attributesImpl;
        }
        return attributesImpl;
    }

    public String getMechanismType() {
        return "Axis SAX Mechanism";
    }

    public boolean writeSchema(Types types) throws Exception {
        Serializable serializable;
        Object object;
        if (!(class$org$apache$axis$encoding$SimpleType == null ? (class$org$apache$axis$encoding$SimpleType = SimpleSerializer.class$("org.apache.axis.encoding.SimpleType")) : class$org$apache$axis$encoding$SimpleType).isAssignableFrom(this.javaType)) {
            return false;
        }
        javax.wsdl.QName qName = types.getWsdlQName(this.xmlType);
        Element element = types.createElement("complexType");
        types.writeSchemaElement(qName, element);
        element.setAttribute("name", qName.getLocalPart());
        Element element2 = types.createElement("simpleContent");
        element.appendChild(element2);
        Element element3 = types.createElement("extension");
        element2.appendChild(element3);
        String string = "string";
        int n = 0;
        while (n < this.propertyDescriptor.length) {
            if (this.propertyDescriptor[n].getName().equals("value")) {
                object = this.propertyDescriptor[n];
                serializable = ((BeanPropertyDescriptor)object).getType();
                if (!types.isSimpleSchemaType((Class)serializable)) {
                    throw new AxisFault(JavaUtils.getMessage("AttrNotSimpleType01", ((Class)serializable).getName()));
                }
                string = types.writeType((Class)serializable);
            }
            ++n;
        }
        element3.setAttribute("base", string);
        object = types.getBeanBuilder().build(this.javaType);
        serializable = ((ClassRep)object).getFields();
        int n2 = 0;
        while (n2 < ((Vector)serializable).size()) {
            FieldRep fieldRep = (FieldRep)((Vector)serializable).elementAt(n2);
            String string2 = fieldRep.getName();
            if (this.beanAttributeNames.contains(string2)) {
                Class clazz = fieldRep.getType();
                if (!types.isSimpleSchemaType(clazz)) {
                    throw new AxisFault(JavaUtils.getMessage("AttrNotSimpleType00", string2, clazz.getName()));
                }
                String string3 = types.writeType(clazz);
                Element element4 = types.createAttributeElement(string2, string3, false, element3.getOwnerDocument());
                element3.appendChild(element4);
            }
            ++n2;
        }
        return true;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

