/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.encoding;

import java.util.Enumeration;
import java.util.Vector;
import javax.xml.rpc.namespace.QName;

public class ServiceDescription {
    String name;
    boolean serviceIsRPC = true;
    private String encodingStyleURI = null;
    public Vector inputParams = new Vector();
    public Vector outputParams = new Vector();
    public QName returnType = null;
    public boolean sendXsiType = true;

    public ServiceDescription(String string, boolean bl) {
        this.name = string;
        this.serviceIsRPC = bl;
        if (bl) {
            this.encodingStyleURI = "http://schemas.xmlsoap.org/soap/encoding/";
        }
    }

    public boolean isRPC() {
        return this.serviceIsRPC;
    }

    public void setEncodingStyleURI(String string) {
        this.encodingStyleURI = string;
    }

    public String getEncodingStyleURI() {
        return this.encodingStyleURI;
    }

    public void addInputParam(String string, QName qName) {
        this.inputParams.addElement(new Param(string, qName));
    }

    public void addOutputParam(String string, QName qName) {
        this.outputParams.addElement(new Param(string, qName));
    }

    public void removeAllParams() {
        this.inputParams.clear();
        this.outputParams.clear();
    }

    public void setReturnType(QName qName) {
        this.returnType = qName;
    }

    Param findByName(String string, Vector vector) {
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            Param param = (Param)enumeration.nextElement();
            if (param.name != null && !param.name.equals(string)) continue;
            return param;
        }
        return null;
    }

    public QName getInputParamTypeByName(String string) {
        Param param = this.findByName(string, this.inputParams);
        if (param != null) {
            return param.type;
        }
        return null;
    }

    public QName getInputParamTypeByPos(int n) {
        if (this.inputParams.size() <= n) {
            return null;
        }
        Param param = (Param)this.inputParams.elementAt(n);
        if (param != null) {
            return param.type;
        }
        return null;
    }

    public String getInputParamNameByPos(int n) {
        if (this.inputParams.size() <= n) {
            return null;
        }
        Param param = (Param)this.inputParams.elementAt(n);
        if (param != null) {
            return param.name;
        }
        return null;
    }

    public QName getParamTypeByName(String string, String string2) {
        if (string != null) {
            if (string.equals("request")) {
                return this.getInputParamTypeByName(string2);
            }
            if (string.equals("response")) {
                return this.getOutputParamTypeByName(string2);
            }
        }
        return null;
    }

    public QName getOutputParamTypeByName(String string) {
        Param param = this.findByName(string, this.outputParams);
        if (param != null) {
            return param.type;
        }
        return null;
    }

    public QName getOutputParamTypeByPos(int n) {
        if (this.inputParams.size() <= n) {
            return null;
        }
        Param param = (Param)this.outputParams.elementAt(n);
        if (param != null) {
            return param.type;
        }
        return null;
    }

    public QName getReturnType() {
        return this.returnType;
    }

    class Param {
        public String name;
        public QName type;

        Param(String string, QName qName) {
            this.name = string;
            this.type = qName;
        }

        Param() {
        }
    }
}

