/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.deployment.wsdd;

import java.io.IOException;
import javax.xml.rpc.namespace.QName;
import org.apache.axis.deployment.wsdd.WSDDConstants;
import org.apache.axis.deployment.wsdd.WSDDElement;
import org.apache.axis.deployment.wsdd.WSDDException;
import org.apache.axis.encoding.SerializationContext;
import org.apache.axis.utils.JavaUtils;
import org.apache.axis.utils.XMLUtils;
import org.w3c.dom.Element;
import org.xml.sax.helpers.AttributesImpl;

public class WSDDTypeMapping
extends WSDDElement {
    protected QName qname = null;
    protected String serializer = null;
    protected String deserializer = null;
    protected QName typeQName = null;
    protected String ref = null;
    protected String encodingStyle = null;

    public WSDDTypeMapping() {
    }

    public WSDDTypeMapping(Element element) throws WSDDException {
        this(element, true);
        this.serializer = element.getAttribute("serializer");
        this.deserializer = element.getAttribute("deserializer");
        this.encodingStyle = element.getAttribute("encodingStyle");
        if (this.encodingStyle == null) {
            this.encodingStyle = "http://schemas.xmlsoap.org/soap/encoding/";
        }
    }

    protected WSDDTypeMapping(Element element, boolean bl) throws WSDDException {
        super(element);
        String string = element.getAttribute("qname");
        this.qname = XMLUtils.getQNameFromString(string, element);
        String string2 = element.getAttribute("type");
        this.typeQName = XMLUtils.getQNameFromString(string2, element);
        if (string2 == null || string2.equals("")) {
            string2 = element.getAttribute("languageSpecificType");
            this.typeQName = XMLUtils.getQNameFromString(string2, element);
        }
    }

    public void writeToContext(SerializationContext serializationContext) throws IOException {
        AttributesImpl attributesImpl = new AttributesImpl();
        attributesImpl.addAttribute("", "encodingStyle", "encodingStyle", "CDATA", this.encodingStyle);
        attributesImpl.addAttribute("", "serializer", "serializer", "CDATA", this.serializer);
        attributesImpl.addAttribute("", "deserializer", "deserializer", "CDATA", this.deserializer);
        String string = serializationContext.qName2String(this.typeQName);
        attributesImpl.addAttribute("", "type", "type", "CDATA", string);
        String string2 = serializationContext.qName2String(this.qname);
        attributesImpl.addAttribute("", "qname", "qname", "CDATA", string2);
        serializationContext.startElement(WSDDConstants.TYPE_QNAME, attributesImpl);
        serializationContext.endElement();
    }

    protected QName getElementName() {
        return WSDDConstants.TYPE_QNAME;
    }

    public String getRef() {
        return this.ref;
    }

    public void setRef(String string) {
        this.ref = string;
    }

    public String getEncodingStyle() {
        return this.encodingStyle;
    }

    public void setEncodingStyle(String string) {
        this.encodingStyle = string;
    }

    public QName getQName() {
        return this.qname;
    }

    public void setQName(QName qName) {
        this.qname = qName;
    }

    public Class getLanguageSpecificType() throws ClassNotFoundException {
        if (this.typeQName != null) {
            if (!"http://xml.apache.org/axis/wsdd/providers/java".equals(this.typeQName.getNamespaceURI())) {
                throw new ClassNotFoundException(JavaUtils.getMessage("badTypeNamespace00", this.typeQName.getNamespaceURI(), "http://xml.apache.org/axis/wsdd/providers/java"));
            }
            String string = JavaUtils.getLoadableClassName(this.typeQName.getLocalPart());
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            return Class.forName(string, true, classLoader);
        }
        throw new ClassNotFoundException(JavaUtils.getMessage("noTypeQName00"));
    }

    public void setLanguageSpecificType(Class clazz) {
        String string = clazz.getName();
        this.typeQName = new QName("http://xml.apache.org/axis/wsdd/providers/java", string);
    }

    public void setLanguageSpecificType(String string) {
        this.typeQName = new QName("http://xml.apache.org/axis/wsdd/providers/java", string);
    }

    public Class getSerializer() throws ClassNotFoundException {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        return Class.forName(this.serializer, true, classLoader);
    }

    public String getSerializerName() {
        return this.serializer;
    }

    public void setSerializer(Class clazz) {
        this.serializer = clazz.getName();
    }

    public void setSerializer(String string) {
        this.serializer = string;
    }

    public Class getDeserializer() throws ClassNotFoundException {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        return Class.forName(this.deserializer, true, classLoader);
    }

    public String getDeserializerName() {
        return this.deserializer;
    }

    public void setDeserializer(Class clazz) {
        this.deserializer = clazz.getName();
    }

    public void setDeserializer(String string) {
        this.deserializer = string;
    }
}

