/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.deployment.wsdd;

import java.util.Hashtable;
import javax.xml.rpc.namespace.QName;
import org.apache.axis.EngineConfiguration;
import org.apache.axis.Handler;
import org.apache.axis.deployment.wsdd.WSDDConstants;
import org.apache.axis.deployment.wsdd.WSDDException;
import org.apache.axis.deployment.wsdd.WSDDOperation;
import org.apache.axis.deployment.wsdd.WSDDService;
import org.apache.axis.deployment.wsdd.providers.WSDDHandlerProvider;
import org.apache.axis.deployment.wsdd.providers.WSDDJavaEJBProvider;
import org.apache.axis.deployment.wsdd.providers.WSDDJavaMsgProvider;
import org.apache.axis.deployment.wsdd.providers.WSDDJavaRPCProvider;
import org.apache.axis.utils.JavaUtils;

public abstract class WSDDProvider {
    private static Hashtable providers = new Hashtable();

    public static void registerProvider(QName qName, WSDDProvider wSDDProvider) {
        providers.put(qName, wSDDProvider);
    }

    public WSDDOperation[] getOperations() {
        return null;
    }

    public WSDDOperation getOperation(String string) {
        WSDDOperation[] wSDDOperationArray = this.getOperations();
        return null;
    }

    public static Handler getInstance(QName qName, WSDDService wSDDService, EngineConfiguration engineConfiguration) throws Exception {
        if (qName == null) {
            throw new WSDDException(JavaUtils.getMessage("nullProvider00"));
        }
        WSDDProvider wSDDProvider = (WSDDProvider)providers.get(qName);
        if (wSDDProvider == null) {
            throw new WSDDException(JavaUtils.getMessage("noMatchingProvider00", qName.toString()));
        }
        return wSDDProvider.newProviderInstance(wSDDService, engineConfiguration);
    }

    public abstract Handler newProviderInstance(WSDDService var1, EngineConfiguration var2) throws Exception;

    static {
        providers.put(WSDDConstants.JAVARPC_PROVIDER, new WSDDJavaRPCProvider());
        providers.put(WSDDConstants.JAVAMSG_PROVIDER, new WSDDJavaMsgProvider());
        providers.put(WSDDConstants.HANDLER_PROVIDER, new WSDDHandlerProvider());
        providers.put(WSDDConstants.EJB_PROVIDER, new WSDDJavaEJBProvider());
    }
}

