/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.deployment.wsdd;

import java.io.IOException;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import javax.xml.rpc.namespace.QName;
import org.apache.axis.AxisEngine;
import org.apache.axis.ConfigurationException;
import org.apache.axis.EngineConfiguration;
import org.apache.axis.Handler;
import org.apache.axis.deployment.DeploymentException;
import org.apache.axis.deployment.wsdd.WSDDBeanMapping;
import org.apache.axis.deployment.wsdd.WSDDChain;
import org.apache.axis.deployment.wsdd.WSDDConstants;
import org.apache.axis.deployment.wsdd.WSDDElement;
import org.apache.axis.deployment.wsdd.WSDDException;
import org.apache.axis.deployment.wsdd.WSDDGlobalConfiguration;
import org.apache.axis.deployment.wsdd.WSDDHandler;
import org.apache.axis.deployment.wsdd.WSDDRequestFlow;
import org.apache.axis.deployment.wsdd.WSDDResponseFlow;
import org.apache.axis.deployment.wsdd.WSDDService;
import org.apache.axis.deployment.wsdd.WSDDTransport;
import org.apache.axis.deployment.wsdd.WSDDTypeMapping;
import org.apache.axis.deployment.wsdd.WSDDTypeMappingContainer;
import org.apache.axis.encoding.DeserializerFactory;
import org.apache.axis.encoding.SerializationContext;
import org.apache.axis.encoding.SerializerFactory;
import org.apache.axis.encoding.TypeMapping;
import org.apache.axis.encoding.TypeMappingRegistry;
import org.apache.axis.encoding.TypeMappingRegistryImpl;
import org.apache.axis.encoding.ser.BaseDeserializerFactory;
import org.apache.axis.encoding.ser.BaseSerializerFactory;
import org.apache.axis.handlers.soap.SOAPService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Element;

public class WSDDDeployment
extends WSDDElement
implements WSDDTypeMappingContainer,
EngineConfiguration {
    protected static Log log = LogFactory.getLog((String)(class$org$apache$axis$deployment$wsdd$WSDDDeployment == null ? (class$org$apache$axis$deployment$wsdd$WSDDDeployment = WSDDDeployment.class$("org.apache.axis.deployment.wsdd.WSDDDeployment")) : class$org$apache$axis$deployment$wsdd$WSDDDeployment).getName());
    private HashMap handlers = new HashMap();
    private HashMap services = new HashMap();
    private HashMap transports = new HashMap();
    private Vector typeMappings = new Vector();
    private WSDDGlobalConfiguration globalConfig = null;
    private HashMap namespaceToServices = new HashMap();
    TypeMappingRegistry tmr = new TypeMappingRegistryImpl();
    private boolean tmrDeployed = false;
    static /* synthetic */ Class class$org$apache$axis$deployment$wsdd$WSDDDeployment;

    void addHandler(WSDDHandler wSDDHandler) {
        this.handlers.put(wSDDHandler.getQName(), wSDDHandler);
    }

    void addService(WSDDService wSDDService) {
        WSDDService wSDDService2 = (WSDDService)this.services.get(wSDDService.getQName());
        if (wSDDService2 != null) {
            wSDDService2.removeNamespaceMappings(this);
        }
        this.services.put(wSDDService.getQName(), wSDDService);
    }

    void addTransport(WSDDTransport wSDDTransport) {
        this.transports.put(wSDDTransport.getQName(), wSDDTransport);
    }

    public void deployHandler(WSDDHandler wSDDHandler) {
        wSDDHandler.deployToRegistry(this);
    }

    public void deployTransport(WSDDTransport wSDDTransport) {
        wSDDTransport.deployToRegistry(this);
    }

    public void deployService(WSDDService wSDDService) {
        wSDDService.deployToRegistry(this);
    }

    public void undeployHandler(QName qName) {
        this.handlers.remove(qName);
    }

    public void undeployService(QName qName) {
        this.services.remove(qName);
    }

    public void undeployTransport(QName qName) {
        this.transports.remove(qName);
    }

    public void deployTypeMapping(WSDDTypeMapping wSDDTypeMapping) throws WSDDException {
        if (!this.typeMappings.contains(wSDDTypeMapping)) {
            this.typeMappings.add(wSDDTypeMapping);
        }
        if (this.tmrDeployed) {
            this.deployMapping(wSDDTypeMapping);
        }
    }

    public WSDDDeployment() {
    }

    public WSDDDeployment(Element element) throws WSDDException {
        super(element);
        Object object;
        Element[] elementArray = this.getChildElements(element, "handler");
        int n = 0;
        while (n < elementArray.length) {
            object = new WSDDHandler(elementArray[n]);
            this.deployHandler((WSDDHandler)object);
            ++n;
        }
        elementArray = this.getChildElements(element, "chain");
        n = 0;
        while (n < elementArray.length) {
            object = new WSDDChain(elementArray[n]);
            this.deployHandler((WSDDHandler)object);
            ++n;
        }
        elementArray = this.getChildElements(element, "transport");
        n = 0;
        while (n < elementArray.length) {
            object = new WSDDTransport(elementArray[n]);
            this.deployTransport((WSDDTransport)object);
            ++n;
        }
        elementArray = this.getChildElements(element, "service");
        n = 0;
        while (n < elementArray.length) {
            object = new WSDDService(elementArray[n]);
            this.deployService((WSDDService)object);
            ++n;
        }
        elementArray = this.getChildElements(element, "typeMapping");
        n = 0;
        while (n < elementArray.length) {
            object = new WSDDTypeMapping(elementArray[n]);
            this.deployTypeMapping((WSDDTypeMapping)object);
            ++n;
        }
        elementArray = this.getChildElements(element, "beanMapping");
        n = 0;
        while (n < elementArray.length) {
            object = new WSDDBeanMapping(elementArray[n]);
            this.deployTypeMapping((WSDDTypeMapping)object);
            ++n;
        }
        object = this.getChildElement(element, "globalConfiguration");
        if (object != null) {
            this.globalConfig = new WSDDGlobalConfiguration((Element)object);
        }
    }

    protected QName getElementName() {
        return WSDDConstants.DEPLOY_QNAME;
    }

    public void deployToRegistry(WSDDDeployment wSDDDeployment) throws DeploymentException {
        WSDDElement wSDDElement;
        WSDDGlobalConfiguration wSDDGlobalConfiguration = this.getGlobalConfiguration();
        if (wSDDGlobalConfiguration != null) {
            wSDDDeployment.setGlobalConfiguration(wSDDGlobalConfiguration);
        }
        Iterator<Object> iterator = this.handlers.values().iterator();
        while (iterator.hasNext()) {
            wSDDElement = (WSDDHandler)iterator.next();
            wSDDDeployment.deployHandler((WSDDHandler)wSDDElement);
        }
        iterator = this.transports.values().iterator();
        while (iterator.hasNext()) {
            wSDDElement = (WSDDTransport)iterator.next();
            wSDDDeployment.deployTransport((WSDDTransport)wSDDElement);
        }
        iterator = this.services.values().iterator();
        while (iterator.hasNext()) {
            wSDDElement = (WSDDService)iterator.next();
            ((WSDDService)wSDDElement).deployToRegistry(wSDDDeployment);
        }
        iterator = this.typeMappings.iterator();
        while (iterator.hasNext()) {
            wSDDElement = (WSDDTypeMapping)iterator.next();
            wSDDDeployment.deployTypeMapping((WSDDTypeMapping)wSDDElement);
        }
    }

    private void deployMapping(WSDDTypeMapping wSDDTypeMapping) throws WSDDException {
        try {
            String string = wSDDTypeMapping.getEncodingStyle();
            if (string == null) {
                string = "http://schemas.xmlsoap.org/soap/encoding/";
            }
            TypeMapping typeMapping = (TypeMapping)this.tmr.getTypeMapping(string);
            TypeMapping typeMapping2 = (TypeMapping)this.tmr.getDefaultTypeMapping();
            if (typeMapping == null || typeMapping == typeMapping2) {
                typeMapping = (TypeMapping)this.tmr.createTypeMapping();
                typeMapping.setSupportedNamespaces(new String[]{string});
                this.tmr.register(string, typeMapping);
            }
            SerializerFactory serializerFactory = null;
            DeserializerFactory deserializerFactory = null;
            if (wSDDTypeMapping.getSerializerName() != null && !wSDDTypeMapping.getSerializerName().equals("")) {
                serializerFactory = BaseSerializerFactory.createFactory(wSDDTypeMapping.getSerializer(), wSDDTypeMapping.getLanguageSpecificType(), wSDDTypeMapping.getQName());
            }
            if (wSDDTypeMapping.getDeserializerName() != null && !wSDDTypeMapping.getDeserializerName().equals("")) {
                deserializerFactory = BaseDeserializerFactory.createFactory(wSDDTypeMapping.getDeserializer(), wSDDTypeMapping.getLanguageSpecificType(), wSDDTypeMapping.getQName());
            }
            typeMapping.register(wSDDTypeMapping.getLanguageSpecificType(), wSDDTypeMapping.getQName(), serializerFactory, deserializerFactory);
        }
        catch (Exception exception) {
            throw new WSDDException(exception);
        }
    }

    public void writeToContext(SerializationContext serializationContext) throws IOException {
        WSDDElement wSDDElement;
        serializationContext.registerPrefixForURI("", "http://xml.apache.org/axis/wsdd/");
        serializationContext.registerPrefixForURI("java", "http://xml.apache.org/axis/wsdd/providers/java");
        serializationContext.startElement(new QName("http://xml.apache.org/axis/wsdd/", "deployment"), null);
        if (this.globalConfig != null) {
            this.globalConfig.writeToContext(serializationContext);
        }
        Iterator<Object> iterator = this.handlers.values().iterator();
        while (iterator.hasNext()) {
            wSDDElement = (WSDDHandler)iterator.next();
            ((WSDDHandler)wSDDElement).writeToContext(serializationContext);
        }
        iterator = this.services.values().iterator();
        while (iterator.hasNext()) {
            wSDDElement = (WSDDService)iterator.next();
            ((WSDDService)wSDDElement).writeToContext(serializationContext);
        }
        iterator = this.transports.values().iterator();
        while (iterator.hasNext()) {
            wSDDElement = (WSDDTransport)iterator.next();
            ((WSDDTransport)wSDDElement).writeToContext(serializationContext);
        }
        iterator = this.typeMappings.iterator();
        while (iterator.hasNext()) {
            wSDDElement = (WSDDTypeMapping)iterator.next();
            ((WSDDTypeMapping)wSDDElement).writeToContext(serializationContext);
        }
        serializationContext.endElement();
    }

    public WSDDGlobalConfiguration getGlobalConfiguration() {
        return this.globalConfig;
    }

    public void setGlobalConfiguration(WSDDGlobalConfiguration wSDDGlobalConfiguration) {
        this.globalConfig = wSDDGlobalConfiguration;
    }

    public WSDDTypeMapping[] getTypeMappings() {
        WSDDTypeMapping[] wSDDTypeMappingArray = new WSDDTypeMapping[this.typeMappings.size()];
        this.typeMappings.toArray(wSDDTypeMappingArray);
        return wSDDTypeMappingArray;
    }

    public WSDDService[] getServices() {
        WSDDService[] wSDDServiceArray = new WSDDService[this.services.size()];
        this.services.values().toArray(wSDDServiceArray);
        return wSDDServiceArray;
    }

    public WSDDService getWSDDService(QName qName) {
        return (WSDDService)this.services.get(qName);
    }

    public Handler getHandler(QName qName) throws ConfigurationException {
        WSDDHandler wSDDHandler = (WSDDHandler)this.handlers.get(qName);
        if (wSDDHandler != null) {
            return wSDDHandler.getInstance(this);
        }
        return null;
    }

    public Handler getTransport(QName qName) throws ConfigurationException {
        WSDDTransport wSDDTransport = (WSDDTransport)this.transports.get(qName);
        if (wSDDTransport != null) {
            return wSDDTransport.getInstance(this);
        }
        return null;
    }

    public SOAPService getService(QName qName) throws ConfigurationException {
        WSDDService wSDDService = (WSDDService)this.services.get(qName);
        if (wSDDService != null) {
            return (SOAPService)wSDDService.getInstance(this);
        }
        return null;
    }

    public SOAPService getServiceByNamespaceURI(String string) throws ConfigurationException {
        WSDDService wSDDService = (WSDDService)this.namespaceToServices.get(string);
        if (wSDDService != null) {
            return (SOAPService)wSDDService.getInstance(this);
        }
        return null;
    }

    public void configureEngine(AxisEngine axisEngine) throws ConfigurationException {
    }

    public void writeEngineConfig(AxisEngine axisEngine) throws ConfigurationException {
    }

    public TypeMapping getTypeMapping(String string) throws ConfigurationException {
        return (TypeMapping)this.getTypeMappingRegistry().getTypeMapping(string);
    }

    public TypeMappingRegistry getTypeMappingRegistry() throws ConfigurationException {
        if (!this.tmrDeployed) {
            int n = 0;
            while (n < this.typeMappings.size()) {
                WSDDTypeMapping wSDDTypeMapping = (WSDDTypeMapping)this.typeMappings.get(n);
                this.deployMapping(wSDDTypeMapping);
                ++n;
            }
            this.tmrDeployed = true;
        }
        return this.tmr;
    }

    public Handler getGlobalRequest() throws ConfigurationException {
        WSDDRequestFlow wSDDRequestFlow;
        if (this.globalConfig != null && (wSDDRequestFlow = this.globalConfig.getRequestFlow()) != null) {
            return wSDDRequestFlow.getInstance(this);
        }
        return null;
    }

    public Handler getGlobalResponse() throws ConfigurationException {
        WSDDResponseFlow wSDDResponseFlow;
        if (this.globalConfig != null && (wSDDResponseFlow = this.globalConfig.getResponseFlow()) != null) {
            return wSDDResponseFlow.getInstance(this);
        }
        return null;
    }

    public Hashtable getGlobalOptions() throws ConfigurationException {
        return this.globalConfig.getParametersTable();
    }

    public void registerNamespaceForService(String string, WSDDService wSDDService) {
        this.namespaceToServices.put(string, wSDDService);
    }

    public void removeNamespaceMapping(String string) {
        this.namespaceToServices.remove(string);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

