/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.deployment.v2dd;

import org.apache.axis.deployment.v2dd.V2DDElement;
import org.apache.axis.deployment.v2dd.V2DDException;
import org.apache.axis.deployment.v2dd.V2DDFaultListener;
import org.apache.axis.deployment.v2dd.V2DDMappings;
import org.apache.axis.deployment.v2dd.V2DDProvider;
import org.apache.axis.utils.JavaUtils;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class V2DDService
extends V2DDElement {
    public V2DDService(Element element) {
        super(element);
    }

    public String getID() {
        return this.element.getAttribute("id");
    }

    public String getType() {
        return this.element.getAttribute("type");
    }

    public V2DDProvider getProvider() throws V2DDException {
        NodeList nodeList = this.element.getElementsByTagNameNS("http://xml.apache.org/xml-soap/deployment", "provider");
        Element element = (Element)nodeList.item(0);
        if (element == null) {
            throw new V2DDException(JavaUtils.getMessage("noProviderElem00"));
        }
        V2DDProvider v2DDProvider = (V2DDProvider)this.getChild(element);
        if (v2DDProvider == null) {
            String string = null;
            if (element.getAttribute("type").equals("script")) {
                string = "script";
            }
            if (element.getAttribute("type").equals("org.apache.soap.providers.com.RPCProvider")) {
                string = "com";
            }
            if (string == null) {
                NodeList nodeList2 = element.getElementsByTagNameNS("http://xml.apache.org/xml-soap/deployment", "java");
                string = nodeList2.getLength() > 0 ? "java" : "";
            }
            v2DDProvider = V2DDProvider.getProvider(string, element);
            this.addChild(element, v2DDProvider);
        }
        return v2DDProvider;
    }

    public V2DDFaultListener getFaultListener() {
        NodeList nodeList = this.element.getElementsByTagNameNS("http://xml.apache.org/xml-soap/deployment", "provider");
        Element element = (Element)nodeList.item(0);
        if (element == null) {
            return null;
        }
        V2DDFaultListener v2DDFaultListener = (V2DDFaultListener)this.getChild(element);
        if (v2DDFaultListener == null) {
            v2DDFaultListener = new V2DDFaultListener(element);
            this.addChild(element, v2DDFaultListener);
        }
        return v2DDFaultListener;
    }

    public V2DDMappings getMappings() {
        NodeList nodeList = this.element.getElementsByTagNameNS("http://xml.apache.org/xml-soap/deployment", "provider");
        Element element = (Element)nodeList.item(0);
        if (element == null) {
            return null;
        }
        V2DDMappings v2DDMappings = (V2DDMappings)this.getChild(element);
        if (v2DDMappings == null) {
            v2DDMappings = new V2DDMappings(element);
            this.addChild(element, v2DDMappings);
        }
        return v2DDMappings;
    }
}

