/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.deployment;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.xml.rpc.namespace.QName;
import org.apache.axis.Handler;
import org.apache.axis.SimpleTargetedChain;
import org.apache.axis.deployment.DeployableItem;
import org.apache.axis.deployment.DeploymentDocument;
import org.apache.axis.deployment.DeploymentException;
import org.apache.axis.deployment.wsdd.WSDDGlobalConfiguration;
import org.apache.axis.encoding.SerializationContext;
import org.apache.axis.encoding.TypeMapping;
import org.apache.axis.encoding.TypeMappingRegistry;
import org.apache.axis.handlers.soap.SOAPService;

public abstract class DeploymentRegistry
implements Serializable {
    public abstract Handler getHandler(QName var1) throws DeploymentException;

    public abstract DeployableItem getHandlerDeployableItem(QName var1) throws DeploymentException;

    public abstract Handler getService(QName var1) throws DeploymentException;

    public abstract DeployableItem getServiceDeployableItem(QName var1) throws DeploymentException;

    public abstract Handler getTransport(QName var1) throws DeploymentException;

    public abstract DeployableItem getTransportDeployableItem(QName var1) throws DeploymentException;

    public abstract TypeMappingRegistry getTypeMappingRegistry();

    public abstract TypeMapping getTypeMapping(String var1) throws DeploymentException;

    public abstract void addTypeMapping(String var1, TypeMapping var2) throws DeploymentException;

    public abstract void removeTypeMapping(String var1) throws DeploymentException;

    public abstract void deploy(DeploymentDocument var1) throws DeploymentException;

    public abstract void deployItem(DeployableItem var1) throws DeploymentException;

    public abstract void deployService(DeployableItem var1) throws DeploymentException;

    public abstract void deployService(String var1, SOAPService var2) throws DeploymentException;

    public abstract void deployHandler(DeployableItem var1) throws DeploymentException;

    public abstract void deployHandler(String var1, Handler var2) throws DeploymentException;

    public abstract void deployTransport(DeployableItem var1) throws DeploymentException;

    public abstract void deployTransport(String var1, SimpleTargetedChain var2) throws DeploymentException;

    public abstract void removeDeployedItem(QName var1) throws DeploymentException;

    public abstract void undeployHandler(QName var1) throws DeploymentException;

    public abstract void undeployHandler(String var1) throws DeploymentException;

    public abstract void undeployService(QName var1) throws DeploymentException;

    public abstract void undeployService(String var1) throws DeploymentException;

    public abstract void undeployTransport(QName var1) throws DeploymentException;

    public abstract void undeployTransport(String var1) throws DeploymentException;

    public abstract void setGlobalConfiguration(WSDDGlobalConfiguration var1);

    public abstract void writeToContext(SerializationContext var1) throws IOException;

    public void save(String string) throws IOException {
        DeploymentRegistry.save(string, this);
    }

    public void save(OutputStream outputStream) throws IOException {
        DeploymentRegistry.save(outputStream, this);
    }

    public static void save(String string, DeploymentRegistry deploymentRegistry) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(string);
        DeploymentRegistry.save(fileOutputStream, deploymentRegistry);
    }

    public static void save(OutputStream outputStream, DeploymentRegistry deploymentRegistry) throws IOException {
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(outputStream);
        objectOutputStream.writeObject(deploymentRegistry);
        objectOutputStream.close();
        outputStream.close();
    }

    public static DeploymentRegistry load(String string) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(string);
        return DeploymentRegistry.load(fileInputStream);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static DeploymentRegistry load(InputStream inputStream) throws IOException {
        DeploymentRegistry deploymentRegistry2;
        ObjectInputStream objectInputStream = new ObjectInputStream(inputStream);
        try {
            try {
                DeploymentRegistry deploymentRegistry;
                deploymentRegistry2 = deploymentRegistry = (DeploymentRegistry)objectInputStream.readObject();
                Object var5_5 = null;
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new IOException(classNotFoundException.toString());
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            objectInputStream.close();
            inputStream.close();
            throw throwable;
        }
        objectInputStream.close();
        inputStream.close();
        return deploymentRegistry2;
    }

    public abstract Enumeration getServices() throws DeploymentException;

    public abstract Enumeration getHandlers() throws DeploymentException;

    public abstract Enumeration getTransports() throws DeploymentException;

    public abstract Handler getGlobalRequest() throws DeploymentException;

    public abstract Handler getGlobalResponse() throws DeploymentException;

    public abstract Hashtable getGlobalOptions();
}

