/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.client;

import java.lang.reflect.Constructor;
import java.net.URL;
import java.util.Hashtable;
import java.util.Map;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.spi.ObjectFactory;
import javax.xml.rpc.namespace.QName;
import org.apache.axis.EngineConfiguration;
import org.apache.axis.client.Service;
import org.apache.axis.configuration.DefaultEngineConfigurationFactory;

public class ServiceFactory
implements ObjectFactory {
    public static final String SERVICE_CLASSNAME = "service classname";
    public static final String WSDL_LOCATION = "WSDL location";
    public static final String MAINTAIN_SESSION = "maintain session";
    public static final String SERVICE_NAMESPACE = "service namespace";
    public static final String SERVICE_LOCAL_PART = "service local part";
    private static EngineConfiguration defaultEngineConfig = new DefaultEngineConfigurationFactory().getClientEngineConfig();
    private static ThreadLocal threadDefaultConfig = new ThreadLocal();
    static /* synthetic */ Class class$java$net$URL;
    static /* synthetic */ Class class$javax$xml$rpc$namespace$QName;
    static /* synthetic */ Class class$org$apache$axis$client$Service;

    public static void setThreadDefaultConfig(EngineConfiguration engineConfiguration) {
        threadDefaultConfig.set(engineConfiguration);
    }

    public static Service getService(Map map) {
        Service service = null;
        InitialContext initialContext = null;
        EngineConfiguration engineConfiguration = (EngineConfiguration)map.get("engineConfig");
        if (engineConfiguration == null) {
            engineConfiguration = (EngineConfiguration)threadDefaultConfig.get();
        }
        if (engineConfiguration == null) {
            engineConfiguration = defaultEngineConfig;
        }
        try {
            initialContext = new InitialContext();
        }
        catch (NamingException namingException) {
            // empty catch block
        }
        if (initialContext != null) {
            String string = (String)map.get("jndiName");
            if (string == null) {
                string = "axisServiceName";
            }
            try {
                service = (Service)initialContext.lookup(string);
            }
            catch (NamingException namingException) {
                service = new Service(engineConfiguration);
                try {
                    initialContext.bind(string, (Object)service);
                }
                catch (NamingException namingException2) {}
            }
        } else {
            service = new Service(engineConfiguration);
        }
        return service;
    }

    public Object getObjectInstance(Object object, Name name, Context context, Hashtable hashtable) throws Exception {
        Object var5_5 = null;
        if (object instanceof Reference) {
            Reference reference = (Reference)object;
            RefAddr refAddr = reference.get(SERVICE_CLASSNAME);
            Object object2 = null;
            if (refAddr != null && (object2 = refAddr.getContent()) instanceof String) {
                var5_5 = Class.forName((String)object2).newInstance();
            } else {
                refAddr = reference.get(WSDL_LOCATION);
                if (refAddr != null && (object2 = refAddr.getContent()) instanceof String) {
                    URL uRL = new URL((String)object2);
                    refAddr = reference.get(SERVICE_NAMESPACE);
                    if (refAddr != null && (object2 = refAddr.getContent()) instanceof String) {
                        String string = (String)object2;
                        refAddr = reference.get(SERVICE_LOCAL_PART);
                        if (refAddr != null && (object2 = refAddr.getContent()) instanceof String) {
                            String string2 = (String)object2;
                            QName qName = new QName(string, string2);
                            Class[] classArray = new Class[]{class$java$net$URL == null ? (class$java$net$URL = ServiceFactory.class$("java.net.URL")) : class$java$net$URL, class$javax$xml$rpc$namespace$QName == null ? (class$javax$xml$rpc$namespace$QName = ServiceFactory.class$("javax.xml.rpc.namespace.QName")) : class$javax$xml$rpc$namespace$QName};
                            Object[] objectArray = new Object[]{uRL, qName};
                            Constructor constructor = (class$org$apache$axis$client$Service == null ? (class$org$apache$axis$client$Service = ServiceFactory.class$("org.apache.axis.client.Service")) : class$org$apache$axis$client$Service).getDeclaredConstructor(classArray);
                            var5_5 = constructor.newInstance(objectArray);
                        }
                    }
                }
            }
            refAddr = reference.get(MAINTAIN_SESSION);
            if (refAddr != null && var5_5 instanceof Service) {
                ((Service)var5_5).setMaintainSession(true);
            }
        }
        return var5_5;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

