/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.client;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.Remote;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;
import javax.wsdl.Binding;
import javax.wsdl.Definition;
import javax.wsdl.Port;
import javax.wsdl.PortType;
import javax.wsdl.QName;
import javax.wsdl.extensions.soap.SOAPAddress;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLReader;
import javax.xml.rpc.ServiceException;
import javax.xml.rpc.encoding.TypeMappingRegistry;
import org.apache.axis.AxisEngine;
import org.apache.axis.EngineConfiguration;
import org.apache.axis.client.AxisClient;
import org.apache.axis.client.AxisClientProxy;
import org.apache.axis.client.Call;
import org.apache.axis.configuration.DefaultEngineConfigurationFactory;
import org.apache.axis.utils.JavaUtils;
import org.apache.axis.utils.XMLUtils;
import org.w3c.dom.Document;

public class Service
implements javax.xml.rpc.Service,
Serializable,
Referenceable {
    private transient AxisEngine engine = null;
    private transient EngineConfiguration config = new DefaultEngineConfigurationFactory().getClientEngineConfig();
    private URL wsdlLocation = null;
    private Definition wsdlDefinition = null;
    private javax.wsdl.Service wsdlService = null;
    private boolean maintainSession = false;
    static /* synthetic */ Class class$java$rmi$Remote;

    Definition getWSDLDefinition() {
        return this.wsdlDefinition;
    }

    javax.wsdl.Service getWSDLService() {
        return this.wsdlService;
    }

    protected AxisClient getAxisClient() {
        return new AxisClient(this.config);
    }

    public Service() {
        this.engine = this.getAxisClient();
    }

    public Service(EngineConfiguration engineConfiguration) {
        this.config = engineConfiguration;
        this.engine = this.getAxisClient();
    }

    public Service(URL uRL, javax.xml.rpc.namespace.QName qName) throws ServiceException {
        this.engine = this.getAxisClient();
        this.wsdlLocation = uRL;
        Document document = XMLUtils.newDocument(uRL.toString());
        this.initService(document, qName);
    }

    public Service(String string, javax.xml.rpc.namespace.QName qName) throws ServiceException {
        this.engine = this.getAxisClient();
        try {
            this.wsdlLocation = new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        try {
            FileInputStream fileInputStream = new FileInputStream(string);
            Document document = XMLUtils.newDocument(fileInputStream);
            this.initService(document, qName);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new ServiceException(JavaUtils.getMessage("wsdlError00", "" + string, "\n" + fileNotFoundException));
        }
    }

    public Service(InputStream inputStream, javax.xml.rpc.namespace.QName qName) throws ServiceException {
        this.engine = this.getAxisClient();
        Document document = XMLUtils.newDocument(inputStream);
        this.initService(document, qName);
    }

    private void initService(Document document, javax.xml.rpc.namespace.QName qName) throws ServiceException {
        try {
            Definition definition;
            WSDLReader wSDLReader = WSDLFactory.newInstance().newWSDLReader();
            wSDLReader.setFeature("javax.wsdl.verbose", false);
            this.wsdlDefinition = definition = wSDLReader.readWSDL(null, document);
            String string = qName.getNamespaceURI();
            String string2 = qName.getLocalPart();
            QName qName2 = new QName(string, string2);
            this.wsdlService = definition.getService(qName2);
            if (this.wsdlService == null) {
                throw new ServiceException(JavaUtils.getMessage("noService00", "" + qName));
            }
        }
        catch (Exception exception) {
            throw new ServiceException(JavaUtils.getMessage("wsdlError00", "", "\n" + exception));
        }
    }

    public Remote getPort(javax.xml.rpc.namespace.QName qName, Class clazz) throws ServiceException {
        return null;
    }

    public Remote getPort(Class clazz) throws ServiceException {
        return null;
    }

    public Remote getPort(String string, Class clazz) throws ServiceException {
        if (!clazz.isInterface()) {
            throw new ServiceException(JavaUtils.getMessage("mustBeIface00"));
        }
        if (!(class$java$rmi$Remote == null ? (class$java$rmi$Remote = Service.class$("java.rmi.Remote")) : class$java$rmi$Remote).isAssignableFrom(clazz)) {
            throw new ServiceException(JavaUtils.getMessage("mustExtendRemote00"));
        }
        try {
            Call call = new Call(string);
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            return (Remote)Proxy.newProxyInstance(classLoader, new Class[]{clazz}, (InvocationHandler)new AxisClientProxy(call));
        }
        catch (Exception exception) {
            throw new ServiceException(exception.toString());
        }
    }

    public javax.xml.rpc.Call createCall(javax.xml.rpc.namespace.QName qName) throws ServiceException {
        QName qName2 = new QName(qName.getNamespaceURI(), qName.getLocalPart());
        if (this.wsdlDefinition == null) {
            throw new ServiceException(JavaUtils.getMessage("wsdlMissing00"));
        }
        Port port = this.wsdlService.getPort(qName.getLocalPart());
        if (port == null) {
            throw new ServiceException(JavaUtils.getMessage("noPort00", "" + qName));
        }
        Binding binding = port.getBinding();
        PortType portType = binding.getPortType();
        if (portType == null) {
            throw new ServiceException(JavaUtils.getMessage("noPortType00", "" + qName));
        }
        Call call = new Call(this);
        call.setPortTypeName(qName);
        List list = port.getExtensibilityElements();
        int n = 0;
        while (list != null && n < list.size()) {
            Object e = list.get(n);
            if (e instanceof SOAPAddress) {
                try {
                    SOAPAddress sOAPAddress = (SOAPAddress)e;
                    URL uRL = new URL(sOAPAddress.getLocationURI());
                    call.setTargetEndpointAddress(uRL);
                }
                catch (Exception exception) {
                    throw new ServiceException(JavaUtils.getMessage("cantSetURI00", "" + exception));
                }
            }
            ++n;
        }
        return call;
    }

    public javax.xml.rpc.Call createCall(javax.xml.rpc.namespace.QName qName, String string) throws ServiceException {
        Call call = new Call(this);
        call.setOperation(qName, string);
        return call;
    }

    public javax.xml.rpc.Call createCall(javax.xml.rpc.namespace.QName qName, javax.xml.rpc.namespace.QName qName2) throws ServiceException {
        Call call = new Call(this);
        call.setOperation(qName, qName2.getLocalPart());
        return call;
    }

    public javax.xml.rpc.Call createCall() throws ServiceException {
        return new Call(this);
    }

    public URL getWSDLDocumentLocation() {
        return this.wsdlLocation;
    }

    public javax.xml.rpc.namespace.QName getServiceName() {
        if (this.wsdlService == null) {
            return null;
        }
        QName qName = this.wsdlService.getQName();
        return new javax.xml.rpc.namespace.QName(qName.getNamespaceURI(), qName.getLocalPart());
    }

    public Iterator getPorts() {
        if (this.wsdlService == null) {
            return null;
        }
        Map map = this.wsdlService.getPorts();
        if (map == null) {
            return null;
        }
        Set set = map.keySet();
        Iterator iterator = set.iterator();
        HashSet<Port> hashSet = null;
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            Port port = (Port)map.get(string);
            if (hashSet == null) {
                hashSet = new HashSet<Port>();
            }
            hashSet.add(port);
        }
        if (hashSet == null) {
            return null;
        }
        return hashSet.iterator();
    }

    public void setTypeMappingRegistry(TypeMappingRegistry typeMappingRegistry) throws ServiceException {
    }

    public TypeMappingRegistry getTypeMappingRegistry() {
        return null;
    }

    public Reference getReference() {
        String string = this.getClass().getName();
        Reference reference = new Reference(string, "org.apache.axis.client.ServiceFactory", null);
        StringRefAddr stringRefAddr = null;
        if (!string.equals("org.apache.axis.client.Service")) {
            stringRefAddr = new StringRefAddr("service classname", string);
            reference.add(stringRefAddr);
        } else {
            javax.xml.rpc.namespace.QName qName;
            if (this.wsdlLocation != null) {
                stringRefAddr = new StringRefAddr("WSDL location", this.wsdlLocation.toString());
                reference.add(stringRefAddr);
            }
            if ((qName = this.getServiceName()) != null) {
                stringRefAddr = new StringRefAddr("service namespace", qName.getNamespaceURI());
                reference.add(stringRefAddr);
                stringRefAddr = new StringRefAddr("service local part", qName.getLocalPart());
                reference.add(stringRefAddr);
            }
        }
        if (this.maintainSession) {
            stringRefAddr = new StringRefAddr("maintain session", "true");
            reference.add(stringRefAddr);
        }
        return reference;
    }

    public void setEngine(AxisEngine axisEngine) {
        this.engine = axisEngine;
    }

    public AxisEngine getEngine() {
        return this.engine;
    }

    public void setEngineConfiguration(EngineConfiguration engineConfiguration) {
        this.config = engineConfiguration;
    }

    public void setMaintainSession(boolean bl) {
        this.maintainSession = bl;
    }

    public boolean getMaintainSession() {
        return this.maintainSession;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

