/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.client;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.xml.rpc.ServiceException;
import org.apache.axis.AxisFault;
import org.apache.axis.EngineConfiguration;
import org.apache.axis.client.Call;
import org.apache.axis.client.Service;
import org.apache.axis.message.SOAPBodyElement;
import org.apache.axis.utils.JavaUtils;
import org.apache.axis.utils.Options;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AdminClient {
    protected static Log log = LogFactory.getLog((String)(class$org$apache$axis$client$AdminClient == null ? (class$org$apache$axis$client$AdminClient = AdminClient.class$("org.apache.axis.client.AdminClient")) : class$org$apache$axis$client$AdminClient).getName());
    private static ThreadLocal defaultConfiguration = new ThreadLocal();
    protected Call call;
    static /* synthetic */ Class class$org$apache$axis$client$AdminClient;

    public static void setDefaultConfiguration(EngineConfiguration engineConfiguration) {
        defaultConfiguration.set(engineConfiguration);
    }

    public AdminClient() {
        try {
            EngineConfiguration engineConfiguration = (EngineConfiguration)defaultConfiguration.get();
            Service service = engineConfiguration != null ? new Service(engineConfiguration) : new Service();
            this.call = (Call)service.createCall();
        }
        catch (ServiceException serviceException) {
            log.fatal((Object)JavaUtils.getMessage("couldntCall00"), (Throwable)serviceException);
            this.call = null;
        }
    }

    public Call getCall() {
        return this.call;
    }

    public String list(Options options) throws Exception {
        this.processOpts(options);
        return this.list();
    }

    public String list() throws Exception {
        log.debug((Object)JavaUtils.getMessage("doList00"));
        String string = "<m:list xmlns:m=\"AdminService\"/>";
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.getBytes());
        return this.process(byteArrayInputStream);
    }

    public String quit(Options options) throws Exception {
        this.processOpts(options);
        return this.quit();
    }

    public String quit() throws Exception {
        log.debug((Object)JavaUtils.getMessage("doQuit00"));
        String string = "<m:quit xmlns:m=\"AdminService\"/>";
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.getBytes());
        return this.process(byteArrayInputStream);
    }

    public String undeployHandler(String string) throws Exception {
        log.debug((Object)JavaUtils.getMessage("doQuit00"));
        String string2 = "<m:undeploy xmlns:m=\"AdminService\"><handler name=\"" + string + "\"/>" + "</m:undeploy>";
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string2.getBytes());
        return this.process(byteArrayInputStream);
    }

    public String undeployService(String string) throws Exception {
        log.debug((Object)JavaUtils.getMessage("doQuit00"));
        String string2 = "<m:undeploy xmlns:m=\"AdminService\"><service name=\"" + string + "\"/>" + "</m:undeploy>";
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string2.getBytes());
        return this.process(byteArrayInputStream);
    }

    public String process(String[] stringArray) throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        Options options = new Options(stringArray);
        options.setDefaultURL("http://localhost:8080/axis/services/AdminService");
        if (options.isFlagSet('d') > 0) {
            // empty if block
        }
        if ((stringArray = options.getRemainingArgs()) == null) {
            log.info((Object)JavaUtils.getMessage("usage00", "AdminClient xml-files | list"));
            return null;
        }
        int n = 0;
        while (n < stringArray.length) {
            Object object;
            ByteArrayInputStream byteArrayInputStream = null;
            if (stringArray[n].equals("list")) {
                stringBuffer.append(this.list(options));
            } else if (stringArray[n].equals("quit")) {
                stringBuffer.append(this.quit(options));
            } else if (stringArray[n].equals("passwd")) {
                log.info((Object)JavaUtils.getMessage("changePwd00"));
                if (stringArray[n + 1] == null) {
                    log.error((Object)JavaUtils.getMessage("needPwd00"));
                    return null;
                }
                object = "<m:passwd xmlns:m=\"AdminService\">";
                object = (String)object + stringArray[n + 1];
                object = (String)object + "</m:passwd>";
                byteArrayInputStream = new ByteArrayInputStream(((String)object).getBytes());
                ++n;
                stringBuffer.append(this.process(options, byteArrayInputStream));
            } else if (stringArray[n].indexOf(File.pathSeparatorChar) == -1) {
                log.info((Object)JavaUtils.getMessage("processFile00", stringArray[n]));
                stringBuffer.append(this.process(options, stringArray[n]));
            } else {
                object = null;
                object = new StringTokenizer(stringArray[n], File.pathSeparator);
                while (((StringTokenizer)object).hasMoreTokens()) {
                    String string = ((StringTokenizer)object).nextToken();
                    log.info((Object)JavaUtils.getMessage("processFile00", string));
                    stringBuffer.append(this.process(options, string));
                    if (!((StringTokenizer)object).hasMoreTokens()) continue;
                    stringBuffer.append("\n");
                }
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public void processOpts(Options options) throws Exception {
        if (this.call == null) {
            throw new Exception(JavaUtils.getMessage("nullCall00"));
        }
        this.call.setTargetEndpointAddress(new URL(options.getURL()));
        this.call.setUsername(options.getUser());
        this.call.setPassword(options.getPassword());
        String string = options.isValueSet('t');
        if (string != null && !string.equals("")) {
            this.call.setProperty("transport_name", string);
        }
    }

    public String process(InputStream inputStream) throws Exception {
        return this.process(null, inputStream);
    }

    public String process(URL uRL) throws Exception {
        return this.process(null, uRL.openStream());
    }

    public String process(String string) throws Exception {
        FileInputStream fileInputStream = new FileInputStream(string);
        String string2 = this.process(null, fileInputStream);
        fileInputStream.close();
        return string2;
    }

    public String process(Options options, String string) throws Exception {
        this.processOpts(options);
        return this.process(string);
    }

    public String process(Options options, InputStream inputStream) throws Exception {
        if (this.call == null) {
            throw new Exception(JavaUtils.getMessage("nullCall00"));
        }
        if (options != null) {
            this.processOpts(options);
        }
        this.call.setUseSOAPAction(true);
        this.call.setSOAPActionURI("AdminService");
        Vector vector = null;
        Object[] objectArray = new Object[]{new SOAPBodyElement(inputStream)};
        vector = (Vector)this.call.invoke(objectArray);
        inputStream.close();
        if (vector == null || vector.isEmpty()) {
            throw new AxisFault(JavaUtils.getMessage("nullResponse00"));
        }
        SOAPBodyElement sOAPBodyElement = (SOAPBodyElement)vector.elementAt(0);
        return sOAPBodyElement.toString();
    }

    public static void main(String[] stringArray) {
        try {
            AdminClient adminClient = new AdminClient();
            String string = adminClient.process(stringArray);
            if (string != null) {
                System.out.println(string);
            } else {
                System.exit(1);
            }
        }
        catch (AxisFault axisFault) {
            log.error((Object)JavaUtils.getMessage("axisFault01", axisFault.dumpToString()));
            System.exit(1);
        }
        catch (Exception exception) {
            log.error((Object)JavaUtils.getMessage("exception00"), (Throwable)exception);
            System.exit(1);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

