/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.attachments;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.Header;
import javax.mail.MessagingException;
import javax.mail.internet.ContentType;
import javax.mail.internet.InternetHeaders;
import javax.mail.internet.MimeUtility;
import javax.mail.internet.ParseException;
import org.apache.axis.AxisFault;
import org.apache.axis.Part;
import org.apache.axis.attachments.AttachmentPart;
import org.apache.axis.attachments.BoundaryDelimitedStream;
import org.apache.axis.attachments.ManagedMemoryDataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MultiPartRelatedInputStream
extends FilterInputStream {
    protected static Log log = LogFactory.getLog((String)(class$org$apache$axis$attachments$MultiPartRelatedInputStream == null ? (class$org$apache$axis$attachments$MultiPartRelatedInputStream = MultiPartRelatedInputStream.class$("org.apache.axis.attachments.MultiPartRelatedInputStream")) : class$org$apache$axis$attachments$MultiPartRelatedInputStream).getName());
    public static final String MIME_MULTIPART_RELATED = "multipart/related";
    protected HashMap parts = new HashMap();
    protected LinkedList orderedParts = new LinkedList();
    protected int rootPartLength = 0;
    protected boolean closed = false;
    protected boolean eos = false;
    protected InputStream is = null;
    protected BoundaryDelimitedStream boundaryDelimitedStream = null;
    protected InputStream soapStream = null;
    protected InputStream soapStreamBDS = null;
    protected byte[] boundary = null;
    protected ByteArrayInputStream cachedSOAPEnvelope = null;
    protected String contentLocation = null;
    protected String contentId = null;
    protected static final String[] READ_ALL = new String[]{" * \u0000 ".intern()};
    static /* synthetic */ Class class$org$apache$axis$attachments$MultiPartRelatedInputStream;

    public MultiPartRelatedInputStream(String string, InputStream inputStream) throws AxisFault {
        super(inputStream);
        try {
            this.is = inputStream;
            ContentType contentType = new ContentType(string);
            String string2 = "--" + contentType.getParameter("boundary");
            String string3 = contentType.getParameter("start");
            if (string3 != null) {
                if ((string3 = string3.trim()).startsWith("<")) {
                    string3 = string3.substring(1);
                }
                if (string3.endsWith(">")) {
                    string3 = string3.substring(0, string3.length() - 1);
                }
                if (!string3.startsWith("cid:")) {
                    string3 = "cid:" + string3;
                }
            }
            byte[][] byArray = new byte[2][string2.length() + 2];
            inputStream.read(byArray[0]);
            this.boundary = (string2 + "\r\n").getBytes("US-ASCII");
            int n = 0;
            boolean bl = false;
            while (!bl) {
                bl = Arrays.equals(byArray[n & 1], this.boundary);
                if (!bl) {
                    System.arraycopy(byArray[n & 1], 1, byArray[n + 1 & 1], 0, byArray[0].length - 1);
                    if (inputStream.read(byArray[n + 1 & 1], byArray[0].length - 1, 1) < 1) {
                        throw new AxisFault("Error in MIME data stream start boundary not found expected:\"" + new String(this.boundary));
                    }
                }
                ++n;
            }
            string2 = "\r\n" + string2;
            this.boundary = string2.getBytes("US-ASCII");
            this.boundaryDelimitedStream = new BoundaryDelimitedStream(inputStream, this.boundary, 1024);
            String string4 = null;
            do {
                this.contentId = null;
                string4 = null;
                InternetHeaders internetHeaders = new InternetHeaders((InputStream)this.boundaryDelimitedStream);
                this.contentId = internetHeaders.getHeader("Content-ID", null);
                if (this.contentId != null) {
                    this.contentId = this.contentId.trim();
                    if (this.contentId.startsWith("<")) {
                        this.contentId = this.contentId.substring(1);
                    }
                    if (this.contentId.endsWith(">")) {
                        this.contentId = this.contentId.substring(0, this.contentId.length() - 1);
                    }
                    this.contentId = this.contentId.trim();
                    if (!this.contentId.startsWith("cid:")) {
                        this.contentId = "cid:" + this.contentId;
                    }
                }
                this.contentLocation = internetHeaders.getHeader("Content-Location", null);
                if (this.contentLocation != null) {
                    this.contentLocation = this.contentLocation.trim();
                    if (this.contentLocation.startsWith("<")) {
                        this.contentLocation = this.contentLocation.substring(1);
                    }
                    if (this.contentLocation.endsWith(">")) {
                        this.contentLocation = this.contentLocation.substring(0, this.contentLocation.length() - 1);
                    }
                    this.contentLocation = this.contentLocation.trim();
                }
                if ((string = internetHeaders.getHeader("Content-Type", null)) != null) {
                    string = string.trim();
                }
                if ((string4 = internetHeaders.getHeader("Content-Transfer-Encoding", null)) != null) {
                    string4 = string4.trim();
                }
                InputStream inputStream2 = this.boundaryDelimitedStream;
                if (string4 != null && 0 != string4.length()) {
                    inputStream2 = MimeUtility.decode((InputStream)inputStream2, (String)string4);
                }
                if (string3 == null || string3.equals(this.contentId)) continue;
                DataHandler dataHandler = new DataHandler((DataSource)new ManagedMemoryDataSource(inputStream2, 16384, string, true));
                AttachmentPart attachmentPart = new AttachmentPart(dataHandler);
                if (this.contentId != null) {
                    attachmentPart.addMimeHeader("Content-ID", this.contentId);
                }
                if (this.contentLocation != null) {
                    attachmentPart.addMimeHeader("Content-Location", this.contentLocation);
                }
                Enumeration enumeration = internetHeaders.getNonMatchingHeaders(new String[]{"Content-ID", "Content-Location", "Content-Type"});
                while (enumeration.hasMoreElements()) {
                    Header header = (Header)enumeration.nextElement();
                    String string5 = header.getName();
                    String string6 = header.getValue();
                    if (string5 == null || string6 == null || (string5 = string5.trim()).length() == 0) continue;
                    attachmentPart.addMimeHeader(string5, string6);
                }
                this.addPart(this.contentId, this.contentLocation, attachmentPart);
                this.boundaryDelimitedStream = this.boundaryDelimitedStream.getNextStream();
            } while (null != this.boundaryDelimitedStream && string3 != null && !string3.equals(this.contentId));
            if (this.boundaryDelimitedStream == null) {
                throw new AxisFault("Root part containing SOAP envelope not found.  contentId=" + string3);
            }
            this.soapStreamBDS = this.boundaryDelimitedStream;
            this.soapStream = string4 != null && 0 != string4.length() ? MimeUtility.decode((InputStream)this.boundaryDelimitedStream, (String)string4) : this.boundaryDelimitedStream;
        }
        catch (ParseException parseException) {
            throw new AxisFault("Error in parsing mime data stream " + parseException.getMessage());
        }
        catch (IOException iOException) {
            throw new AxisFault("Error in reading data stream " + iOException.getMessage());
        }
        catch (MessagingException messagingException) {
            throw new AxisFault("Error in reading data stream " + messagingException.getMessage());
        }
    }

    public Part getAttachmentByReference(String[] stringArray) throws AxisFault {
        Part part = null;
        int n = stringArray.length - 1;
        while (part == null && n > -1) {
            part = (AttachmentPart)this.parts.get(stringArray[n]);
            --n;
        }
        if (null == part) {
            part = this.readTillFound(stringArray);
        }
        log.debug((Object)("getAttachmentByReference(\"" + stringArray + "\") returns" + (part == null ? "null" : part.toString())));
        return part;
    }

    protected void addPart(String string, String string2, AttachmentPart attachmentPart) {
        if (string != null && string.trim().length() != 0) {
            this.parts.put(string, attachmentPart);
        }
        if (string2 != null && string2.trim().length() != 0) {
            this.parts.put(string2, attachmentPart);
        }
        this.orderedParts.add(attachmentPart);
    }

    protected void readAll() throws AxisFault {
        this.readTillFound(READ_ALL);
    }

    public Collection getAttachments() throws AxisFault {
        this.readAll();
        return this.orderedParts;
    }

    protected Part readTillFound(String[] stringArray) throws AxisFault {
        if (this.boundaryDelimitedStream == null) {
            return null;
        }
        AttachmentPart attachmentPart = null;
        try {
            Object object;
            Object object2;
            if (this.soapStreamBDS == this.boundaryDelimitedStream) {
                if (!this.eos) {
                    object2 = new ByteArrayOutputStream(8192);
                    object = new byte[16384];
                    int n = 0;
                    do {
                        if ((n = this.soapStream.read((byte[])object)) <= 0) continue;
                        ((ByteArrayOutputStream)object2).write((byte[])object, 0, n);
                    } while (n > -1);
                    ((ByteArrayOutputStream)object2).close();
                    this.soapStream = new ByteArrayInputStream(((ByteArrayOutputStream)object2).toByteArray());
                }
                this.boundaryDelimitedStream = this.boundaryDelimitedStream.getNextStream();
            }
            do {
                object2 = null;
                object = null;
                String string = null;
                String string2 = null;
                InternetHeaders internetHeaders = new InternetHeaders((InputStream)this.boundaryDelimitedStream);
                object = internetHeaders.getHeader("Content-ID", null);
                if (object != null) {
                    if (((String)(object = ((String)object).trim())).startsWith("<")) {
                        object = ((String)object).substring(1);
                    }
                    if (((String)object).endsWith(">")) {
                        object = ((String)object).substring(0, ((String)object).length() - 1);
                    }
                    if (!((String)object).startsWith("cid:")) {
                        object = "cid:" + (String)object;
                    }
                    object = ((String)object).trim();
                }
                if ((object2 = internetHeaders.getHeader("Content-Type", null)) != null) {
                    object2 = ((String)object2).trim();
                }
                if ((string2 = internetHeaders.getHeader("Content-Location", null)) != null) {
                    string2 = string2.trim();
                }
                if ((string = internetHeaders.getHeader("Content-Transfer-Encoding", null)) != null) {
                    string = string.trim();
                }
                InputStream inputStream = this.boundaryDelimitedStream;
                if (string != null && 0 != string.length()) {
                    inputStream = MimeUtility.decode((InputStream)inputStream, (String)string);
                }
                DataHandler dataHandler = new DataHandler((DataSource)new ManagedMemoryDataSource(inputStream, 1024, (String)object2, true));
                AttachmentPart attachmentPart2 = new AttachmentPart(dataHandler);
                if (object != null) {
                    attachmentPart2.addMimeHeader("Content-ID", (String)object);
                }
                if (string2 != null) {
                    attachmentPart2.addMimeHeader("Content-Location", string2);
                }
                Enumeration enumeration = internetHeaders.getNonMatchingHeaders(new String[]{"Content-ID", "Content-Location", "Content-Type"});
                while (enumeration.hasMoreElements()) {
                    Header header = (Header)enumeration.nextElement();
                    String string3 = header.getName();
                    String string4 = header.getValue();
                    if (string3 == null || string4 == null || (string3 = string3.trim()).length() == 0) continue;
                    attachmentPart2.addMimeHeader(string3, string4);
                }
                this.addPart((String)object, string2, attachmentPart2);
                int n = stringArray.length - 1;
                while (attachmentPart == null && n > -1) {
                    if (object != null && stringArray[n].equals(object)) {
                        attachmentPart = attachmentPart2;
                    } else if (string2 != null && stringArray[n].equals(string2)) {
                        attachmentPart = attachmentPart2;
                    }
                    --n;
                }
                this.boundaryDelimitedStream = this.boundaryDelimitedStream.getNextStream();
            } while (null == attachmentPart && null != this.boundaryDelimitedStream);
        }
        catch (Exception exception) {
            throw AxisFault.makeFault(exception);
        }
        return attachmentPart;
    }

    public String getContentLocation() {
        return this.contentLocation;
    }

    public String getContentId() {
        return this.contentId;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (this.closed) {
            throw new IOException("Stream closed.");
        }
        if (this.eos) {
            return -1;
        }
        int n3 = this.soapStream.read(byArray, n, n2);
        if (n3 < 0) {
            this.eos = true;
        }
        return n3;
    }

    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    public int read() throws IOException {
        if (this.closed) {
            throw new IOException("Stream closed.");
        }
        if (this.eos) {
            return -1;
        }
        int n = this.soapStream.read();
        if (n < 0) {
            this.eos = true;
        }
        return n;
    }

    public void close() throws IOException {
        this.closed = true;
        this.soapStream.close();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

