/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.attachments;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.StringTokenizer;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.Multipart;
import javax.mail.internet.MimeMultipart;
import org.apache.axis.AxisFault;
import org.apache.axis.Part;
import org.apache.axis.SOAPPart;
import org.apache.axis.attachments.AttachmentPart;
import org.apache.axis.attachments.AttachmentUtils;
import org.apache.axis.attachments.Attachments;
import org.apache.axis.attachments.ManagedMemoryDataSource;
import org.apache.axis.attachments.MimeUtils;
import org.apache.axis.attachments.MultiPartRelatedInputStream;

public class AttachmentsImpl
implements Attachments {
    private HashMap attachments = new HashMap();
    private LinkedList orderedAttachments = new LinkedList();
    protected SOAPPart soapPart = null;
    protected MultiPartRelatedInputStream mpartStream = null;
    protected String contentLocation = null;
    public MimeMultipart multipart = null;
    static /* synthetic */ Class class$javax$activation$DataHandler;

    public AttachmentsImpl(Object object, String string, String string2) throws AxisFault {
        StringTokenizer stringTokenizer;
        if (string2 != null && (string2 = string2.trim()).length() == 0) {
            string2 = null;
        }
        this.contentLocation = string2;
        if (string != null && !string.equals("  ") && (stringTokenizer = new StringTokenizer(string, " \t;")).hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            if (string3.equalsIgnoreCase("multipart/related")) {
                this.mpartStream = new MultiPartRelatedInputStream(string, (InputStream)object);
                if (null == string2 && (string2 = this.mpartStream.getContentLocation()) != null && (string2 = string2.trim()).length() == 0) {
                    string2 = null;
                }
                this.soapPart = new SOAPPart(null, this.mpartStream, false);
            } else if (string3.equalsIgnoreCase("application/dime")) {
                // empty if block
            }
        }
    }

    private void mergeinAttachments() throws AxisFault {
        if (this.mpartStream != null) {
            Collection collection = this.mpartStream.getAttachments();
            this.mpartStream = null;
            this.setAttachmentParts(collection);
        }
    }

    public Part removeAttachmentPart(String string) throws AxisFault {
        this.mergeinAttachments();
        Part part = this.getAttachmentByReference(string);
        if (part != null) {
            this.attachments.remove(part.getContentId());
            this.attachments.remove(part.getContentLocation());
            this.orderedAttachments.remove(part);
        }
        return part;
    }

    public Part addAttachmentPart(Part part) throws AxisFault {
        this.mergeinAttachments();
        Part part2 = this.attachments.put(part.getContentId(), part);
        if (part2 != null) {
            this.orderedAttachments.remove(part2);
            this.attachments.remove(part2.getContentLocation());
        }
        this.orderedAttachments.add(part);
        if (part.getContentLocation() != null) {
            this.attachments.put(part.getContentLocation(), part);
        }
        return part2;
    }

    public Part createAttachmentPart(Object object) throws AxisFault {
        this.mergeinAttachments();
        if (!(object instanceof DataHandler)) {
            throw new AxisFault("Unsupported attachment type \"" + object.getClass().getName() + "\" only supporting \"" + (class$javax$activation$DataHandler == null ? (class$javax$activation$DataHandler = AttachmentsImpl.class$("javax.activation.DataHandler")) : class$javax$activation$DataHandler).getName() + "\".");
        }
        AttachmentPart attachmentPart = new AttachmentPart((DataHandler)object);
        this.addAttachmentPart(attachmentPart);
        return attachmentPart;
    }

    public void setAttachmentParts(Collection collection) throws AxisFault {
        this.mergeinAttachments();
        this.attachments.clear();
        this.orderedAttachments.clear();
        if (collection != null && !collection.isEmpty()) {
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                Part part = (Part)iterator.next();
                if (null == part) continue;
                this.addAttachmentPart(part);
            }
        }
    }

    public Part getAttachmentByReference(String string) throws AxisFault {
        this.mergeinAttachments();
        if (null == string) {
            return null;
        }
        if (0 == (string = string.trim()).length()) {
            return null;
        }
        Part part = (Part)this.attachments.get(string);
        if (part != null) {
            return part;
        }
        String string2 = string.toLowerCase();
        if (!string2.startsWith("cid:") && null != this.contentLocation) {
            String string3 = this.contentLocation;
            if (!string3.endsWith("/")) {
                string3 = string3 + "/";
            }
            string3 = string.startsWith("/") ? string3 + string.substring(1) : string3 + string;
            part = (AttachmentPart)this.attachments.get(string3);
        }
        return part;
    }

    public Collection getAttachments() throws AxisFault {
        this.mergeinAttachments();
        return new LinkedList(this.orderedAttachments);
    }

    public Part getRootPart() {
        return this.soapPart;
    }

    public void setRootPart(Part part) {
        try {
            this.soapPart = (SOAPPart)part;
        }
        catch (ClassCastException classCastException) {
            throw new ClassCastException("This attachment implementation accepts only SOAPPart objects as root part.");
        }
    }

    public int getContentLength() throws AxisFault {
        this.mergeinAttachments();
        try {
            return (int)MimeUtils.getContentLength((Multipart)(this.multipart != null ? this.multipart : (this.multipart = MimeUtils.createMP(this.soapPart.getAsString(), this.orderedAttachments))));
        }
        catch (Exception exception) {
            throw AxisFault.makeFault(exception);
        }
    }

    public void writeContentToStream(OutputStream outputStream) throws AxisFault {
        this.mergeinAttachments();
        MimeUtils.writeToMultiPartStream(outputStream, this.multipart != null ? this.multipart : (this.multipart = MimeUtils.createMP(this.soapPart.getAsString(), this.orderedAttachments)));
        Iterator iterator = this.orderedAttachments.iterator();
        while (iterator.hasNext()) {
            AttachmentPart attachmentPart = (AttachmentPart)iterator.next();
            DataHandler dataHandler = AttachmentUtils.getActiviationDataHandler(attachmentPart);
            DataSource dataSource = dataHandler.getDataSource();
            if (dataSource == null || !(dataSource instanceof ManagedMemoryDataSource)) continue;
            ((ManagedMemoryDataSource)dataSource).delete();
        }
    }

    public String getContentType() throws AxisFault {
        this.mergeinAttachments();
        return MimeUtils.getContentType(this.multipart != null ? this.multipart : (this.multipart = MimeUtils.createMP(this.soapPart.getAsString(), this.orderedAttachments)));
    }

    public int getAttachmentCount() {
        try {
            this.mergeinAttachments();
            return this.orderedAttachments.size();
        }
        catch (AxisFault axisFault) {
            return 0;
        }
    }

    public boolean isAttachment(Object object) {
        return AttachmentUtils.isAttachment(object);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

