/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import org.apache.axis.AxisFault;
import org.apache.axis.Message;
import org.apache.axis.Part;
import org.apache.axis.encoding.DeserializationContextImpl;
import org.apache.axis.encoding.SerializationContextImpl;
import org.apache.axis.message.InputStreamBody;
import org.apache.axis.message.SOAPEnvelope;
import org.apache.axis.utils.JavaUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class SOAPPart
extends Part {
    protected static Log log = LogFactory.getLog((String)(class$org$apache$axis$SOAPPart == null ? (class$org$apache$axis$SOAPPart = SOAPPart.class$("org.apache.axis.SOAPPart")) : class$org$apache$axis$SOAPPart).getName());
    private static final int FORM_STRING = 1;
    private static final int FORM_INPUTSTREAM = 2;
    private static final int FORM_SOAPENVELOPE = 3;
    private static final int FORM_BYTES = 4;
    private static final int FORM_BODYINSTREAM = 5;
    private static final int FORM_FAULT = 6;
    private int currentForm;
    private static final String[] formNames = new String[]{"", "FORM_STRING", "FORM_INPUTSTREAM", "FORM_SOAPENVELOPE", "FORM_BYTES", "FORM_BODYINSTREAM", "FORM_FAULT"};
    private Object currentMessage;
    private Message msgObject;
    private Object originalMessage;
    static /* synthetic */ Class class$org$apache$axis$SOAPPart;

    public SOAPPart(Message message, Object object, boolean bl) {
        this.msgObject = message;
        this.originalMessage = object;
        int n = 1;
        if (object instanceof SOAPEnvelope) {
            n = 3;
        } else if (object instanceof InputStream) {
            n = bl ? 5 : 2;
        } else if (object instanceof byte[]) {
            n = 4;
        } else if (object instanceof AxisFault) {
            n = 6;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Enter SOAPPart ctor (" + formNames[n] + ")"));
        }
        this.setCurrentMessage(object, n);
    }

    public Message getMessage() {
        return this.msgObject;
    }

    public void setMessage(Message message) {
        this.msgObject = message;
    }

    public String getContentType() {
        return "text/xml";
    }

    public int getContentLength() {
        byte[] byArray = this.getAsBytes();
        return byArray.length;
    }

    public void setSOAPEnvelope(SOAPEnvelope sOAPEnvelope) {
        this.setCurrentMessage(sOAPEnvelope, 3);
    }

    public int getSize() {
        return this.getContentLength();
    }

    public void writeTo(OutputStream outputStream) throws IOException {
        outputStream.write(this.getAsBytes());
    }

    public Object getCurrentMessage() {
        return this.currentMessage;
    }

    private void setCurrentMessage(Object object, int n) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Setting current message form to: " + formNames[n] + " (currentMessage is now " + object + ")"));
        }
        this.currentMessage = object;
        this.currentForm = n;
    }

    public byte[] getAsBytes() {
        log.debug((Object)"Enter: SOAPPart::getAsBytes");
        if (this.currentForm == 4) {
            log.debug((Object)"Exit: SOAPPart::getAsBytes");
            return (byte[])this.currentMessage;
        }
        if (this.currentForm == 5) {
            try {
                this.getAsSOAPEnvelope();
            }
            catch (Exception exception) {
                log.fatal((Object)JavaUtils.getMessage("makeEnvFail00"), (Throwable)exception);
                return null;
            }
        }
        if (this.currentForm == 2) {
            try {
                int n;
                InputStream inputStream = (InputStream)this.currentMessage;
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                byte[] byArray = new byte[4096];
                while ((n = inputStream.read(byArray, 0, 4096)) != -1) {
                    byteArrayOutputStream.write(byArray, 0, n);
                }
                byArray = byteArrayOutputStream.toByteArray();
                this.setCurrentMessage(byArray, 4);
                log.debug((Object)"Exit: SOAPPart::getAsByes");
                return (byte[])this.currentMessage;
            }
            catch (Exception exception) {
                log.error((Object)JavaUtils.getMessage("exception00"), (Throwable)exception);
                log.debug((Object)"Exit: SOAPPart::getAsByes");
                return null;
            }
        }
        if (this.currentForm == 3 || this.currentForm == 6) {
            try {
                return this.getAsString().getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                return this.getAsString().getBytes();
            }
        }
        if (this.currentForm == 1) {
            try {
                this.setCurrentMessage(((String)this.currentMessage).getBytes("UTF-8"), 4);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                this.setCurrentMessage(((String)this.currentMessage).getBytes(), 4);
            }
            log.debug((Object)"Exit: SOAPPart::getAsBytes");
            return (byte[])this.currentMessage;
        }
        log.error((Object)JavaUtils.getMessage("cantConvert00", "" + this.currentForm));
        log.debug((Object)"Exit: SOAPPart::getAsBytes");
        return null;
    }

    public String getAsString() {
        log.debug((Object)"Enter: SOAPPart::getAsString");
        if (this.currentForm == 1) {
            log.debug((Object)("Exit: SOAPPart::getAsString, currentMessage is " + this.currentMessage));
            return (String)this.currentMessage;
        }
        if (this.currentForm == 2 || this.currentForm == 5) {
            this.getAsBytes();
        }
        if (this.currentForm == 4) {
            try {
                this.setCurrentMessage(new String((byte[])this.currentMessage, "UTF-8"), 1);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                this.setCurrentMessage(new String((byte[])this.currentMessage), 1);
            }
            log.debug((Object)("Exit: SOAPPart::getAsString, currentMessage is " + this.currentMessage));
            return (String)this.currentMessage;
        }
        if (this.currentForm == 6) {
            StringWriter stringWriter = new StringWriter();
            AxisFault axisFault = (AxisFault)this.currentMessage;
            try {
                axisFault.output(new SerializationContextImpl(stringWriter, this.getMessage().getMessageContext()));
            }
            catch (Exception exception) {
                log.error((Object)JavaUtils.getMessage("exception00"), (Throwable)exception);
                return null;
            }
            this.setCurrentMessage(stringWriter.getBuffer().toString(), 1);
            return (String)this.currentMessage;
        }
        if (this.currentForm == 3) {
            StringWriter stringWriter = new StringWriter();
            SOAPEnvelope sOAPEnvelope = (SOAPEnvelope)this.currentMessage;
            try {
                sOAPEnvelope.output(new SerializationContextImpl(stringWriter, this.getMessage().getMessageContext()));
            }
            catch (Exception exception) {
                AxisFault axisFault = AxisFault.makeFault(exception);
                stringWriter = new StringWriter();
                try {
                    axisFault.output(new SerializationContextImpl(stringWriter, this.getMessage().getMessageContext()));
                }
                catch (Exception exception2) {
                    return null;
                }
            }
            this.setCurrentMessage(stringWriter.getBuffer().toString(), 1);
            return (String)this.currentMessage;
        }
        log.error((Object)JavaUtils.getMessage("cantConvert01", "" + this.currentForm));
        log.debug((Object)"Exit: SOAPPart::getAsString");
        return null;
    }

    public SOAPEnvelope getAsSOAPEnvelope() throws AxisFault {
        log.debug((Object)("Enter: SOAPPart::getAsSOAPEnvelope; currentForm is " + formNames[this.currentForm]));
        if (this.currentForm == 3) {
            return (SOAPEnvelope)this.currentMessage;
        }
        if (this.currentForm == 5) {
            InputStreamBody inputStreamBody = new InputStreamBody((InputStream)this.currentMessage);
            SOAPEnvelope sOAPEnvelope = new SOAPEnvelope();
            sOAPEnvelope.addBodyElement(inputStreamBody);
            this.setCurrentMessage(sOAPEnvelope, 3);
            return sOAPEnvelope;
        }
        InputSource inputSource = this.currentForm == 2 ? new InputSource((InputStream)this.currentMessage) : new InputSource(new StringReader(this.getAsString()));
        DeserializationContextImpl deserializationContextImpl = new DeserializationContextImpl(inputSource, this.getMessage().getMessageContext(), this.getMessage().getMessageType());
        try {
            deserializationContextImpl.parse();
        }
        catch (SAXException sAXException) {
            Exception exception = sAXException.getException();
            if (exception == null) {
                exception = sAXException;
            }
            throw AxisFault.makeFault(exception);
        }
        this.setCurrentMessage(deserializationContextImpl.getEnvelope(), 3);
        log.debug((Object)"Exit: SOAPPart::getAsSOAPEnvelope");
        return (SOAPEnvelope)this.currentMessage;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

