/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import org.apache.axis.utils.JavaUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class Part {
    protected static Log log = LogFactory.getLog((String)(class$org$apache$axis$Part == null ? (class$org$apache$axis$Part = Part.class$("org.apache.axis.Part")) : class$org$apache$axis$Part).getName());
    private Hashtable headers = new Hashtable();
    private String contentId;
    private String contentLocation;
    static String thisHost = null;
    private static int count = (int)(Math.random() * 100.0);
    static /* synthetic */ Class class$org$apache$axis$Part;

    public Part() {
        this.addMimeHeader("Content-ID", Part.getNewContentIdValue());
    }

    public void addMimeHeader(String string, String string2) {
        if (null == string) {
            throw new IllegalArgumentException("Header may not be null!");
        }
        if ((string = string.trim()).length() == 0) {
            throw new IllegalArgumentException("Header may not be empty!");
        }
        if (null == string2) {
            throw new IllegalArgumentException("Header value may not be null!");
        }
        this.headers.put(string.toLowerCase(), string2);
    }

    public String getMimeHeader(String string) {
        return (String)this.headers.get(string.toLowerCase());
    }

    public String getContentLocation() {
        return this.getMimeHeader("Content-Location");
    }

    public void setContentLocation(String string) {
        this.addMimeHeader("Content-Location", string);
    }

    public void setContentId(String string) {
        if (!string.toLowerCase().startsWith("cid:")) {
            string = "cid:" + string;
        }
        this.addMimeHeader("Content-ID", string);
    }

    public String getContentId() {
        String string = this.getMimeHeader("Content-ID");
        if (string == null) {
            string = Part.getNewContentIdValue();
            this.addMimeHeader("Content-ID", string);
        }
        if ((string = string.trim()).length() == 0) {
            string = Part.getNewContentIdValue();
            this.addMimeHeader("Content-ID", string);
        }
        return string;
    }

    public Iterator getMatchingMimeHeaders(String[] stringArray) {
        LinkedList<String> linkedList = new LinkedList<String>();
        if (null != stringArray && 0 != stringArray.length) {
            int n = stringArray.length - 1;
            while (n > -1) {
                String string;
                if (stringArray[n] != null && this.headers.containsKey(string = stringArray[n].toLowerCase())) {
                    linkedList.add(stringArray[n]);
                }
                --n;
            }
        }
        return linkedList.iterator();
    }

    public Iterator getNonMatchingMimeHeaders(String[] stringArray) {
        LinkedList linkedList = new LinkedList(this.headers.keySet());
        if (null != stringArray && 0 != stringArray.length && !this.headers.isEmpty()) {
            int n = stringArray.length - 1;
            while (n > -1) {
                String string;
                if (stringArray[n] != null && this.headers.containsKey(string = stringArray[n].toLowerCase())) {
                    linkedList.remove(string);
                }
                --n;
            }
        }
        return linkedList.iterator();
    }

    public abstract String getContentType();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getNewContentIdValue() {
        int n;
        Class clazz = class$org$apache$axis$Part == null ? (class$org$apache$axis$Part = Part.class$("org.apache.axis.Part")) : class$org$apache$axis$Part;
        synchronized (clazz) {
            n = ++count;
        }
        if (null == thisHost) {
            try {
                thisHost = InetAddress.getLocalHost().getHostName();
            }
            catch (UnknownHostException unknownHostException) {
                log.error((Object)JavaUtils.getMessage("javaNetUnknownHostException00"), (Throwable)unknownHostException);
                thisHost = "localhost";
            }
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("cid:").append(n).append(stringBuffer.hashCode()).append('.').append(System.currentTimeMillis()).append(".AXIS@").append(thisHost);
        return stringBuffer.toString();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

