/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis;

import java.io.File;
import java.util.Hashtable;
import org.apache.axis.AxisEngine;
import org.apache.axis.AxisFault;
import org.apache.axis.Message;
import org.apache.axis.client.AxisClient;
import org.apache.axis.encoding.TypeMappingRegistry;
import org.apache.axis.handlers.soap.SOAPService;
import org.apache.axis.session.Session;
import org.apache.axis.utils.JavaUtils;
import org.apache.axis.utils.LockableHashtable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MessageContext {
    protected static Log log = LogFactory.getLog((String)(class$org$apache$axis$MessageContext == null ? (class$org$apache$axis$MessageContext = MessageContext.class$("org.apache.axis.MessageContext")) : class$org$apache$axis$MessageContext).getName());
    private Message requestMessage;
    private Message responseMessage;
    private String targetService;
    private String transportName;
    private ClassLoader classLoader;
    private AxisEngine axisEngine;
    private Session session;
    private boolean maintainSession = false;
    private boolean havePassedPivot = false;
    private int timeout = 0;
    private LockableHashtable bag;
    private String username = null;
    private String password = null;
    private int operationStyle = 0;
    private boolean useSOAPAction = false;
    private String SOAPActionURI = null;
    private String encodingStyle = "http://schemas.xmlsoap.org/soap/encoding/";
    private boolean isEncoded = true;
    protected static String systemTempDir = null;
    private TypeMappingRegistry mappingRegistry = null;
    private SOAPService serviceHandler;
    public static String ENGINE_HANDLER;
    public static String TRANS_URL;
    public static String QUIT_REQUESTED;
    public static String AUTHUSER;
    public static String ISRPC;
    public static String CALL;
    public static String ATTACHMENTS_DIR;
    static /* synthetic */ Class class$org$apache$axis$MessageContext;

    public static MessageContext getCurrentContext() {
        return AxisEngine.getCurrentMessageContext();
    }

    public MessageContext(AxisEngine axisEngine) {
        this.axisEngine = axisEngine;
        if (null != axisEngine) {
            Hashtable hashtable = axisEngine.getOptions();
            String string = null;
            if (null != hashtable) {
                string = (String)hashtable.get("attachments.Directory");
            }
            if (null == string) {
                string = systemTempDir;
            }
            if (string != null) {
                this.setProperty(ATTACHMENTS_DIR, string);
            }
        }
    }

    public void setTypeMappingRegistry(TypeMappingRegistry typeMappingRegistry) {
        this.mappingRegistry = typeMappingRegistry;
    }

    public TypeMappingRegistry getTypeMappingRegistry() {
        if (this.mappingRegistry == null) {
            return this.axisEngine.getTypeMappingRegistry();
        }
        return this.mappingRegistry;
    }

    public String getTransportName() {
        return this.transportName;
    }

    public void setTransportName(String string) {
        this.transportName = string;
    }

    public Session getSession() {
        return this.session;
    }

    public void setSession(Session session) {
        this.session = session;
    }

    public boolean isEncoded() {
        return "http://schemas.xmlsoap.org/soap/encoding/".equals(this.encodingStyle);
    }

    public void setMaintainSession(boolean bl) {
        this.maintainSession = bl;
    }

    public boolean getMaintainSession() {
        return this.maintainSession;
    }

    public Message getRequestMessage() {
        return this.requestMessage;
    }

    public void setRequestMessage(Message message) {
        this.requestMessage = message;
        if (this.requestMessage != null) {
            this.requestMessage.setMessageContext(this);
        }
    }

    public Message getResponseMessage() {
        return this.responseMessage;
    }

    public void setResponseMessage(Message message) {
        this.responseMessage = message;
        if (this.responseMessage != null) {
            this.responseMessage.setMessageContext(this);
        }
    }

    public Message getCurrentMessage() {
        return this.havePassedPivot ? this.responseMessage : this.requestMessage;
    }

    public void setCurrentMessage(Message message) {
        message.setMessageContext(this);
        if (this.havePassedPivot) {
            this.responseMessage = message;
        } else {
            this.requestMessage = message;
        }
    }

    public boolean getPastPivot() {
        return this.havePassedPivot;
    }

    public void setPastPivot(boolean bl) {
        this.havePassedPivot = bl;
    }

    public void setTimeout(int n) {
        this.timeout = n;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public ClassLoader getClassLoader() {
        if (this.classLoader == null) {
            this.classLoader = Thread.currentThread().getContextClassLoader();
        }
        return this.classLoader;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public String getTargetService() {
        return this.targetService;
    }

    public AxisEngine getAxisEngine() {
        return this.axisEngine;
    }

    public void setTargetService(String string) throws AxisFault {
        block4: {
            log.debug((Object)("MessageContext: setTargetService(" + string + ")"));
            this.targetService = string;
            if (this.targetService == null) {
                this.setService(null);
            } else {
                try {
                    this.setService(this.getAxisEngine().getService(string));
                }
                catch (AxisFault axisFault) {
                    if (this.isClient()) break block4;
                    throw axisFault;
                }
            }
        }
    }

    public SOAPService getService() {
        return this.serviceHandler;
    }

    public void setService(SOAPService sOAPService) {
        log.debug((Object)("MessageContext: setServiceHandler(" + sOAPService + ")"));
        this.serviceHandler = sOAPService;
        if (sOAPService != null && sOAPService instanceof SOAPService) {
            SOAPService sOAPService2 = sOAPService;
            TypeMappingRegistry typeMappingRegistry = sOAPService2.getTypeMappingRegistry();
            this.setTypeMappingRegistry(typeMappingRegistry);
            this.setProperty(ISRPC, new Boolean(sOAPService2.isRPC()));
            this.setOperationStyle(sOAPService2.getStyle());
            this.setEncodingStyle(sOAPService2.getStyle() == 0 ? "http://schemas.xmlsoap.org/soap/encoding/" : "");
        }
    }

    public boolean isClient() {
        return this.axisEngine instanceof AxisClient;
    }

    public String getStrProp(String string) {
        return (String)this.getProperty(string);
    }

    public boolean isPropertyTrue(String string) {
        Object object = this.getProperty(string);
        if (object == null) {
            return false;
        }
        if (object instanceof Boolean) {
            Boolean bl = (Boolean)object;
            return bl;
        }
        if (object instanceof Integer) {
            Integer n = (Integer)object;
            return n != 0;
        }
        if (object instanceof String) {
            String string2 = (String)object;
            return !string2.equalsIgnoreCase("false") && !string2.equalsIgnoreCase("no");
        }
        return true;
    }

    public boolean isPropertyTrue(String string, boolean bl) {
        Object object = this.getProperty(string);
        if (object == null) {
            return bl;
        }
        if (object instanceof Boolean) {
            Boolean bl2 = (Boolean)object;
            return bl2;
        }
        if (object instanceof Integer) {
            Integer n = (Integer)object;
            return n != 0;
        }
        if (object instanceof String) {
            String string2 = (String)object;
            return !string2.equalsIgnoreCase("false") && !string2.equalsIgnoreCase("no");
        }
        return true;
    }

    public void setProperty(String string, Object object) {
        if (string == null || object == null) {
            return;
        }
        if (string.equals("javax.xml.rpc.security.auth.username")) {
            if (!(object instanceof String)) {
                throw new IllegalArgumentException(JavaUtils.getMessage("badProp00", new String[]{string, "java.lang.String", object.getClass().getName()}));
            }
            this.setUsername((String)object);
        } else if (string.equals("javax.xml.rpc.security.auth.password")) {
            if (!(object instanceof String)) {
                throw new IllegalArgumentException(JavaUtils.getMessage("badProp00", new String[]{string, "java.lang.String", object.getClass().getName()}));
            }
            this.setPassword((String)object);
        } else if (string.equals("javax.xml.rpc.http.session.maintain")) {
            if (!(object instanceof Boolean)) {
                throw new IllegalArgumentException(JavaUtils.getMessage("badProp00", new String[]{string, "java.lang.Boolean", object.getClass().getName()}));
            }
            this.setMaintainSession((Boolean)object);
        } else if (string.equals("javax.xml.rpc.soap.operation.style")) {
            if (!(object instanceof String)) {
                throw new IllegalArgumentException(JavaUtils.getMessage("badProp00", new String[]{string, "java.lang.String", object.getClass().getName()}));
            }
            this.setOperationStyle(MessageContext.getStyleFromString((String)object));
        } else if (string.equals("javax.xml.rpc.soap.http.soapaction.use")) {
            if (!(object instanceof Boolean)) {
                throw new IllegalArgumentException(JavaUtils.getMessage("badProp00", new String[]{string, "java.lang.Boolean", object.getClass().getName()}));
            }
            this.setUseSOAPAction((Boolean)object);
        } else if (string.equals("javax.xml.rpc.soap.http.soapaction.uri")) {
            if (!(object instanceof String)) {
                throw new IllegalArgumentException(JavaUtils.getMessage("badProp00", new String[]{string, "java.lang.String", object.getClass().getName()}));
            }
            this.setSOAPActionURI((String)object);
        } else if (string.equals("javax.xml.rpc.encodingstyle.namespace.uri")) {
            if (!(object instanceof String)) {
                throw new IllegalArgumentException(JavaUtils.getMessage("badProp00", new String[]{string, "java.lang.String", object.getClass().getName()}));
            }
            this.setEncodingStyle((String)object);
        } else {
            if (this.bag == null) {
                this.bag = new LockableHashtable();
            }
            this.bag.put(string, object);
        }
    }

    public Object getProperty(String string) {
        if (string != null) {
            if (string.equals("javax.xml.rpc.security.auth.username")) {
                return this.getUsername();
            }
            if (string.equals("javax.xml.rpc.security.auth.password")) {
                return this.getPassword();
            }
            if (string.equals("javax.xml.rpc.http.session.maintain")) {
                return new Boolean(this.getMaintainSession());
            }
            if (string.equals("javax.xml.rpc.soap.operation.style")) {
                return MessageContext.getStyleFromInt(this.getOperationStyle());
            }
            if (string.equals("javax.xml.rpc.soap.http.soapaction.use")) {
                return new Boolean(this.useSOAPAction());
            }
            if (string.equals("javax.xml.rpc.soap.http.soapaction.uri")) {
                return this.getSOAPActionURI();
            }
            if (string.equals("javax.xml.rpc.encodingstyle.namespace.uri")) {
                return this.getEncodingStyle();
            }
            if (this.bag == null) {
                return null;
            }
            return this.bag.get(string);
        }
        return null;
    }

    public void setPropertyParent(Hashtable hashtable) {
        this.bag.setParent(hashtable);
    }

    public void setUsername(String string) {
        this.username = string;
    }

    public String getUsername() {
        return this.username;
    }

    public void setPassword(String string) {
        this.password = string;
    }

    public String getPassword() {
        return this.password;
    }

    public void setOperationStyle(int n) {
        this.operationStyle = n;
    }

    public int getOperationStyle() {
        return this.operationStyle;
    }

    public void setUseSOAPAction(boolean bl) {
        this.useSOAPAction = bl;
    }

    public boolean useSOAPAction() {
        return this.useSOAPAction;
    }

    public void setSOAPActionURI(String string) throws IllegalArgumentException {
        this.SOAPActionURI = string;
    }

    public String getSOAPActionURI() {
        return this.SOAPActionURI;
    }

    public void setEncodingStyle(String string) {
        if (string == null) {
            string = "";
        }
        this.encodingStyle = string;
    }

    public String getEncodingStyle() {
        return this.encodingStyle;
    }

    public void clearProperty(String string) {
        if (this.bag != null) {
            this.bag.remove(string);
        }
    }

    public void reset() {
        if (this.bag != null) {
            this.bag.clear();
        }
        this.serviceHandler = null;
        this.havePassedPivot = false;
    }

    public static int getStyleFromString(String string) {
        if ("rpc".equalsIgnoreCase(string)) {
            return 0;
        }
        if ("document".equalsIgnoreCase(string)) {
            return 1;
        }
        throw new IllegalArgumentException(JavaUtils.getMessage("badProp01", new String[]{"javax.xml.rpc.soap.operation.style", "\"rpc\", \"document\"", string}));
    }

    public static String getStyleFromInt(int n) {
        if (n == 0) {
            return "rpc";
        }
        if (n == 1) {
            return "document";
        }
        return null;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        try {
            systemTempDir = System.getProperty("axis.attachments.Directory");
        }
        catch (Throwable throwable) {
            systemTempDir = null;
        }
        if (systemTempDir == null) {
            try {
                File file = File.createTempFile("Axis", "Axis");
                File file2 = file.getParentFile();
                if (file.exists()) {
                    file.delete();
                }
                if (file2 != null) {
                    systemTempDir = file2.getCanonicalPath();
                }
            }
            catch (Throwable throwable) {
                systemTempDir = null;
            }
        }
        ENGINE_HANDLER = "engine.handler";
        TRANS_URL = "transport.url";
        QUIT_REQUESTED = "quit.requested";
        AUTHUSER = "authenticatedUser";
        ISRPC = "is_rpc";
        CALL = "call_object";
        ATTACHMENTS_DIR = "attachments.directory";
    }
}

