/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.rmi.RemoteException;
import java.util.Vector;
import org.apache.axis.encoding.SerializationContext;
import org.apache.axis.message.SOAPEnvelope;
import org.apache.axis.message.SOAPFaultElement;
import org.apache.axis.utils.QFault;
import org.apache.axis.utils.XMLUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class AxisFault
extends RemoteException {
    protected static Log log = LogFactory.getLog((String)(class$org$apache$axis$AxisFault == null ? (class$org$apache$axis$AxisFault = AxisFault.class$("org.apache.axis.AxisFault")) : class$org$apache$axis$AxisFault).getName());
    private static final String LS = System.getProperty("line.separator");
    protected QFault faultCode;
    protected String faultString = "";
    protected String faultActor;
    protected Vector faultDetails;
    static /* synthetic */ Class class$org$apache$axis$AxisFault;

    public static AxisFault makeFault(Exception exception) {
        Throwable throwable;
        if (exception instanceof InvocationTargetException && (throwable = ((InvocationTargetException)exception).getTargetException()) instanceof Exception) {
            exception = (Exception)throwable;
        }
        if (exception instanceof AxisFault) {
            return (AxisFault)exception;
        }
        return new AxisFault(exception);
    }

    public AxisFault(String string, String string2, String string3, Element[] elementArray) {
        super(string2);
        this.setFaultCode(new QFault("http://xml.apache.org/axis/", string));
        this.setFaultString(string2);
        this.setFaultActor(string3);
        this.setFaultDetail(elementArray);
        if (elementArray == null) {
            this.initFromException(this);
        }
    }

    public AxisFault(QFault qFault, String string, String string2, Element[] elementArray) {
        super(string);
        this.setFaultCode(qFault);
        this.setFaultString(string);
        this.setFaultActor(string2);
        this.setFaultDetail(elementArray);
        if (elementArray == null) {
            this.initFromException(this);
        }
    }

    protected AxisFault(Exception exception) {
        super("", exception);
        this.setFaultCode("Server.userException");
        this.initFromException(exception);
    }

    public AxisFault(String string) {
        super(string);
        this.setFaultCode("Server.generalException");
        this.setFaultString(string);
        this.initFromException(this);
    }

    public AxisFault() {
        this.setFaultCode("Server.generalException");
        this.initFromException(this);
    }

    public AxisFault(String string, Throwable throwable) {
        super(string, throwable);
        this.setFaultCode("Server.generalException");
        this.setFaultString(string);
    }

    private void initFromException(Exception exception) {
        Element element;
        int n = 0;
        while (this.faultDetails != null && n < this.faultDetails.size()) {
            element = (Element)this.faultDetails.elementAt(n);
            if ("stackTrace".equals(element.getLocalName()) && "http://xml.apache.org/axis/".equals(element.getNamespaceURI())) {
                return;
            }
            ++n;
        }
        this.setFaultString(exception.toString());
        if (this.faultDetails == null) {
            this.faultDetails = new Vector();
        }
        if (exception instanceof AxisFault && exception.getClass() != (class$org$apache$axis$AxisFault == null ? (class$org$apache$axis$AxisFault = AxisFault.class$("org.apache.axis.AxisFault")) : class$org$apache$axis$AxisFault)) {
            element = XMLUtils.StringToElement("http://xml.apache.org/axis/", "exceptionName", exception.getClass().getName());
            this.faultDetails.add(element);
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        PrintStream printStream = new PrintStream(byteArrayOutputStream);
        exception.printStackTrace(printStream);
        printStream.close();
        element = XMLUtils.StringToElement("http://xml.apache.org/axis/", "stackTrace", byteArrayOutputStream.toString());
        this.faultDetails.add(element);
    }

    public void dump() {
        log.debug((Object)this.dumpToString());
    }

    public String dumpToString() {
        String string = new String();
        if (this.faultDetails != null) {
            int n = 0;
            while (n < this.faultDetails.size()) {
                Element element = (Element)this.faultDetails.get(n);
                Text text = (Text)element.getFirstChild();
                string = string + LS + "\t" + element.getLocalName() + ": " + text.getData();
                ++n;
            }
        }
        return "AxisFault" + LS + " faultCode: " + this.faultCode + LS + " faultString: " + this.faultString + LS + " faultActor: " + this.faultActor + LS + " faultDetail: " + string + LS;
    }

    public void setFaultCode(QFault qFault) {
        this.faultCode = qFault;
    }

    public void setFaultCode(String string) {
        this.faultCode = new QFault("http://xml.apache.org/axis/", string);
    }

    public QFault getFaultCode() {
        return this.faultCode;
    }

    public void setFaultString(String string) {
        this.faultString = string != null ? string : "";
    }

    public String getFaultString() {
        return this.faultString;
    }

    public void setFaultActor(String string) {
        this.faultActor = string;
    }

    public String getFaultActor() {
        return this.faultActor;
    }

    public void setFaultDetail(Element[] elementArray) {
        if (elementArray == null) {
            return;
        }
        this.faultDetails = new Vector(elementArray.length);
        int n = 0;
        while (n < elementArray.length) {
            this.faultDetails.add(elementArray[n]);
            ++n;
        }
    }

    public void setFaultDetailString(String string) {
        this.faultDetails = new Vector();
        Document document = XMLUtils.newDocument();
        Element element = document.createElement("string");
        Text text = document.createTextNode(string);
        element.appendChild(text);
        this.faultDetails.add(element);
    }

    public Element[] getFaultDetails() {
        if (this.faultDetails == null) {
            return null;
        }
        Element[] elementArray = new Element[this.faultDetails.size()];
        int n = 0;
        while (n < elementArray.length) {
            elementArray[n] = (Element)this.faultDetails.elementAt(n);
            ++n;
        }
        return elementArray;
    }

    public void output(SerializationContext serializationContext) throws Exception {
        SOAPEnvelope sOAPEnvelope = new SOAPEnvelope();
        SOAPFaultElement sOAPFaultElement = new SOAPFaultElement(this);
        sOAPEnvelope.addBodyElement(sOAPFaultElement);
        sOAPEnvelope.output(serializationContext);
    }

    public String toString() {
        return this.faultString;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

