/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.shell.bin.whoami;

import java.io.StringWriter;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Vector;
import net.jxta.document.MimeMediaType;
import net.jxta.document.StructuredTextDocument;
import net.jxta.document.TextElement;
import net.jxta.endpoint.EndpointAddress;
import net.jxta.endpoint.EndpointService;
import net.jxta.id.ID;
import net.jxta.impl.shell.ShellApp;
import net.jxta.impl.shell.ShellEnv;
import net.jxta.impl.shell.ShellObject;
import net.jxta.peergroup.PeerGroup;
import net.jxta.protocol.PeerAdvertisement;
import net.jxta.protocol.PeerGroupAdvertisement;

public class whoami
extends ShellApp {
    private ShellEnv myEnv;

    public int startApp(String[] args) {
        int i = 0;
        boolean full = false;
        boolean viewpg = false;
        ShellObject obj = null;
        PeerGroup pg = null;
        PeerGroupAdvertisement groupAdv = null;
        PeerAdvertisement peerAdv = null;
        this.myEnv = this.getEnv();
        if (args != null) {
            i = 0;
            while (i < args.length) {
                if (args[i].equals("-l")) {
                    full = true;
                } else if (args[i].equals("-g")) {
                    viewpg = true;
                } else {
                    return this.syntaxError();
                }
                ++i;
            }
        }
        if (viewpg) {
            obj = this.myEnv.get("stdgroup");
        } else {
            obj = this.myEnv.get("rootgroup");
            if (obj == null) {
                obj = this.myEnv.get("stdgroup");
            }
        }
        pg = (PeerGroup)obj.getObject();
        groupAdv = pg.getPeerGroupAdvertisement();
        peerAdv = pg.getPeerAdvertisement();
        Enumeration endps = this.getEndpointAddresses(peerAdv);
        if (full) {
            try {
                StringWriter out = new StringWriter();
                MimeMediaType displayAs = new MimeMediaType("text/plain");
                StructuredTextDocument doc = (StructuredTextDocument)groupAdv.getDocument(displayAs);
                doc.sendToWriter((Writer)out);
                this.println(out.toString());
            }
            catch (Exception all) {
                return this.syntaxError();
            }
        } else if (!viewpg) {
            String desc;
            String name = peerAdv.getName();
            if (name != null) {
                this.println("<Peer>" + name + "</Peer>");
            }
            if ((desc = peerAdv.getDescription()) != null) {
                this.println("<Description>" + desc + "</Description>");
            }
            this.println("<PeerId>" + peerAdv.getPeerID() + "</PeerId>");
            if (endps != null) {
                while (endps.hasMoreElements()) {
                    try {
                        EndpointAddress endp = (EndpointAddress)endps.nextElement();
                        this.println("<TransportAddress>" + endp.toString() + "</TransportAddress>");
                    }
                    catch (Exception ez1) {
                        // empty catch block
                    }
                }
            }
        } else {
            this.println("<PeerGroup>" + groupAdv.getName() + "</PeerGroup>");
            String desc = groupAdv.getDescription();
            if (desc != null) {
                this.println("<Description>" + desc + "</Description>");
            }
            this.println("<PeerGroupId>" + groupAdv.getPeerGroupID() + "</PeerGroupId>");
        }
        return 0;
    }

    private Enumeration getEndpointAddresses(PeerAdvertisement peerAdv) {
        TextElement endpParam = (TextElement)peerAdv.getServiceParam((ID)PeerGroup.endpointClassID);
        if (endpParam == null) {
            return null;
        }
        Enumeration endps = endpParam.getChildren("Addr");
        if (endps == null || !endps.hasMoreElements()) {
            return null;
        }
        EndpointService endpoint = this.group.getEndpointService();
        Vector<EndpointAddress> addrs = new Vector<EndpointAddress>();
        while (endps.hasMoreElements()) {
            String saddr = "";
            try {
                saddr = ((TextElement)endps.nextElement()).getTextValue();
                addrs.addElement(endpoint.newEndpointAddress(saddr));
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (addrs.size() == 0) {
            return null;
        }
        return addrs.elements();
    }

    public int syntaxError() {
        this.println("error: whoami [-g] [-l]");
        return 1;
    }

    public void stopApp() {
    }

    public String getDescription() {
        return "Display information about a peer or peergroup";
    }

    public void help() {
        this.println("NAME");
        this.println("     whoami - display information about a peer or peergroup");
        this.println(" ");
        this.println("SYNOPSIS");
        this.println("     whoami [-l] [-g]");
        this.println(" ");
        this.println("DESCRIPTION");
        this.println(" ");
        this.println("whoami displays information about a peer or a");
        this.println("peergroup. With no option, whoami returns");
        this.println("information about the local peer. The '-g' option returns");
        this.println("information about the current peer group joined.");
        this.println("");
        this.println("By default the Shell is brought up in the 'NetPeerGroup' group. Peers");
        this.println("do not have name. A user can assign a symbolic name to a peer");
        this.println("via the 'setinfo' command. There is no guarantee that the name");
        this.println("is unique. Only the peerId and the peerGroup ID are guaranteed");
        this.println("to be unique.");
        this.println("");
        this.println("OPTIONS");
        this.println("");
        this.println("     [-g]  return info about the current peergroup");
        this.println("     [-l]  return a long version of the advertisement");
        this.println(" ");
        this.println("EXAMPLE");
        this.println(" ");
        this.println("    JXTA>whoami -l");
        this.println(" ");
        this.println("This example displays a long version of the peer group information");
        this.println(" ");
        this.println("SEE ALSO");
        this.println("    setinfo peers");
    }
}

