/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.shell.bin.talk;

import java.util.Enumeration;
import net.jxta.discovery.DiscoveryService;
import net.jxta.document.Advertisement;
import net.jxta.document.AdvertisementFactory;
import net.jxta.endpoint.Message;
import net.jxta.id.ID;
import net.jxta.id.IDFactory;
import net.jxta.impl.shell.ShellApp;
import net.jxta.impl.shell.ShellEnv;
import net.jxta.impl.shell.ShellObject;
import net.jxta.peergroup.PeerGroup;
import net.jxta.peergroup.PeerGroupID;
import net.jxta.pipe.InputPipe;
import net.jxta.pipe.OutputPipe;
import net.jxta.protocol.PipeAdvertisement;
import net.jxta.util.StringEnumeration;

public class talk
extends ShellApp
implements Runnable {
    private DiscoveryService discovery = null;
    private ShellEnv env = null;
    private PipeAdvertisement userAdv = null;
    private static final int WaitingTime = 2000;
    private static final int MAXRETRIES = 5;
    public static final String TalkNameTag = "JxtaTalkUserName";
    public static final String TalkIDTag = "JxtaTalkPipeID";
    private static final String EnvName = "talkd";
    private String userName = null;
    private static final String SenderName = "JxtaTalkSenderName";
    private static final String SenderMessage = "JxtaTalkSenderMessage";
    private Thread thread = null;

    public void stopApp() {
    }

    private int syntaxError() {
        this.println("Usage: talk -register userName");
        this.println("       talk -register userName -secure");
        this.println("       talk -register userName -propagate");
        this.println("       talk -login userName ");
        this.println("       talk -logout userName ");
        this.println("       talk [-u user] userName ");
        this.println("       talk -search ");
        return 1;
    }

    public int startApp(String[] args) {
        if (args == null || args.length == 0) {
            return this.syntaxError();
        }
        this.env = this.getEnv();
        this.discovery = this.group.getDiscoveryService();
        if (args[0].equals("-register")) {
            return this.registerNewUser(args);
        }
        if (args[0].equals("-login")) {
            return this.login(args);
        }
        if (args[0].equals("-logout")) {
            return this.logout(args);
        }
        if (args[0].equals("-search")) {
            return this.findUsers();
        }
        return this.sendMessage(args);
    }

    private boolean deamonRunning(String name) {
        ShellObject obj = this.env.get("talkd." + name + "@" + this.group.getPeerGroupAdvertisement().getName());
        return obj != null;
    }

    private int login(String[] args) {
        if (args.length != 2) {
            return this.syntaxError();
        }
        String name = args[1];
        if (this.deamonRunning(name)) {
            this.println("talk: user " + name + " is already listening");
            return Integer.MAX_VALUE;
        }
        PipeAdvertisement adv = this.findUserAdv(name);
        this.discovery.remotePublish((Advertisement)adv, 2);
        if (adv == null) {
            this.println("talk: " + name + " is not a registered user");
            return Integer.MAX_VALUE;
        }
        this.runDeamon(name, adv);
        return 0;
    }

    private int findUsers() {
        int i = 0;
        this.discovery.getRemoteAdvertisements(null, 2, "Name", "JxtaTalkUserName.*", 20, null);
        while (true) {
            try {
                if (i > 5) {
                    this.println("");
                    break;
                }
                Thread.sleep(2000L);
                this.print(".");
                ++i;
            }
            catch (Exception e) {}
        }
        try {
            Enumeration enumeration = this.discovery.getLocalAdvertisements(2, "Name", "JxtaTalkUserName.*");
            if (enumeration != null && enumeration.hasMoreElements()) {
                PipeAdvertisement adv = null;
                this.println("found the following registrations:");
                while (enumeration.hasMoreElements()) {
                    try {
                        adv = (PipeAdvertisement)enumeration.nextElement();
                        this.println(adv.getName());
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return 0;
    }

    private int logout(String[] args) {
        if (args.length != 2) {
            return this.syntaxError();
        }
        String name = args[1];
        if (!this.deamonRunning(name)) {
            this.println("talk: user " + name + " is not listening");
            return Integer.MAX_VALUE;
        }
        this.stopDeamon(name);
        return 0;
    }

    private int sendMessage(String[] args) {
        PipeAdvertisement adv;
        String name = null;
        String srcName = null;
        if (args[0].equals("-u")) {
            if (args.length != 3) {
                return this.syntaxError();
            }
            srcName = args[1];
            name = args[2];
            if (!this.deamonRunning(srcName)) {
                this.println("talk: user " + srcName + " is not logged");
                return Integer.MAX_VALUE;
            }
        } else {
            name = args[0];
            srcName = this.group.getPeerID().toString();
        }
        if ((adv = this.findUserAdv(name)) == null) {
            this.println("talk: " + name + " is not a registered user");
            return Integer.MAX_VALUE;
        }
        OutputPipe pipeOut = null;
        try {
            this.println("found user's advertisement attempting to connect");
            pipeOut = this.pipes.createOutputPipe(adv, 50000L);
            if (pipeOut == null) {
                this.println("talk:  user " + name + " is not listening. Try again later");
                return Integer.MAX_VALUE;
            }
        }
        catch (Exception e) {
            this.println("talk: user " + name + " is not listening. Try again later");
            return Integer.MAX_VALUE;
        }
        this.println("talk is connected to user " + name);
        this.println("Type your message. To exit, type \".\" at begining of line");
        Message msg = null;
        String userInput = null;
        Object ip = null;
        while (true) {
            try {
                userInput = this.waitForInput();
                if (userInput == null || userInput.equals(".")) break;
                msg = this.pipes.createMessage();
                msg.setString(SenderMessage, userInput);
                if (srcName != null) {
                    msg.setString(SenderName, srcName);
                }
                pipeOut.send(msg);
            }
            catch (Exception e) {
                this.println("talk failed to send message to user :" + name);
                return Integer.MAX_VALUE;
            }
        }
        pipeOut.close();
        return 0;
    }

    private int registerNewUser(String[] args) {
        String t;
        if (args.length != 2 && args.length != 3) {
            return this.syntaxError();
        }
        String name = args[1];
        String type = null;
        type = args.length == 3 ? ((t = args[2]).equals("-secure") ? "JxtaUnicastSecure" : (t.equals("-propagate") ? "JxtaPropagate" : "JxtaUnicast")) : "JxtaUnicast";
        PipeAdvertisement adv = this.findUserAdv(name);
        if (adv != null) {
            this.println("talk: sorry, user " + name + " is already registered");
            return Integer.MAX_VALUE;
        }
        try {
            adv = (PipeAdvertisement)AdvertisementFactory.newAdvertisement((String)PipeAdvertisement.getAdvertisementType());
        }
        catch (Exception all) {
            this.println("Advertisement document could not be created");
            return Integer.MAX_VALUE;
        }
        ShellObject obj = this.env.get("stdgroup");
        PeerGroup group = (PeerGroup)obj.getObject();
        adv.setPipeID((ID)IDFactory.newPipeID((PeerGroupID)group.getPeerGroupID()));
        adv.setName("JxtaTalkUserName." + name);
        adv.setType(type);
        try {
            this.discovery.publish((Advertisement)adv, 2);
            this.discovery.remotePublish((Advertisement)adv, 2);
        }
        catch (Exception e2) {
            this.println("Advertisement could not be saved");
            e2.printStackTrace();
            return Integer.MAX_VALUE;
        }
        this.println("User : " + name + " is now registered");
        return 0;
    }

    private boolean checkUserAdv(PipeAdvertisement adv, String name) {
        if (adv == null) {
            return false;
        }
        if (adv.getName() == null) {
            return false;
        }
        String str = adv.getName();
        return str.startsWith(TalkNameTag) && str.endsWith(name);
    }

    private PipeAdvertisement findUserAdv(String name) {
        Enumeration enumeration;
        block15: {
            enumeration = null;
            try {
                enumeration = this.discovery.getLocalAdvertisements(2, "Name", "JxtaTalkUserName.*");
                if (enumeration == null || !enumeration.hasMoreElements()) break block15;
                PipeAdvertisement adv = null;
                while (enumeration.hasMoreElements()) {
                    try {
                        adv = (PipeAdvertisement)enumeration.nextElement();
                        if (adv.getName().endsWith(name) && this.checkUserAdv(adv, name)) {
                            return adv;
                        }
                    }
                    catch (Exception e) {
                        continue;
                    }
                    if (!this.checkUserAdv(adv, name)) continue;
                    return adv;
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        this.discovery.getRemoteAdvertisements(null, 2, "Name", "JxtaTalkUserName." + name, 2, null);
        int i = 0;
        block11: while (true) {
            try {
                if (i > 5) {
                    this.println("");
                    break;
                }
                Thread.sleep(2000L);
                this.print(".");
                ++i;
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                enumeration = this.discovery.getLocalAdvertisements(2, "Name", "JxtaTalkUserName." + name);
                if (enumeration == null || !enumeration.hasMoreElements()) continue;
                PipeAdvertisement adv = null;
                while (true) {
                    if (!enumeration.hasMoreElements()) continue block11;
                    try {
                        adv = (PipeAdvertisement)enumeration.nextElement();
                    }
                    catch (Exception e) {
                        continue;
                    }
                    if (this.checkUserAdv(adv, name)) break;
                }
                return adv;
            }
            catch (Exception e) {}
        }
        return null;
    }

    private void runDeamon(String name, PipeAdvertisement adv) {
        this.userAdv = adv;
        this.userName = name;
        this.thread = new Thread((Runnable)this, "Talk:Talk Deamon");
        this.thread.start();
        ShellObject shellObject = this.env.add("talkd." + name + "@" + this.group.getPeerGroupAdvertisement().getName(), new ShellObject("Talk Deamon for " + name + "@" + this.group.getPeerGroupAdvertisement().getName(), this));
    }

    private void stopDeamon(String name) {
        String dname = "talkd." + name + "@" + this.group.getPeerGroupAdvertisement().getName();
        ShellObject obj = this.env.get(dname);
        if (obj == null) {
            this.println("sftp: Daemon(" + dname + ") for " + name + " not found");
            return;
        }
        talk d = null;
        try {
            d = (talk)obj.getObject();
            d.thread.interrupt();
            this.env.remove(dname);
        }
        catch (Exception e) {
            this.println("talk: cannot stop deamon for " + name);
            return;
        }
    }

    public void run() {
        try {
            InputPipe pipeIn = null;
            try {
                pipeIn = this.pipes.createInputPipe(this.userAdv);
            }
            catch (Exception e) {
                return;
            }
            if (pipeIn == null) {
                this.println("talk: cannot open InputPipe");
                return;
            }
            Message msg = null;
            while (true) {
                try {
                    while ((msg = pipeIn.waitForMessage()) == null) {
                        if (Thread.interrupted()) {
                            this.println("talk: stop listening for user " + this.userName);
                            pipeIn.close();
                            return;
                        }
                        this.println("NULL msg");
                    }
                }
                catch (Exception e) {
                    pipeIn.close();
                    return;
                }
                Object ip = null;
                StringEnumeration stringEnumeration = msg.getNames();
                if (stringEnumeration == null || !stringEnumeration.hasMoreElements()) continue;
                boolean res = false;
                String senderName = "Anonymous";
                boolean msgSize = false;
                Object buffer = null;
                senderName = msg.getString(SenderName);
                String senderMessage = msg.getString(SenderMessage);
                if (senderMessage == null) {
                    this.println("talk: receive from user " + senderName + " an empty message for " + this.userName);
                    continue;
                }
                this.println("talk: from " + senderName + " to " + this.userName);
                this.println("Message: " + senderMessage);
            }
        }
        catch (Throwable all) {
            System.out.flush();
            System.err.println("Uncaught Throwable in thread :" + Thread.currentThread().getName());
            all.printStackTrace(System.err);
            return;
        }
    }

    public String getDescription() {
        return "Talk to another peer";
    }

    public void help() {
        this.println("NAME");
        this.println("     talk - talk to another peer ");
        this.println(" ");
        this.println("SYNOPSIS");
        this.println(" ");
        this.println("    talk -register <userName> ");
        this.println("    talk -register <userName> -secure");
        this.println("    talk -register <userName> -propagate");
        this.println("    talk -login <userName>");
        this.println("    talk -logout <userName>");
        this.println("    talk [-u <user>] <userName>");
        this.println(" ");
        this.println("DESCRIPTION");
        this.println(" ");
        this.println("The 'talk command implements a simple instant messaging command");
        this.println("where two users on two remote peers can exchange messages.");
        this.println("Messages are displayed on the Shell stdout. In order");
        this.println("to use 'talk'. The user needs to register himself. This is done");
        this.println("via the following steps:");
        this.println("Step 1: Register via 'talk -register <username>' command. This command");
        this.println("        creates a Talk advertisement for that user. This has to");
        this.println("        be done only once, the first time the user registers with");
        this.println("        talk. The system remembers it accross reboot.");
        this.println("        -secure can be added in order to establish a secure talk session.");
        this.println("        -propagate can be added in order to establish a chatroom style talk session.");
        this.println(" ");
        this.println("Step 2: Login  via 'talk -login <username>' command. This command");
        this.println("        logs the user and starts a listener daemon. This has to");
        this.println("        to be done everytime the peer is restarted.");
        this.println(" ");
        this.println("Step 3: User can talk to another user via the command");
        this.println("        'talk -u <myusername> <destusername>'. This command will prompt the user");
        this.println("        to enter the message he/she wants to send");
        this.println(" ");
        this.println("         JXTA>talk -u moi mike");
        this.println("         talk is connected to user mike");
        this.println("         Type your message. To exit, type '.' at begining of line");
        this.println("  ");
        this.println("To stop receiving any more talk messages. The user can stop the talk");
        this.println("listener daemon by entering the command 'talk -logout <username>'");
        this.println(" ");
        this.println("OPTIONS");
        this.println(" ");
        this.println("    -register register a new user name  ");
        this.println("    -login    log user and set default user");
        this.println("    -logout   logout");
        this.println("    -u        specify current user name");
        this.println(" ");
        this.println("EXAMPLE");
        this.println(" ");
        this.println("      JXTA>talk -register me");
        this.println("      JXTA>talk -login me");
        this.println("      JXTA>talk -u me you");
        this.println(" ");
        this.println("This example shows how a new user 'me'  can register and log into talk,");
        this.println(" an talk to the user 'you'. User 'you' needs to be registered and logged on.");
        this.println(" ");
        this.println("SEE ALSO");
    }

    static {
        WaitingTime = 2000;
        MAXRETRIES = 5;
        TalkNameTag = TalkNameTag;
        TalkIDTag = TalkIDTag;
        EnvName = EnvName;
        SenderName = SenderName;
        SenderMessage = SenderMessage;
    }
}

