/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.shell.bin.sftp;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Enumeration;
import net.jxta.discovery.DiscoveryService;
import net.jxta.document.Advertisement;
import net.jxta.document.AdvertisementFactory;
import net.jxta.endpoint.Message;
import net.jxta.id.ID;
import net.jxta.id.IDFactory;
import net.jxta.impl.shell.ShellApp;
import net.jxta.impl.shell.ShellEnv;
import net.jxta.impl.shell.ShellObject;
import net.jxta.peergroup.PeerGroup;
import net.jxta.peergroup.PeerGroupID;
import net.jxta.pipe.InputPipe;
import net.jxta.pipe.OutputPipe;
import net.jxta.protocol.PipeAdvertisement;
import net.jxta.util.StringEnumeration;

public class sftp
extends ShellApp
implements Runnable {
    private DiscoveryService discovery = null;
    private ShellEnv env = null;
    private PipeAdvertisement userAdv = null;
    private static final int WaitingTime = 2000;
    private static final int MAXRETRIES = 5;
    public static final String SftpNameTag = "JxtaSftpUserName";
    public static final String SftpIDTag = "JxtaSftpPipeID";
    private static final String EnvName = "sftpd";
    private String userName = null;
    private static final String SenderName = "JxtaSftpSenderName";
    private static final String JftpData = "JxtaSftpData";
    private static final String FileInfo = "JxtaSftpInfo";
    private Thread thread = null;
    private String fsep = "";
    private static final String fdirname = "sftp";
    private String fdir = null;
    private static final int OBUFLEN = 15000;

    public sftp() {
        try {
            this.fsep = System.getProperty("file.separator");
        }
        catch (Exception e) {
            // empty catch block
        }
        this.fdir = fdirname + this.fsep;
        File f = new File(this.fdir);
        if (!f.exists()) {
            try {
                if (!f.mkdir()) {
                    this.fdir = "";
                }
            }
            catch (Exception ex) {
                this.fdir = null;
                this.println("Exception = " + ex.getMessage() + "while creating new file " + this.fdir);
            }
        }
    }

    public void stopApp() {
    }

    private int syntaxError() {
        this.println("Usage: sftp -register userName");
        this.println("       sftp -login userName ");
        this.println("       sftp -logout userName ");
        this.println("       sftp -s userName destUserName filename");
        this.println("       sftp -search");
        return 1;
    }

    public int startApp(String[] args) {
        if (args == null || args.length == 0) {
            return this.syntaxError();
        }
        this.env = this.getEnv();
        this.discovery = this.group.getDiscoveryService();
        if (args[0].equals("-register")) {
            return this.registerNewUser(args);
        }
        if (args[0].equals("-login")) {
            return this.login(args);
        }
        if (args[0].equals("-logout")) {
            return this.logout(args);
        }
        if (args[0].equals("-search")) {
            return this.findUsers();
        }
        return this.sendFile(args);
    }

    private boolean daemonRunning(String name) {
        ShellObject obj = this.env.get("sftpd." + name + "@" + this.group.getPeerGroupAdvertisement().getName());
        return obj != null;
    }

    private int login(String[] args) {
        if (args.length != 2) {
            return this.syntaxError();
        }
        String name = args[1];
        if (this.daemonRunning(name)) {
            this.println("sftp: user " + name + " is already listening");
            return Integer.MAX_VALUE;
        }
        PipeAdvertisement adv = this.findUserAdv(name);
        if (adv == null) {
            this.println("ftpd: " + name + " is not a registered user");
            return Integer.MAX_VALUE;
        }
        this.discovery.remotePublish((Advertisement)adv, 2);
        this.runDaemon(name, adv);
        return 0;
    }

    private int findUsers() {
        int i = 0;
        this.discovery.getRemoteAdvertisements(null, 2, "Name", "JxtaSftpUserName.*", 20, null);
        while (true) {
            try {
                if (i > 5) {
                    this.println("");
                    break;
                }
                Thread.sleep(2000L);
                this.print(".");
                ++i;
            }
            catch (Exception e) {
                this.println("findUsers, exception = " + e.getMessage());
            }
        }
        try {
            Enumeration enumeration = this.discovery.getLocalAdvertisements(2, "Name", "JxtaSftpUserName.*");
            if (enumeration != null && enumeration.hasMoreElements()) {
                PipeAdvertisement adv = null;
                this.println("found the following registrations:");
                while (enumeration.hasMoreElements()) {
                    try {
                        adv = (PipeAdvertisement)enumeration.nextElement();
                        this.println(adv.getName());
                    }
                    catch (Exception e) {
                        this.println("findUsers, exception = " + e.getMessage());
                    }
                }
            }
        }
        catch (Exception e) {
            this.println("findUsers, exception = " + e.getMessage());
        }
        return 0;
    }

    private int logout(String[] args) {
        if (args.length != 2) {
            return this.syntaxError();
        }
        String name = args[1];
        if (!this.daemonRunning(name)) {
            this.println("ftpd: user " + name + " is not listening");
            return Integer.MAX_VALUE;
        }
        this.stopDaemon(name);
        return 0;
    }

    private int sendFile(String[] args) {
        int j;
        if (!args[0].equals("-s") || args.length != 4) {
            return this.syntaxError();
        }
        String srcName = args[1];
        String name = args[2];
        String fileName = args[3];
        if (!this.daemonRunning(srcName)) {
            this.println("sftpd: user " + srcName + " is not logged in");
            return Integer.MAX_VALUE;
        }
        PipeAdvertisement adv = this.findUserAdv(name);
        if (adv == null) {
            this.println("sftp: " + name + " is not a registered user");
            return Integer.MAX_VALUE;
        }
        OutputPipe pipeOut = null;
        try {
            this.println("found user's advertisement attempting to connect");
            pipeOut = this.pipes.createOutputPipe(adv, 50000L);
            if (pipeOut == null) {
                this.println("sftp:  user " + name + " is not listening. Try again later");
                return Integer.MAX_VALUE;
            }
        }
        catch (Exception e) {
            this.println("sftp: user " + name + " is not listening. Try again later" + "\n      Exception = " + e.getMessage());
            return Integer.MAX_VALUE;
        }
        File f = null;
        FileInputStream fs = null;
        try {
            f = new File(fileName);
            fs = new FileInputStream(f);
        }
        catch (Exception e) {
            this.println("sftp: Could not open " + fileName + "\n      Exception = " + e.getMessage());
            pipeOut.close();
            return Integer.MAX_VALUE;
        }
        long fileSize = f.length();
        int pix = fileName.lastIndexOf(this.fsep);
        String stripped = null;
        stripped = pix != -1 ? fileName.substring(pix + 1) : fileName;
        String start = stripped + "\n" + fileSize;
        Message msg = null;
        byte[] buf = new byte[15000];
        int n16kbufs = (int)(fileSize / 15000L);
        int lastBufSize = (int)(fileSize % 15000L);
        boolean infoDone = false;
        int offset = 0;
        long stime = System.currentTimeMillis();
        int chunks = n16kbufs + (lastBufSize == 0 ? 0 : 1);
        this.println("sftp is connected to user " + name);
        this.println("Sending file " + fileName + ", size = " + fileSize + " bytes" + " in " + chunks + "chunks");
        int i = 0;
        while (i < n16kbufs) {
            try {
                msg = this.pipes.createMessage();
                if (i == 0) {
                    infoDone = true;
                    msg.setBytes(FileInfo, start.getBytes());
                }
                if ((j = fs.read(buf, 0, 15000)) != 15000) {
                    fs.close();
                    pipeOut.close();
                    this.println("Error: Unexpected EOF reading " + fileName);
                    return Integer.MAX_VALUE;
                }
                offset += 15000;
                msg.setBytes(JftpData, buf);
                msg.setBytes(SenderName, srcName.getBytes());
                pipeOut.send(msg);
                this.print("!");
            }
            catch (Exception e) {
                this.println("sftpd(1): failed to send file " + fileName + " to user :" + name + "\n      Exception = " + e.getMessage());
                e.printStackTrace();
                try {
                    fs.close();
                }
                catch (Exception ex) {
                    this.println("Close failed for " + fileName + ", Exception = " + ex.getMessage());
                }
                pipeOut.close();
                return Integer.MAX_VALUE;
            }
            ++i;
        }
        if (lastBufSize != 0) {
            try {
                msg = this.pipes.createMessage();
                if (!infoDone) {
                    msg.setBytes(FileInfo, start.getBytes());
                }
                if ((j = fs.read(buf, 0, lastBufSize)) != lastBufSize) {
                    fs.close();
                    pipeOut.close();
                    this.println("Error: Unexpected EOF reading " + fileName);
                    return Integer.MAX_VALUE;
                }
                msg.setBytes(JftpData, buf, 0, lastBufSize);
                msg.setBytes(SenderName, srcName.getBytes());
                pipeOut.send(msg);
                this.print("!");
            }
            catch (Exception e) {
                this.println("sftpd(2): failed to send file " + fileName + " to user :" + name + "\n      Exception = " + e.getMessage());
                e.printStackTrace();
                try {
                    fs.close();
                }
                catch (Exception ex) {
                    this.println("Close failed for " + fileName + ", Exception = " + ex.getMessage());
                }
                pipeOut.close();
                return Integer.MAX_VALUE;
            }
        }
        long elapsedTime = System.currentTimeMillis() - stime;
        long kbpsec = fileSize / elapsedTime;
        float secs = (float)((double)elapsedTime / 1000.0);
        this.println("\nSent: " + fileSize + " bytes in " + secs + " secs[" + kbpsec + "Kbytes/sec]");
        try {
            fs.close();
        }
        catch (Exception ex) {
            this.println("Close failed for " + fileName + ", Exception = " + ex.getMessage());
        }
        pipeOut.close();
        return 0;
    }

    private int registerNewUser(String[] args) {
        if (args.length != 2) {
            return this.syntaxError();
        }
        String name = args[1];
        String type = "JxtaUnicastSecure";
        PipeAdvertisement adv = this.findUserAdv(name);
        if (adv != null) {
            this.println("sftp: sorry, user " + name + " is already registered");
            return Integer.MAX_VALUE;
        }
        try {
            adv = (PipeAdvertisement)AdvertisementFactory.newAdvertisement((String)PipeAdvertisement.getAdvertisementType());
        }
        catch (Exception all) {
            this.println("Advertisement document could not be created\n  Exception = " + all.getMessage());
            return Integer.MAX_VALUE;
        }
        ShellObject obj = this.env.get("stdgroup");
        PeerGroup group = (PeerGroup)obj.getObject();
        adv.setPipeID((ID)IDFactory.newPipeID((PeerGroupID)group.getPeerGroupID()));
        adv.setName("JxtaSftpUserName." + name);
        adv.setType(type);
        try {
            this.discovery.publish((Advertisement)adv, 2);
            this.discovery.remotePublish((Advertisement)adv, 2);
        }
        catch (Exception e2) {
            this.println("Advertisement could not be saved");
            e2.printStackTrace();
            return Integer.MAX_VALUE;
        }
        this.println("User : " + name + " is now registered");
        return 0;
    }

    private boolean checkUserAdv(PipeAdvertisement adv, String name) {
        if (adv == null) {
            return false;
        }
        if (adv.getName() == null) {
            return false;
        }
        String str = adv.getName();
        return str.startsWith(SftpNameTag) && str.endsWith(name);
    }

    private PipeAdvertisement findUserAdv(String name) {
        Enumeration enumeration;
        block15: {
            enumeration = null;
            try {
                enumeration = this.discovery.getLocalAdvertisements(2, "Name", "JxtaSftpUserName.*");
                if (enumeration == null || !enumeration.hasMoreElements()) break block15;
                PipeAdvertisement adv = null;
                while (enumeration.hasMoreElements()) {
                    try {
                        adv = (PipeAdvertisement)enumeration.nextElement();
                        if (adv.getName().endsWith(name) && this.checkUserAdv(adv, name)) {
                            return adv;
                        }
                    }
                    catch (Exception e) {
                        continue;
                    }
                    if (!this.checkUserAdv(adv, name)) continue;
                    return adv;
                }
            }
            catch (Exception e) {
                this.println("sftp: Exception locating advertisement = " + e.getMessage());
            }
        }
        this.discovery.getRemoteAdvertisements(null, 2, "Name", "JxtaSftpUserName." + name, 2, null);
        int i = 0;
        block11: while (true) {
            try {
                if (i > 5) {
                    this.println("");
                    break;
                }
                Thread.sleep(2000L);
                this.print(".");
                ++i;
            }
            catch (Exception e) {
                this.println("jftpd: Exception locating advertisement = " + e.getMessage());
            }
            try {
                enumeration = this.discovery.getLocalAdvertisements(2, "Name", "JxtaSftpUserName." + name);
                if (enumeration == null || !enumeration.hasMoreElements()) continue;
                PipeAdvertisement adv = null;
                while (true) {
                    if (!enumeration.hasMoreElements()) continue block11;
                    try {
                        adv = (PipeAdvertisement)enumeration.nextElement();
                    }
                    catch (Exception e) {
                        continue;
                    }
                    if (this.checkUserAdv(adv, name)) break;
                }
                return adv;
            }
            catch (Exception e) {
                this.println("jftpd: Exception locating advertisement = " + e.getMessage());
            }
        }
        return null;
    }

    private void runDaemon(String name, PipeAdvertisement adv) {
        this.userAdv = adv;
        this.userName = name;
        this.thread = new Thread((Runnable)this, "Jftpd:Jftpd Deamon");
        this.thread.start();
        ShellObject shellObject = this.env.add("sftpd." + name + "@" + this.group.getPeerGroupAdvertisement().getName(), new ShellObject("Sftpd Deamon for " + name + "@" + this.group.getPeerGroupAdvertisement().getName(), this));
    }

    private void stopDaemon(String name) {
        String dname = "sftpd." + name + "@" + this.group.getPeerGroupAdvertisement().getName();
        ShellObject obj = this.env.get(dname);
        if (obj == null) {
            this.println("sftp: Daemon(" + dname + ") for " + name + " not found");
            return;
        }
        sftp d = null;
        try {
            d = (sftp)obj.getObject();
            d.thread.interrupt();
            this.env.remove(dname);
        }
        catch (Exception e) {
            this.println("sftp: cannot stop daemon for " + name);
        }
    }

    public void run() {
        try {
            InputPipe pipeIn = null;
            try {
                pipeIn = this.pipes.createInputPipe(this.userAdv);
            }
            catch (Exception e) {
                return;
            }
            if (pipeIn == null) {
                this.println("sftpd: cannot open InputPipe");
                return;
            }
            Message msg = null;
            int i = 0;
            File f = null;
            FileOutputStream fout = null;
            String fileName = null;
            int fsize = 0;
            int offset = 0;
            long stime = 0L;
            while (true) {
                byte[] data;
                try {
                    while ((msg = pipeIn.waitForMessage()) == null) {
                        if (Thread.interrupted()) {
                            this.println("sftpd: stop listening for user " + this.userName);
                            pipeIn.close();
                            return;
                        }
                        this.println("NULL msg");
                    }
                }
                catch (Exception e) {
                    pipeIn.close();
                    return;
                }
                Object ip = null;
                StringEnumeration stringEnumeration = msg.getNames();
                if (stringEnumeration == null || !stringEnumeration.hasMoreElements()) continue;
                String senderName = "Anonymous";
                if (i++ == 0) {
                    fout = null;
                    String fileInfo = msg.getString(FileInfo);
                    if (fileInfo == null) {
                        pipeIn.close();
                        this.println("ftpd: bad message received. Stopping daemon for user :" + this.userName);
                        this.env.remove("sftpd." + this.userName + "@" + this.group.getPeerGroupAdvertisement().getName());
                        return;
                    }
                    int j = fileInfo.indexOf("\n");
                    fileName = fileInfo.substring(0, j);
                    String ofile = this.fdir + fileName;
                    try {
                        f = new File(ofile);
                        if (f.exists()) {
                            f.delete();
                        }
                        if (f.createNewFile()) {
                            fout = new FileOutputStream(f);
                        }
                    }
                    catch (Exception e) {
                        this.println("sftpd: Could not create output file " + ofile + "\n       Exception = " + e.getMessage());
                        this.println("Will receive but not write the data");
                        fout = null;
                    }
                    String filesize = fileInfo.substring(j + 1);
                    Integer isize = new Integer(filesize);
                    fsize = isize;
                    offset = 0;
                    stime = System.currentTimeMillis();
                }
                senderName = msg.getString(SenderName);
                if (i == 1) {
                    this.println("\nReceive " + fileName + "[" + fsize + " bytes] from " + senderName);
                }
                if ((data = msg.getBytes(JftpData)) == null) {
                    this.println("sftpd: user " + senderName + " sent empty data");
                    continue;
                }
                if (fout != null) {
                    fout.write(data, 0, data.length);
                }
                if ((offset += data.length) == fsize) {
                    this.println("! Done");
                    i = 0;
                    if (fout != null) {
                        fout.close();
                    }
                    long elapsedTime = System.currentTimeMillis() - stime;
                    long kbpsec = (long)fsize / elapsedTime;
                    float secs = (float)((double)elapsedTime / 1000.0);
                    this.println("Received: " + fsize + " bytes in " + secs + " secs[" + kbpsec + "Kbytes/sec]");
                    continue;
                }
                this.print("!");
            }
        }
        catch (Throwable all) {
            System.out.flush();
            System.err.println("Uncaught Throwable in thread :" + Thread.currentThread().getName());
            all.printStackTrace(System.err);
            return;
        }
    }

    public String getDescription() {
        return "Send a file to another peer";
    }

    public void help() {
        this.println("NAME");
        this.println("    sftp - send a file to another peer ");
        this.println(" ");
        this.println("SYNOPSIS");
        this.println(" ");
        this.println("    sftp -register <userName>");
        this.println("    sftp -login <userName>");
        this.println("    sftp -logout <userName>");
        this.println("    sftp -s <user> <userName> <fileName>");
        this.println(" ");
        this.println("DESCRIPTION");
        this.println(" ");
        this.println("The 'sftp command implements a secure file transfer");
        this.println("where one peer can send a file to a second.");
        this.println("to use 'sftp'. The user needs to register himself. This is done");
        this.println("via the following steps:");
        this.println("Step 1: Register via 'sftp -register <username>' command. This command");
        this.println("        creates a secure sftp advertisement for that user. This has to");
        this.println("        be done only once, the first time the user registers with");
        this.println("        sftp. The system remembers it across reboot.");
        this.println(" ");
        this.println("Step 2: Login  via 'sftp -login <username>' command. This command");
        this.println("        login the user and start a listener daemon. This has to");
        this.println("        to be done everytime the peer is restarted.");
        this.println(" ");
        this.println("Step 3: User can securely send a file to another user via the command");
        this.println("        'sftp -s <myusername> <destusername> <filename>'. This will send the");
        this.println("        file <filename> to the dest. The file is written on the sftp");
        this.println("        subdirectory of the directory where the shell is started.");
        this.println(" ");
        this.println("         JXTA>sftp -s moi mike photo.gif");
        this.println("         sftp is connected to user mike");
        this.println("         Sending file photo.gif, size = 55692 bytes");
        this.println("  ");
        this.println("To stop receiving any more files the user can stop the sftp");
        this.println("listener daemon by entering the command 'sftp -logout <username>'");
        this.println(" ");
        this.println("OPTIONS");
        this.println(" ");
        this.println("    -register register a new user name  ");
        this.println("    -login    log user and set default user");
        this.println("    -logout   logout");
        this.println("    -s        specify current user, and file names");
        this.println(" ");
        this.println("EXAMPLE");
        this.println(" ");
        this.println("      JXTA>sftp -register me");
        this.println("      JXTA>sftp -login me");
        this.println("      JXTA>sftp -s me you /tmp/nihow.jpg");
        this.println(" ");
        this.println("This example shows how a new user 'me'  can register and log into sftp,");
        this.println("and send a file to the user 'you'. User 'you' needs to be similarly");
        this.println("registered and logged on. The above file is written as sftp/nihow.jpg");
        this.println(" ");
        this.println("SEE ALSO");
    }

    static {
        WaitingTime = 2000;
        MAXRETRIES = 5;
        SftpNameTag = SftpNameTag;
        SftpIDTag = SftpIDTag;
        EnvName = EnvName;
        SenderName = SenderName;
        JftpData = JftpData;
        FileInfo = FileInfo;
        fdirname = fdirname;
        OBUFLEN = 15000;
    }
}

