/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.shell.bin.send;

import net.jxta.endpoint.Message;
import net.jxta.impl.shell.ShellApp;
import net.jxta.impl.shell.ShellEnv;
import net.jxta.impl.shell.ShellObject;
import net.jxta.pipe.OutputPipe;

public class send
extends ShellApp {
    ShellEnv env;

    public void stopApp() {
    }

    public int startApp(String[] args) {
        if (args == null || args.length != 2) {
            this.println("error: send <OutputPipe> <PipeMessage>");
            return 1;
        }
        this.env = this.getEnv();
        String pipe = args[0];
        ShellObject obj = this.env.get(pipe);
        if (obj == null) {
            this.println("send: cannot access " + pipe);
            return Integer.MAX_VALUE;
        }
        OutputPipe op = null;
        try {
            op = (OutputPipe)obj.getObject();
        }
        catch (Exception e) {
            this.println("send: " + pipe + " is not an OutputPipe");
            this.println(e.toString());
            return Integer.MAX_VALUE;
        }
        if (op == null) {
            this.println("send: cannot access pipe" + pipe);
            return Integer.MAX_VALUE;
        }
        String m = args[1];
        obj = this.env.get(m);
        if (obj == null) {
            this.println("send: cannot access " + m);
            return Integer.MAX_VALUE;
        }
        Message msg = null;
        try {
            msg = (Message)obj.getObject();
        }
        catch (Exception e) {
            this.println("send: " + m + " is not a Message");
            this.println(e.toString());
            return Integer.MAX_VALUE;
        }
        if (msg == null) {
            this.println("send: cannot access msg" + m);
            return Integer.MAX_VALUE;
        }
        try {
            op.send(msg);
        }
        catch (Exception e) {
            this.println("send: IOException");
            e.printStackTrace();
            return Integer.MAX_VALUE;
        }
        return 0;
    }

    public String getDescription() {
        return "Send a message into a pipe";
    }

    public void help() {
        this.println("NAME");
        this.println("     send - send a message into a pipe");
        this.println(" ");
        this.println("SYNOPSIS");
        this.println("     send <output pipe> <msg>");
        this.println(" ");
        this.println("DESCRIPTION");
        this.println(" ");
        this.println("'send' sends a message into an output pipe. The output pipe needs");
        this.println("to have been previously created via a pipe advertisement.");
        this.println(" ");
        this.println("EXAMPLE");
        this.println(" ");
        this.println("    JXTA> pipeadv = mkadv -p");
        this.println("    JXTA> outpipe = mkpipe -o pipeadv");
        this.println("    JXTA> send outpipe msg");
        this.println(" ");
        this.println("This example creates a pipe advertisement 'pipeadv',");
        this.println("creates an output pipe 'outpipe' and sends the message 'msg'");
        this.println("through the pipe.");
        this.println(" ");
        this.println("SEE ALSO");
        this.println("    mkmsg put get recv mkadv mkpipe");
    }
}

