/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.shell.bin.put;

import net.jxta.document.StructuredDocument;
import net.jxta.endpoint.Message;
import net.jxta.impl.shell.ShellApp;
import net.jxta.impl.shell.ShellEnv;
import net.jxta.impl.shell.ShellObject;

public class put
extends ShellApp {
    ShellEnv env;

    public void stopApp() {
    }

    private int syntaxError() {
        this.println("usage: put <msg> <name> <document>");
        return 1;
    }

    public int startApp(String[] args) {
        if (args == null || args.length != 3) {
            return this.syntaxError();
        }
        this.env = this.getEnv();
        ShellObject obj = this.env.get(args[0]);
        if (obj == null) {
            this.println("put: cannot access " + args[0]);
            return Integer.MAX_VALUE;
        }
        Message msg = null;
        try {
            msg = (Message)obj.getObject();
        }
        catch (Exception e) {
            this.println("put: " + args[0] + " is not a Message");
            return Integer.MAX_VALUE;
        }
        if (msg == null) {
            this.println("put: " + args[0] + " is empty");
            return Integer.MAX_VALUE;
        }
        String name = args[1];
        obj = this.env.get(args[2]);
        if (obj == null) {
            this.println("put: cannot access " + args[2]);
            return Integer.MAX_VALUE;
        }
        StructuredDocument doc = null;
        try {
            doc = (StructuredDocument)obj.getObject();
        }
        catch (Exception e) {
            this.println("put: " + args[2] + " is not a StructuredDocument");
            return Integer.MAX_VALUE;
        }
        if (doc == null) {
            this.println("put: " + args[2] + " is empty");
            return Integer.MAX_VALUE;
        }
        try {
            msg.addElement(msg.newMessageElement(name, null, doc.getStream()));
        }
        catch (Exception e) {
            this.println("put: failed reason:");
            this.println(e.toString());
            return Integer.MAX_VALUE;
        }
        return 0;
    }

    public String getDescription() {
        return "Put data into a pipe message";
    }

    public void help() {
        this.println("NAME");
        this.println("     put - put data into a pipe message");
        this.println(" ");
        this.println("SYNOPSIS");
        this.println("     put <msg> <tag> <document>");
        this.println(" ");
        this.println("DESCRIPTION");
        this.println(" ");
        this.println("'put' store a document into the body of message.JXTA messages are");
        this.println("composed a set of tag body, each identified with an unique tag name");
        this.println("A message tag name is supplied to specify which tag name");
        this.println("is used to store the document. On the receiving end the document");
        this.println("can be retrieved via the 'get' command.");
        this.println(" ");
        this.println("EXAMPLE");
        this.println(" ");
        this.println("    JXTA> importfile -f /home/tra/myfile mydata");
        this.println("    JXTA> msg = mkmsg");
        this.println("    JXTA> put msg mytag mydata");
        this.println(" ");
        this.println("This example creates a document 'mydata' by importing data from the file");
        this.println("'/home/tra/myfile'. Then, we create a pipe message 'msg' and store the document");
        this.println("'mydata' into the message 'msg' with the associated tag name 'mytag'.");
        this.println(" ");
        this.println("SEE ALSO");
        this.println("    mkmsg get send recv mkadv mkpipe");
    }
}

