/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.shell.bin.mkpgrp;

import net.jxta.document.Advertisement;
import net.jxta.document.AdvertisementFactory;
import net.jxta.document.TextElement;
import net.jxta.impl.shell.ShellApp;
import net.jxta.impl.shell.ShellEnv;
import net.jxta.impl.shell.ShellObject;
import net.jxta.peergroup.PeerGroup;
import net.jxta.protocol.ModuleImplAdvertisement;
import net.jxta.protocol.PeerGroupAdvertisement;

public class mkpgrp
extends ShellApp {
    private ShellEnv env;
    private String name = null;
    private String advDoc = null;
    private boolean pubFlag = true;
    private PeerGroupAdvertisement adv = null;
    private ShellObject obj = null;
    private PeerGroup parent = null;
    static /* synthetic */ Class class$net$jxta$document$StructuredTextDocument;

    public int startApp(String[] args) {
        PeerGroup pg;
        if (args == null || args.length < 1) {
            this.println("You need to give the name of group at least");
            return this.syntaxError();
        }
        this.env = this.getEnv();
        int i = 0;
        this.name = null;
        i = 0;
        while (i < args.length) {
            if (args[i].equals("-d")) {
                this.advDoc = args[++i];
            } else if (args[i].equals("-p")) {
                this.pubFlag = false;
            } else {
                if (args[i].equals("-m")) {
                    this.println("MembershipService service  not implemented yet");
                    return Integer.MAX_VALUE;
                }
                this.name = args[i];
            }
            ++i;
        }
        if (this.name == null && this.advDoc == null) {
            return this.syntaxError();
        }
        this.obj = this.env.get("rootgroup");
        if (this.obj == null) {
            this.obj = this.env.get("stdgroup");
        }
        this.parent = (PeerGroup)this.obj.getObject();
        if (this.advDoc != null) {
            this.obj = this.env.get(this.advDoc);
            if (this.obj == null) {
                this.println("mkpgrp: cannot access " + this.advDoc);
                return Integer.MAX_VALUE;
            }
            try {
                this.adv = (class$net$jxta$document$StructuredTextDocument == null ? (class$net$jxta$document$StructuredTextDocument = mkpgrp.class$("net.jxta.document.StructuredTextDocument")) : class$net$jxta$document$StructuredTextDocument).isAssignableFrom(this.obj.getObjectClass()) ? (PeerGroupAdvertisement)AdvertisementFactory.newAdvertisement((TextElement)((TextElement)this.obj.getObject())) : (PeerGroupAdvertisement)this.obj.getObject();
                this.name = this.adv.getName();
                if (this.exist(this.name)) {
                    this.println("a group of this name already exists");
                    return Integer.MAX_VALUE;
                }
                pg = this.parent.newGroup((Advertisement)this.adv);
            }
            catch (Exception e) {
                this.println("mkpgrp: " + this.name + " is not a proper PeerGroup advertisement");
                e.printStackTrace();
                return Integer.MAX_VALUE;
            }
        }
        if (this.exist(this.name)) {
            this.println("a group of this name already exists");
            return Integer.MAX_VALUE;
        }
        try {
            ModuleImplAdvertisement implAdv = this.parent.getAllPurposePeerGroupImplAdvertisement();
            pg = this.parent.newGroup(null, (Advertisement)implAdv, this.name, "Created by mkpgrp");
            this.adv = pg.getPeerGroupAdvertisement();
        }
        catch (Exception eee) {
            this.println("Group creation failed with " + eee.toString());
            return Integer.MAX_VALUE;
        }
        if (this.pubFlag) {
            try {
                this.parent.getDiscoveryService().remotePublish((Advertisement)this.adv, 1);
            }
            catch (Exception ee) {
                this.println("Remote published failed with " + ee.toString());
            }
        }
        if (this.env != null) {
            this.env.add("PG#" + this.name, new ShellObject("PeerGroup", pg));
            return 0;
        }
        this.println("lost the parent Shell frame, this is bad !");
        return 1;
    }

    private boolean exist(String name) {
        ShellObject obj = this.env.get("PG#" + name);
        if (obj == null) {
            obj = this.env.get("PG@" + name);
            return obj != null;
        }
        return true;
    }

    public void stopApp() {
    }

    public int syntaxError() {
        this.println("Usage: mkpgrp [-d doc] [-p] [-m service] name");
        return 1;
    }

    public String getDescription() {
        return "Create a new peer group";
    }

    public void help() {
        this.println("NAME");
        this.println("     mkpgrp - create a new peer group");
        this.println(" ");
        this.println("SYNOPSIS");
        this.println(" ");
        this.println("     mkpgrp [-d <doc>] [-p ] [-m <service>]  <name>");
        this.println(" ");
        this.println("DESCRIPTION");
        this.println(" ");
        this.println("mkgrp creates a new peer group using the supplied peer group advertisement");
        this.println("If no advertisement is provided. The command will create a clone");
        this.println("of the NetPeerGroup peer group with the name specified.");
        this.println("The command 'mkadv -g' is used to create a peer group advertisment");
        this.println("The environment variable 'PG#<group name>' is created to store the");
        this.println("the new group info. The new peer group is advertised in the");
        this.println("NetPeerGroup. All peer groups are created in the NetPeerGroup which");
        this.println("acts like a world peer group.Every peer group can be found in this");
        this.println("group. By default mkpgrp remotely publishes the newly created group,");
        this.println("to skip remote publish specify -p.");
        this.println(" ");
        this.println("OPTIONS");
        this.println("");
        this.println("     [-d doc]    specify an environment variable that contain a");
        this.println("                 peergroup advertisment");
        this.println("     [-m service] specify a membership service");
        this.println("     [-p] do not remotely publish");
        this.println("     name        specify the name for the peergroup");
        this.println(" ");
        this.println("EXAMPLE");
        this.println(" ");
        this.println("          JXTA>mygroupadv = mkadv -g");
        this.println("          JXTA>mypgrp = mkpgrp -d mygroupadv mygroup");
        this.println(" ");
        this.println(" This creates a new peergroup which is cloning the services");
        this.println(" of the parent peer group. You can find the services of the");
        this.println(" current peergroup via the command 'whoami -g'. The new group");
        this.println(" is given the name 'mygroup'. Before you can do anything with");
        this.println(" the group you need to join the group via the 'join' command.");
        this.println(" ");
        this.println("SEE ALSO");
        this.println("    whoami join leave peers chpgrp mkadv");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

