/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.shell.bin.mkmsg;

import net.jxta.endpoint.Message;
import net.jxta.impl.shell.ShellApp;
import net.jxta.impl.shell.ShellEnv;
import net.jxta.impl.shell.ShellObject;

public class mkmsg
extends ShellApp {
    ShellEnv env;

    public void stopApp() {
    }

    public int startApp(String[] args) {
        if (args.length > 0) {
            this.println("error: mkmsg");
            this.shortHelp();
            return 1;
        }
        this.env = this.getEnv();
        Message msg = this.pipes.createMessage();
        if (msg == null) {
            this.println("mkmsg: cannot create a Message");
            return Integer.MAX_VALUE;
        }
        ShellObject old = this.env.add(this.getReturnVariable(), new ShellObject("Message", msg));
        return 0;
    }

    public void shortHelp() {
        this.println("NAME");
        this.println("     mkmsg - make a pipe message");
        this.println(" ");
        this.println("SYNOPSIS");
        this.println("     mkmsg ");
        this.println(" ");
    }

    public String getDescription() {
        return "Make a pipe message";
    }

    public void help() {
        this.println("NAME");
        this.println("     mkmsg - make a pipe message");
        this.println(" ");
        this.println("SYNOPSIS");
        this.println("     mkmsg ");
        this.println(" ");
        this.println("DESCRIPTION");
        this.println(" ");
        this.println("'mkmsg' creates a new message to send/receive data from a pipe.");
        this.println("The message object is stored in a Shell environment variable.");
        this.println("If no name is assigned via the '=' operator, a default");
        this.println("environment variable is created 'env#' for holding the");
        this.println("message object (# is a growing integer number).");
        this.println(" ");
        this.println("JXTA messages are composed of multiple tag body parts. Each");
        this.println("tag body is uniquely identified via a unique tag name. The tag");
        this.println("name is used to insert ('put' command) a new tag body in a message,");
        this.println("or to retrieve ('get' command) a tag body from a message");
        this.println(" ");
        this.println("EXAMPLE");
        this.println(" ");
        this.println("      JXTA>mkmsg");
        this.println("             ");
        this.println("This creates a message object and puts it in the environment");
        this.println("variable 'env#' where # is an integer number (ex. env4)");
        this.println("You can assign a specific name to the message variable by assigning");
        this.println("it a name via the '=' Shell operator. See below for example:");
        this.println(" ");
        this.println("      JXTA>mymsg = mkmsg");
        this.println("      JXAT>put mymsg mytag data");
        this.println("      JXTA>send outpipe mymsg");
        this.println(" ");
        this.println("This create a new msg 'mymsg', stored data in the message body tag 'mytag'.");
        this.println("The message is then sent via the output pipe 'outpipe'");
        this.println(" ");
        this.println("SEE ALSO");
        this.println("    send recv get put mkpipe mkadv ");
    }
}

