/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.shell.bin.mkadv;

import net.jxta.discovery.DiscoveryService;
import net.jxta.document.Advertisement;
import net.jxta.document.AdvertisementFactory;
import net.jxta.document.StructuredTextDocument;
import net.jxta.document.TextElement;
import net.jxta.id.ID;
import net.jxta.id.IDFactory;
import net.jxta.impl.shell.ShellApp;
import net.jxta.impl.shell.ShellEnv;
import net.jxta.impl.shell.ShellObject;
import net.jxta.peergroup.PeerGroup;
import net.jxta.peergroup.PeerGroupID;
import net.jxta.protocol.ModuleImplAdvertisement;
import net.jxta.protocol.PeerGroupAdvertisement;
import net.jxta.protocol.PipeAdvertisement;

public class mkadv
extends ShellApp {
    private ShellEnv env;
    private String name = null;
    private String advDoc = null;
    private String var = null;
    PeerGroup parent;
    DiscoveryService discovery;

    public void stopApp() {
    }

    private int syntaxError() {
        this.println("Usage: mkadv -g|p [[-t type] [-d doc] [name]]");
        return 1;
    }

    public int startApp(String[] args) {
        if (args == null || args.length < 1) {
            return this.syntaxError();
        }
        this.discovery = this.group.getDiscoveryService();
        this.env = this.getEnv();
        int i = 0;
        this.name = null;
        i = 1;
        while (i < args.length) {
            if (args[i].equals("-t")) {
                this.println("PipeServiceService type is not supported yet");
                return this.syntaxError();
            }
            if (args[i].equals("-d")) {
                this.advDoc = args[++i];
            } else {
                this.name = args[i];
            }
            ++i;
        }
        if (args[0].equals("-p")) {
            return this.createPipeAdv(args);
        }
        if (args[0].equals("-g")) {
            return this.createPGroupAdv(args);
        }
        return this.syntaxError();
    }

    private int createPGroupAdv(String[] args) {
        block9: {
            try {
                PeerGroupAdvertisement adv2;
                ModuleImplAdvertisement implAdv;
                if (this.advDoc != null) {
                    ShellObject obj = this.env.get(this.advDoc);
                    if (obj == null) {
                        this.println("mkadv: cannot access " + this.advDoc);
                        return Integer.MAX_VALUE;
                    }
                    try {
                        StructuredTextDocument doc = null;
                        doc = (StructuredTextDocument)obj.getObject();
                        PeerGroupAdvertisement adv2 = (PeerGroupAdvertisement)AdvertisementFactory.newAdvertisement((TextElement)doc);
                        break block9;
                    }
                    catch (Exception e) {
                        this.println("mkadv: " + this.advDoc + " is not a proper PeerGroup advertisement");
                        return Integer.MAX_VALUE;
                    }
                }
                if (this.name == null) {
                    this.println("missing argument need to give a name to the group");
                    return this.syntaxError();
                }
                this.parent = (PeerGroup)this.env.get("stdgroup").getObject();
                try {
                    implAdv = this.parent.getAllPurposePeerGroupImplAdvertisement();
                    this.parent.getDiscoveryService().publish((Advertisement)implAdv, 2);
                    PeerGroupID gid = IDFactory.newPeerGroupID();
                    adv2 = (PeerGroupAdvertisement)AdvertisementFactory.newAdvertisement((String)PeerGroupAdvertisement.getAdvertisementType());
                }
                catch (Exception e) {
                    this.println("mkadv: failed with exception " + e.toString());
                    e.printStackTrace();
                    return Integer.MAX_VALUE;
                }
                adv2.setName(this.name);
                adv2.setModuleSpecID(implAdv.getModuleSpecID());
                adv2.setPeerGroupID(IDFactory.newPeerGroupID());
                adv2.setDescription("created by mkadv");
                ShellObject old = this.env.add(this.getReturnVariable(), new ShellObject("PeerGroup Advertisement", adv2));
            }
            catch (Throwable anything) {
                anything.printStackTrace();
                return Integer.MAX_VALUE;
            }
        }
        return 0;
    }

    private int createPipeAdv(String[] args) {
        ShellObject obj;
        PipeAdvertisement adv = null;
        if (this.advDoc != null) {
            obj = this.env.get(this.advDoc);
            if (obj == null) {
                this.println("mkadv: cannot access " + this.advDoc);
                return Integer.MAX_VALUE;
            }
            try {
                StructuredTextDocument doc = null;
                doc = (StructuredTextDocument)obj.getObject();
                adv = (PipeAdvertisement)AdvertisementFactory.newAdvertisement((TextElement)doc);
            }
            catch (Exception e) {
                this.println("mkadv: " + this.advDoc + " is not a proper pipe advertisement");
                e.printStackTrace();
                return Integer.MAX_VALUE;
            }
        }
        try {
            obj = this.env.get("stdgroup");
            PeerGroup group = (PeerGroup)obj.getObject();
            adv = (PipeAdvertisement)AdvertisementFactory.newAdvertisement((String)PipeAdvertisement.getAdvertisementType());
            adv.setPipeID((ID)IDFactory.newPipeID((PeerGroupID)group.getPeerGroupID()));
            adv.setName(this.name);
            try {
                this.discovery.publish((Advertisement)adv, 2);
            }
            catch (Exception e) {
                this.println("could no find the service");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return Integer.MAX_VALUE;
        }
        if (adv == null) {
            this.println("Cannot create a new PipeServiceService Advertisement");
            return Integer.MAX_VALUE;
        }
        ShellObject old = this.env.add(this.getReturnVariable(), new ShellObject("PipeServiceService Advertisement", adv));
        return 0;
    }

    public String getDescription() {
        return "Make an advertisement";
    }

    public void help() {
        this.println("NAME");
        this.println("     mkadv - make an advertisement");
        this.println(" ");
        this.println("SYNOPSIS");
        this.println("     mkadv -g|p [[-t <pipetype>] [-d <doc>] [<name>]]");
        this.println(" ");
        this.println("DESCRIPTION");
        this.println(" ");
        this.println("'mkadv' creates a peer group or pipe advertisement from a document");
        this.println("stored in a shell environment variable. A specific type can be");
        this.println("given for the pipe (TBD). A symbolic name can be associated with");
        this.println("the advertisement. This name can be used to search for the");
        this.println("advertisement. A name must be supplied when creating a new");
        this.println("group advertisement. This is the name of the peer group.");
        this.println(" ");
        this.println("OPTIONS");
        this.println(" ");
        this.println("  -p is used to create a pipe advertisement.");
        this.println("  -t is only valid for pipe and define the type of pipes (TBD)");
        this.println("  -g option is used to create a new peer group advertisement");
        this.println("     if no document is given a clone of the current peergroup");
        this.println("     is created. The new peer group will have the same services");
        this.println("     and endpoints that the current group. if a doc argument is");
        this.println("     supplied, the document must be a peer group advertisement and");
        this.println("     is used to create the new peer group.");
        this.println("  -d specifies a Shell environment variable that contains a structured that hold an advertisement");
        this.println("     document that holds an advertisement");
        this.println(" ");
        this.println("EXAMPLE");
        this.println(" ");
        this.println("      JXTA>importfile -f saveadv groupadv");
        this.println("      JXTA>mygroupadv = mkadv -g -d groupadv");
        this.println("      JXTA>mkpgrp -d mygroupadv mygroup");
        this.println(" ");
        this.println(" This creates a new peergroup from an advertisement that was created");
        this.println(" from a StructuredDocument that was stored in the Shell environment");
        this.println(" variable 'groupadv'.You can check the services of the");
        this.println(" new peergroup after it has been created via the command 'whoami -g'.");
        this.println(" The new group is given the name 'mygroup'. Before you can do anything");
        this.println(" with the group, you need to join the group via the 'join' command.");
        this.println(" ");
        this.println("SEE ALSO");
        this.println("     mkpipe mkpgrp join whoami");
    }
}

