/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.shell.bin.man;

import net.jxta.impl.shell.ShellApp;
import net.jxta.impl.shell.ShellCmds;

public class man
extends ShellApp {
    ShellCmds cmds;

    public void stopApp() {
    }

    private String formatString(String str, int strWidth) {
        StringBuffer buf = new StringBuffer(str);
        while (buf.length() < strWidth) {
            buf.append(' ');
        }
        return buf.toString();
    }

    public int startApp(String[] args) {
        if (args.length > 1) {
            this.println("error: man [command]");
            return 1;
        }
        this.cmds = new ShellCmds(this);
        if (args.length == 0) {
            this.selfHelp();
            return 0;
        }
        String cmd = args[0];
        try {
            ShellApp app = this.cmds.getInstance(cmd);
            app.setOutputPipe(this.outputPipe);
            app.setGroup(this.group);
            app.help();
            return 0;
        }
        catch (Exception e) {
            this.println("man: cannot find " + cmd);
            return Integer.MAX_VALUE;
        }
    }

    private ShellApp getCmdInstance(String cmd) throws Exception {
        ShellApp app = this.cmds.getInstance(cmd);
        app.setOutputPipe(this.outputPipe);
        app.setGroup(this.group);
        return app;
    }

    private void printDescription(String cmd, int maxWidth) {
        try {
            ShellApp app = this.getCmdInstance(cmd);
            String descr = app.getDescription();
            this.println(this.formatString(cmd, maxWidth) + "  " + descr);
        }
        catch (Exception e) {
            this.println("man: cannot find " + cmd);
        }
    }

    private void selfHelp() {
        this.println("The 'man' command is the primary manual system for the JXTA Shell.");
        this.println("The usage of man is:");
        this.println(" ");
        this.println("   JXTA> man <commandName>");
        this.println(" ");
        this.println("  For instance typing");
        this.println("   JXTA> man Shell");
        this.println("         displays man page about the Shell");
        this.println(" ");
        this.println("The following is the list of commands available:");
        this.println(" ");
        try {
            String[] names = this.cmds.list();
            int maxWidth = 0;
            int i = 0;
            while (i < names.length) {
                maxWidth = Math.max(maxWidth, names[i].length());
                ++i;
            }
            int i2 = 0;
            while (i2 < names.length) {
                this.printDescription(names[i2], maxWidth);
                ++i2;
            }
        }
        catch (Exception e) {
            this.println("man: " + e.getMessage());
            e.printStackTrace();
        }
        this.println(" ");
    }

    public String getDescription() {
        return "An on-line help command that displays information about a specific Shell command";
    }

    public void help() {
        this.println("NAME");
        this.println("     man - get man page info about a command");
        this.println(" ");
        this.println("SYNOPSIS");
        this.println("     man  <command>");
        this.println(" ");
        this.println("DESCRIPTION");
        this.println("'man' is an on-line help command that displays information about a");
        this.println("specific Shell command.");
        this.println(" ");
        this.println("EXAMPLE");
        this.println(" ");
        this.println("       JXTA> man mkpgrp");
        this.println(" ");
        this.println("This will display information about the mkpgrp command");
        this.println(" ");
        this.println("SEE ALSO");
    }
}

