/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.shell.bin.leave;

import net.jxta.impl.shell.ShellApp;
import net.jxta.impl.shell.ShellEnv;
import net.jxta.impl.shell.ShellObject;
import net.jxta.membership.MembershipService;
import net.jxta.peergroup.PeerGroup;
import net.jxta.peergroup.PeerGroupFactory;
import net.jxta.protocol.PeerGroupAdvertisement;

public class leave
extends ShellApp {
    private ShellEnv env;
    private String name = null;
    private String advDoc = null;
    private PeerGroupAdvertisement adv = null;
    private PeerGroup pg = PeerGroupFactory.newPeerGroup();
    private ShellObject obj = null;
    private PeerGroup parent = null;

    public int startApp(String[] args) {
        boolean stopGrp = false;
        this.env = this.getEnv();
        if (args.length != 0) {
            if (args.length == 1 && args[0].equals("-k")) {
                stopGrp = true;
            } else {
                return this.syntaxError();
            }
        }
        ShellObject obj = this.env.get("stdgroup");
        PeerGroup pg = (PeerGroup)obj.getObject();
        String name = pg.getPeerGroupAdvertisement().getName();
        obj = this.env.get("PG@" + name);
        if (obj == null) {
            this.println("Sorry we cannot find any current peer group");
            return 1;
        }
        PeerGroup npg = (PeerGroup)obj.getObject();
        try {
            MembershipService membership = npg.getMembershipService();
            membership.resign();
        }
        catch (Exception all) {
            this.println("sorry we could not resign from the group.");
        }
        this.env.remove("PG@" + name);
        if (stopGrp) {
            npg.stopApp();
        } else {
            this.env.add("PG#" + name, new ShellObject("PeerGroup", npg));
        }
        obj = this.env.get("rootgroup");
        if (obj == null) {
            this.println("sorry we cannot find the rootgroup variable, please define it");
        }
        pg = (PeerGroup)obj.getObject();
        this.env.add("stdgroup", new ShellObject("PeerGroup", pg));
        return 0;
    }

    public void stopApp() {
    }

    public int syntaxError() {
        this.println("Usage: leave");
        return 1;
    }

    public String getDescription() {
        return "Leave a peer group";
    }

    public void help() {
        this.println("NAME");
        this.println("     leave - leave a peer group");
        this.println(" ");
        this.println("SYNOPSIS");
        this.println(" ");
        this.println("     leave [-k]");
        this.println(" ");
        this.println("DESCRIPTION");
        this.println(" ");
        this.println("The 'leave' command is used to leave a group that was previously joined");
        this.println("via a 'join' command. The 'join' command is used to join a peergroup.");
        this.println("After leaving the group, the Shell 'stdgroup' variable");
        this.println("is reset to the value of the default 'rootgroup' variable (NetPeerGroup).");
        this.println("If the -k option was used, then this instance of the group is stopped and deleted.");
        this.println("Before a user can use the group again, the user will have to rejoin");
        this.println("the group via the 'join' command.");
        this.println(" ");
        this.println("EXAMPLE");
        this.println(" ");
        this.println("      JXTA>mygroupadv = mkadv -g mygroup");
        this.println("      JXTA>mkpgrp -d mygroupadv mygroup");
        this.println("      JXTA>join mygroup");
        this.println("      JXTA>leave");
        this.println(" ");
        this.println(" This creates a new peergroup which is cloning the services");
        this.println(" of the parent peer group (NetPeerGroup). You can find the services of the");
        this.println(" current peergroup via the command 'whoami -g'. The new group");
        this.println(" is given the name 'mygroup'. Before you can do anything with");
        this.println(" the group you need to join the group via the 'join' command.");
        this.println(" the 'leave' command is used to leave the group.");
        this.println(" ");
        this.println("SEE ALSO");
        this.println("    mkadv mkpgrp join chpgrp ");
    }
}

