/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.shell.bin.instjar;

import java.io.File;
import java.util.Vector;
import net.jxta.impl.shell.ShellApp;
import net.jxta.impl.shell.ShellCmds;

public class instjar
extends ShellApp {
    private Vector instJarList;
    protected ShellCmds cmds;

    public void stopApp() {
    }

    private static String formatNumber(int num, int strLen) {
        StringBuffer buf = new StringBuffer();
        buf.append(num);
        while (buf.length() < strLen) {
            buf.insert(0, ' ');
        }
        return buf.toString();
    }

    protected void showInstalledJars() {
        int maxNumWidth = (this.instJarList.size() + "").length();
        int i = 0;
        while (i < this.instJarList.size()) {
            this.println(instjar.formatNumber(i, maxNumWidth) + " " + this.instJarList.elementAt(i).toString());
            ++i;
        }
    }

    protected void installJar(File file) {
        this.instJarList.addElement(file);
    }

    public int startApp(String[] args) {
        this.cmds = new ShellCmds(this);
        this.instJarList = this.cmds.getInstJars();
        if (args.length == 0) {
            this.showInstalledJars();
            return 0;
        }
        int i = 0;
        while (i < args.length) {
            File file = new File(args[i]);
            if (file.exists()) {
                if (!this.instJarList.contains(file)) {
                    this.installJar(file);
                }
            } else {
                this.println("Error: '" + file + "' does not exist");
            }
            ++i;
        }
        this.cmds.setInstJars(this.instJarList);
        return 0;
    }

    public String getDescription() {
        return "Installs jar-files containing additional Shell commands";
    }

    public void help() {
        this.println("NAME");
        this.println("     instjar - installs one or more jar-files containing");
        this.println("     additional Shell commands.");
        this.println(" ");
        this.println("SYNOPSIS");
        this.println("     instjar [<jar-file> [...]]");
        this.println(" ");
        this.println("DESCRIPTION");
        this.println(" ");
        this.println("This command installs jar-files containing additional Shell");
        this.println("commands. An arbirtary number of paths to jar-files");
        this.println("can be supplied. If this command is invoked with no arguments");
        this.println("it lists all installed jar-files. Use the given indices to");
        this.println("uninstall jar-files with the 'uninstjar' command.");
        this.println("The class-files of a command 'xxx' must be in the package");
        this.println("'net.jxta.impl.shell.bin.xxx' and the main-class must be named");
        this.println("'net.jxta.impl.shell.bin.xxx.xxx'. Accordingly the class-files must");
        this.println("be placed in a directory 'net/jxta/impl/shell/bin/xxx/' within the");
        this.println("jar-file, and must extend the ShellApp class.");
        this.println("The list of installed jar-files is stored in the environment");
        this.println("variable 'instjars'.");
        this.println(" ");
        this.println("EXAMPLE");
        this.println(" ");
        this.println("To install two jar-files 'c:/userlib/usrcmds.jar' and");
        this.println("'c:/userlib/toolscmds.jar:");
        this.println("    JXTA>instjar c:/userlib/usrcmds.jar c:/userlib/toolcmds.jar");
        this.println(" ");
        this.println("To list all installed jar-files with their indices:");
        this.println("    JXTA> instjar");
        this.println("    0 c:/userlib/usrcmds.jar");
        this.println("    1 c:/userlib/toolcmds.jar");
        this.println("These indeces can be used to uninstall some jar-files with the");
        this.println("'uninstjar' command.");
        this.println(" ");
        this.println("SEE ALSO");
        this.println("    uninstjar ");
    }
}

