/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.shell.bin.history;

import java.util.Vector;

public class HistoryQueue {
    protected static final int MAX_HISTORY = 100;
    private Vector queue = new Vector(100);
    private int nextCommand = -1;
    private static String[] exclude;

    public HistoryQueue() {
        this(null);
    }

    public HistoryQueue(String[] exclude) {
        HistoryQueue.exclude = exclude;
    }

    public void addCommand(String cmd) {
        if (exclude != null) {
            int i = 0;
            while (i < exclude.length) {
                if (exclude[i].equals(cmd)) {
                    return;
                }
                ++i;
            }
            this.nextCommand = this.queue.size();
        }
        while (this.queue.size() >= 100) {
            this.queue.removeElementAt(0);
        }
        if (!cmd.trim().equals("")) {
            this.queue.addElement(cmd);
        }
        this.nextCommand = this.queue.size();
    }

    public void removeLastCommand() {
        if (this.queue.size() > 0) {
            this.queue.removeElementAt(this.queue.size() - 1);
            this.nextCommand = this.queue.size();
        }
    }

    public String getNextCommand() {
        --this.nextCommand;
        if (this.nextCommand < 0) {
            this.nextCommand = -1;
        }
        return this.getCommand(this.nextCommand);
    }

    public String getPreviousCommand() {
        ++this.nextCommand;
        if (this.nextCommand > this.queue.size()) {
            this.nextCommand = this.queue.size();
        }
        return this.getCommand(this.nextCommand);
    }

    public String getCommand(int index) {
        if (index < 0 || index >= this.queue.size()) {
            return "";
        }
        return (String)this.queue.elementAt(index);
    }

    public String printHistory() {
        StringBuffer buffer = new StringBuffer();
        int max = this.queue.size();
        int length = String.valueOf(100).length();
        int i = 0;
        while (i < max) {
            String number = String.valueOf(i);
            int k = 0;
            while (k++ + number.length() != length) {
                buffer.append(" ");
            }
            buffer.append(number).append(" ");
            buffer.append(this.queue.elementAt(i));
            buffer.append("\n");
            ++i;
        }
        return buffer.toString();
    }

    public String toString() {
        return "History queue";
    }

    static {
        MAX_HISTORY = 100;
        exclude = null;
    }
}

