/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.shell.bin.grep;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.StringTokenizer;
import net.jxta.document.Advertisement;
import net.jxta.document.Document;
import net.jxta.document.MimeMediaType;
import net.jxta.impl.shell.GetOpt;
import net.jxta.impl.shell.ShellApp;
import net.jxta.impl.shell.ShellEnv;
import net.jxta.impl.shell.ShellObject;

public class grep
extends ShellApp {
    protected ShellEnv env;
    protected boolean countOnly;
    protected boolean ignoreCase;
    protected boolean showLineNums;
    protected boolean invertMatch;
    protected String pattern;
    static /* synthetic */ Class class$net$jxta$document$Advertisement;
    static /* synthetic */ Class class$net$jxta$document$Document;

    public void stopApp() {
    }

    /*
     * WARNING - void declaration
     */
    public int startApp(String[] args) {
        try {
            Object objContent;
            ShellObject obj = null;
            String name = null;
            this.env = this.getEnv();
            if (args == null) {
                return this.syntaxError();
            }
            GetOpt getopt = new GetOpt(args, "cinv");
            try {
                int c;
                while ((c = getopt.getNextOption()) != -1) {
                    void var5_6;
                    switch (var5_6) {
                        case 99: {
                            this.countOnly = true;
                            break;
                        }
                        case 105: {
                            this.ignoreCase = true;
                            break;
                        }
                        case 110: {
                            this.showLineNums = true;
                            break;
                        }
                        case 118: {
                            this.invertMatch = true;
                            break;
                        }
                        default: {
                            this.println("Error: option not supported.");
                            return 1;
                        }
                    }
                }
            }
            catch (Exception ex) {
                return this.syntaxError();
            }
            int pos = getopt.getNextOptionIndex();
            if (pos >= args.length) {
                return this.syntaxError();
            }
            this.pattern = args[pos];
            if (++pos < args.length) {
                name = args[pos];
                obj = this.env.get(name);
                if (obj == null) {
                    this.println("grep: cannot access " + name);
                    return Integer.MAX_VALUE;
                }
            } else {
                this.readStdin();
                return 0;
            }
            if ((class$net$jxta$document$Advertisement == null ? (class$net$jxta$document$Advertisement = grep.class$("net.jxta.document.Advertisement")) : class$net$jxta$document$Advertisement).isInstance(objContent = obj.getObject())) {
                try {
                    this.readAdvertisement((Advertisement)objContent);
                    return 0;
                }
                catch (Exception e) {
                    this.println("grep: exception reading Advertisement. " + e.toString());
                    return Integer.MAX_VALUE;
                }
            }
            if ((class$net$jxta$document$Document == null ? (class$net$jxta$document$Document = grep.class$("net.jxta.document.Document")) : class$net$jxta$document$Document).isInstance(objContent)) {
                try {
                    this.readDocument((Document)objContent);
                    return 0;
                }
                catch (Exception e) {
                    this.println("grep: exception reading Document. " + e.toString());
                    return Integer.MAX_VALUE;
                }
            }
            this.println("grep: cannot read this kind of object.");
            return Integer.MAX_VALUE;
        }
        catch (Exception ex) {
            this.println("grep: exception " + ex.toString());
            ex.printStackTrace();
            return Integer.MAX_VALUE;
        }
    }

    protected int syntaxError() {
        this.println("Usage: " + this.syntax());
        return 1;
    }

    protected void readStdin() throws IOException {
        String inData = null;
        inData = this.inputPipe == this.consin ? this.readStdinConsole() : this.readStdinPipe();
        this.grepData(inData);
    }

    protected String readStdinConsole() throws IOException {
        String moreData;
        String inData = "";
        while ((moreData = this.waitForInput()) != null && !moreData.equals(".")) {
            inData = inData + moreData + "\n";
        }
        return inData;
    }

    protected String readStdinPipe() throws IOException {
        String moreData;
        String inData = this.waitForInput();
        while ((moreData = this.pollInput()) != null) {
            inData = inData + moreData;
        }
        return inData;
    }

    protected void readAdvertisement(Advertisement adv) throws Exception {
        Document doc = adv.getDocument(new MimeMediaType("text/xml"));
        this.readDocument(doc);
    }

    protected void readDocument(Document doc) throws Exception {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        doc.sendToStream((OutputStream)out);
        this.grepData(out.toString());
    }

    protected void grepData(String inData) {
        int matchCount = 0;
        int lineNum = 0;
        if (this.ignoreCase) {
            this.pattern = this.pattern.toLowerCase();
        }
        String delim = "\n";
        StringTokenizer tokens = new StringTokenizer(inData, delim, true);
        String line = null;
        String prevLine = delim;
        String compLine = null;
        try {
            while (tokens.hasMoreTokens()) {
                boolean match = false;
                line = tokens.nextToken();
                if (line.equals(delim) && !prevLine.equals(delim)) {
                    prevLine = line;
                    continue;
                }
                ++lineNum;
                prevLine = line;
                compLine = this.ignoreCase ? line.toLowerCase() : line;
                if (compLine.indexOf(this.pattern) >= 0) {
                    match = true;
                    ++matchCount;
                }
                if (this.countOnly || (!match || this.invertMatch) && (match || !this.invertMatch)) continue;
                if (this.showLineNums) {
                    this.print(String.valueOf(lineNum) + ":");
                }
                if (line.equals(delim)) {
                    this.println("");
                    continue;
                }
                this.println(line);
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        if (this.countOnly) {
            if (this.invertMatch) {
                this.println(String.valueOf(lineNum - matchCount));
            } else {
                this.println(String.valueOf(matchCount));
            }
        }
    }

    protected String syntax() {
        return "grep [-c -i -n -v] searchPattern [<objectName>]";
    }

    public String getDescription() {
        return "Search for matching patterns";
    }

    public void help() {
        this.println("NAME");
        this.println("     grep  - search for matching patterns.");
        this.println("");
        this.println("SYNOPSIS");
        this.println("");
        this.println("     " + this.syntax());
        this.println("");
        this.println("DESCRIPTION");
        this.println("");
        this.println("'grep' searches the named shell object for lines containing a");
        this.println("match to the given search pattern.  Matching lines are written");
        this.println("to output.  Regular expressions are not currently supported.");
        this.println("");
        this.println("If no object is specifed on the command line, grep will read from");
        this.println("stdin.  If stdin is the console, you may type in lines of text.");
        this.println("Enter a '.' all by itself at the beginning of a line to finish.");
        this.println("");
        this.println("OPTIONS");
        this.println("");
        this.println("  -c   Just print count of matching lines. With -v, count non-matching.");
        this.println("  -i   Ignore case when comparing text with search pattern.");
        this.println("  -n   Show line numbers of matches found.");
        this.println("  -v   Invert the sense of matching, to select non-matching lines.");
        this.println("");
        this.println("EXAMPLES");
        this.println("");
        this.println("    JXTA>grep -i -n dog GroceryList");
        this.println("    3:Hot dogs");
        this.println("    7:Dog food");
        this.println("");
        this.println("    JXTA>cat GroceryList | grep -c dog");
        this.println("    2");
        this.println("");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

