/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.shell.bin.chpgrp;

import net.jxta.impl.shell.ShellApp;
import net.jxta.impl.shell.ShellEnv;
import net.jxta.impl.shell.ShellObject;
import net.jxta.peergroup.PeerGroup;

public class chpgrp
extends ShellApp {
    private ShellEnv env;
    private String newname = null;

    public int startApp(String[] args) {
        this.env = this.getEnv();
        if (args == null || args.length != 1) {
            return this.syntaxError();
        }
        this.newname = args[0];
        if (!this.exist(this.newname)) {
            return 1;
        }
        ShellObject obj = this.env.get("PG#" + this.newname);
        if (obj == null) {
            obj = this.env.get("PG@" + this.newname);
        }
        if (obj == null) {
            this.println("The peergroup " + this.newname + " does not exist!");
        }
        PeerGroup npg = (PeerGroup)obj.getObject();
        this.env.add("stdgroup", new ShellObject("PeerGroup", npg));
        return 0;
    }

    private boolean exist(String name) {
        ShellObject obj = this.env.get("PG#" + name);
        if (obj == null) {
            obj = this.env.get("PG@" + name);
            if (obj == null) {
                this.println("There is no group of this name or you have not joined this group yet ");
                return false;
            }
            ShellObject sg = this.env.get("stdgroup");
            if (sg.getObject() == obj.getObject()) {
                this.println("This is already the stdgroup of this shell");
                return false;
            }
            return true;
        }
        this.println("Please join the group first");
        return false;
    }

    public void stopApp() {
    }

    private int syntaxError() {
        this.println("Usage: chgrp name]");
        return 1;
    }

    public String getDescription() {
        return "Change the current peer group";
    }

    public void help() {
        this.println("NAME");
        this.println("     chpgrp  - change the current peer group ");
        this.println(" ");
        this.println("SYNOPSIS");
        this.println(" ");
        this.println("     chpgrp <name>");
        this.println(" ");
        this.println("DESCRIPTION");
        this.println(" ");
        this.println("The 'chpgrp' command is used to switch the default Shell peer");
        this.println("group 'stdgroup' variable to another group that was previously");
        this.println("joined via a 'join' command. The 'join' command is used to join");
        this.println("a peergroup.");
        this.println("After changing group, the Shell 'stdgroup' variable");
        this.println("is set to the value of the new peer group joined.");
        this.println(" ");
        this.println("EXAMPLE");
        this.println(" ");
        this.println("       JXTA>mygroupadv = mkadv -g mygroup");
        this.println("       JXTA>mkpgrp -d mygroupadv mygroup");
        this.println("       JXTA>join mygroup");
        this.println("       JXTA>chpgrp moi");
        this.println(" ");
        this.println(" This creates a new peergroup which is cloning the services");
        this.println(" of the parent peer group. You can find the services of the");
        this.println(" current peer group via the command 'whoami -g'. The new group");
        this.println(" is given the name 'mygroup'. Before you can do anything with");
        this.println(" the group you need to join the group via the 'join' command.");
        this.println(" The 'chpgrp' command is used to change the default group");
        this.println(" to the new group 'moi'.");
        this.println(" ");
        this.println("SEE ALSO");
        this.println("     mkadv mkpgrp join");
    }
}

