/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.shell.bin.cat;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.NoSuchElementException;
import net.jxta.document.Advertisement;
import net.jxta.document.Document;
import net.jxta.document.MimeMediaType;
import net.jxta.document.StructuredDocument;
import net.jxta.document.StructuredDocumentFactory;
import net.jxta.document.StructuredTextDocument;
import net.jxta.endpoint.Message;
import net.jxta.endpoint.MessageElement;
import net.jxta.impl.shell.ShellApp;
import net.jxta.impl.shell.ShellEnv;
import net.jxta.impl.shell.ShellObject;
import net.jxta.protocol.PeerInfoResponseMessage;
import net.jxta.util.StringEnumeration;

public class cat
extends ShellApp {
    ShellEnv env;
    static /* synthetic */ Class class$net$jxta$document$Advertisement;
    static /* synthetic */ Class class$net$jxta$document$StructuredDocument;
    static /* synthetic */ Class class$net$jxta$document$Document;
    static /* synthetic */ Class class$net$jxta$endpoint$Message;
    static /* synthetic */ Class class$net$jxta$protocol$PeerInfoResponseMessage;

    public void stopApp() {
    }

    public int startApp(String[] args) {
        Object catobj;
        String name = null;
        boolean pretty = false;
        if (args == null || args.length < 1) {
            this.println("error: cat [-p] <var>");
            return 1;
        }
        int argsIndex = 0;
        if (args[argsIndex].toLowerCase().equals("-p")) {
            pretty = true;
            ++argsIndex;
        }
        name = args[argsIndex];
        this.env = this.getEnv();
        ShellObject obj = this.env.get(name);
        if (obj == null) {
            this.println("cat: cannot access " + name);
            return Integer.MAX_VALUE;
        }
        if ((class$net$jxta$document$Advertisement == null ? (class$net$jxta$document$Advertisement = cat.class$("net.jxta.document.Advertisement")) : class$net$jxta$document$Advertisement).isInstance(catobj = obj.getObject())) {
            try {
                this.catAdvertisement((Advertisement)obj.getObject(), pretty);
            }
            catch (Exception e) {
                this.println("cat: error printing Advertisement object. ");
                StringWriter theStackTrace = new StringWriter();
                e.printStackTrace(new PrintWriter(theStackTrace));
                this.print(theStackTrace.toString());
                return Integer.MAX_VALUE;
            }
        } else {
            if ((class$net$jxta$document$StructuredDocument == null ? (class$net$jxta$document$StructuredDocument = cat.class$("net.jxta.document.StructuredDocument")) : class$net$jxta$document$StructuredDocument).isInstance(catobj)) {
                try {
                    this.catStructuredDocument((StructuredDocument)obj.getObject());
                    return 0;
                }
                catch (Exception e) {
                    this.println("cat: error printing StructuredDocument object. ");
                    StringWriter theStackTrace = new StringWriter();
                    e.printStackTrace(new PrintWriter(theStackTrace));
                    this.print(theStackTrace.toString());
                    return Integer.MAX_VALUE;
                }
            }
            if ((class$net$jxta$document$Document == null ? (class$net$jxta$document$Document = cat.class$("net.jxta.document.Document")) : class$net$jxta$document$Document).isInstance(catobj)) {
                try {
                    ByteArrayOutputStream out = new ByteArrayOutputStream();
                    Document doc = (Document)catobj;
                    doc.sendToStream((OutputStream)out);
                    this.println(out.toString());
                }
                catch (Exception e) {
                    this.println("cat: error printing Document object. ");
                    StringWriter theStackTrace = new StringWriter();
                    e.printStackTrace(new PrintWriter(theStackTrace));
                    this.print(theStackTrace.toString());
                    return Integer.MAX_VALUE;
                }
            } else if ((class$net$jxta$endpoint$Message == null ? (class$net$jxta$endpoint$Message = cat.class$("net.jxta.endpoint.Message")) : class$net$jxta$endpoint$Message).isInstance(catobj)) {
                try {
                    this.catJxtaMessage((Message)obj.getObject());
                }
                catch (Exception e) {
                    this.println("cat: error printing Message object. ");
                    StringWriter theStackTrace = new StringWriter();
                    e.printStackTrace(new PrintWriter(theStackTrace));
                    this.print(theStackTrace.toString());
                    return Integer.MAX_VALUE;
                }
            } else if ((class$net$jxta$protocol$PeerInfoResponseMessage == null ? (class$net$jxta$protocol$PeerInfoResponseMessage = cat.class$("net.jxta.protocol.PeerInfoResponseMessage")) : class$net$jxta$protocol$PeerInfoResponseMessage).isInstance(catobj)) {
                try {
                    PeerInfoResponseMessage resp = (PeerInfoResponseMessage)catobj;
                    StringWriter out = new StringWriter();
                    MimeMediaType displayAs = pretty ? new MimeMediaType("text/plain") : new MimeMediaType("text/xml");
                    StructuredTextDocument doc = (StructuredTextDocument)resp.getDocument(displayAs);
                    doc.sendToWriter((Writer)out);
                    this.print(out.toString());
                }
                catch (Exception e) {
                    this.println("cat: error printing Document object. ");
                    StringWriter theStackTrace = new StringWriter();
                    e.printStackTrace(new PrintWriter(theStackTrace));
                    this.print(theStackTrace.toString());
                    return Integer.MAX_VALUE;
                }
            } else {
                this.println(catobj.toString());
            }
        }
        return 0;
    }

    private void catStructuredDocument(StructuredDocument doc) throws Exception {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        doc.sendToStream((OutputStream)out);
        this.print(((Object)out).toString());
    }

    private void catAdvertisement(Advertisement adv, boolean pretty) throws Exception {
        StringWriter out = new StringWriter();
        MimeMediaType displayAs = pretty ? new MimeMediaType("text/plain") : new MimeMediaType("text/xml");
        StructuredTextDocument doc = (StructuredTextDocument)adv.getDocument(displayAs);
        doc.sendToWriter((Writer)out);
        this.print(out.toString());
    }

    private void catJxtaMessage(Message msg) {
        StringEnumeration names = msg.getNames();
        while (names.hasMoreElements()) {
            String name = null;
            try {
                name = (String)names.nextElement();
            }
            catch (Exception e) {
                break;
            }
            this.catJxtaMessage(msg, name);
        }
    }

    private void catJxtaMessage(Message msg, String name) {
        MessageElement elem = null;
        InputStream input = null;
        try {
            elem = msg.getElement(name);
            input = elem.getStream();
        }
        catch (Exception e) {
            this.println("cat: message has an empty tag body: " + name);
        }
        if (input == null) {
            this.println("cat: message has an empty tag body: " + name);
            return;
        }
        this.println("Tag: " + name);
        this.println("Body:");
        try {
            StructuredDocument doc = null;
            try {
                doc = StructuredDocumentFactory.newStructuredDocument((MimeMediaType)elem.getType(), (InputStream)input);
            }
            catch (NoSuchElementException notadoc) {
                this.println("Body of type : '" + elem.getType().toString() + "' is not printable.");
                return;
            }
            this.catStructuredDocument(doc);
        }
        catch (Exception e) {
            this.print("cat: the message has been corrupted. Reason:");
            this.println("cat: error printing Message object. ");
            StringWriter theStackTrace = new StringWriter();
            e.printStackTrace(new PrintWriter(theStackTrace));
            this.print(theStackTrace.toString());
        }
    }

    public String getDescription() {
        return "Concatanate and display a Shell object";
    }

    public void help() {
        this.println("NAME");
        this.println("     cat  - Concatanate and display a Shell object");
        this.println(" ");
        this.println("SYNOPSIS");
        this.println(" ");
        this.println("     cat [-p] <objectName>");
        this.println(" ");
        this.println("DESCRIPTION");
        this.println(" ");
        this.println("'cat' is the Shell command that displays on stdout the content ");
        this.println("of objects stored in environment variables. 'cat' knows");
        this.println("how to display a limited (but growing) set of JXTA objects");
        this.println("Advertisement, Message and StructuredDocument)");
        this.println("If you are not sure, try to cat the object anyway: the");
        this.println("command will let you know if it can or not display that");
        this.println("object.");
        this.println(" ");
        this.println("OPTIONS");
        this.println(" ");
        this.println("    -p Pretty display");
        this.println(" ");
        this.println("EXAMPLE");
        this.println(" ");
        this.println("    JXTA> importfile -f /home/tra/myfile myfile");
        this.println("    JXTA> cat -p myfile");
        this.println(" ");
        this.println("This command imports the file '/home/tra/myfile' into the");
        this.println("'myfile' environment variable and displays it on stdout");
        this.println(" ");
        this.println("SEE ALSO");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

