/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.shell;

import net.jxta.endpoint.Message;
import net.jxta.impl.shell.ShellConsole;
import net.jxta.impl.shell.ShellMessageQueue;
import net.jxta.peergroup.PeerGroup;
import net.jxta.pipe.InputPipe;
import net.jxta.pipe.PipeService;

public class ShellInputPipe
implements InputPipe,
Runnable {
    private PeerGroup group;
    private PipeService pipes;
    private ShellConsole cons;
    private ShellMessageQueue queue;
    private volatile boolean closed = false;
    private Thread thread = null;

    public ShellInputPipe(PeerGroup group, ShellConsole cons) {
        this.group = group;
        this.cons = cons;
        this.queue = new ShellMessageQueue();
        this.pipes = group.getPipeService();
        this.thread = new Thread((Runnable)this, "ShellInputPipe-" + cons.getConsoleName());
        this.thread.start();
    }

    public void run() {
        try {
            while (true) {
                Message msg;
                String tmp = this.cons.read();
                if (this.closed) break;
                if (tmp == null) continue;
                if (0 == tmp.length()) {
                    tmp = " ";
                }
                if ((msg = this.pipes.createMessage()) == null) continue;
                try {
                    msg.setString("ShellInputPipe", tmp);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    continue;
                }
                this.queue.push(msg);
            }
        }
        catch (Throwable all) {
            System.out.flush();
            System.err.println("Uncaught Throwable in thread :" + Thread.currentThread().getName());
            all.printStackTrace(System.err);
        }
    }

    public Message waitForMessage() throws InterruptedException {
        return this.queue.poll(0L);
    }

    public Message poll(int time) throws InterruptedException {
        return this.queue.poll(time);
    }

    public synchronized void close() {
        this.closed = true;
        this.queue.close();
        if (this.thread != null) {
            this.thread.interrupt();
        }
    }
}

